/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.mimetype.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class MimeTypeMapper {
    private HashMap mimeTypeExtensions = new HashMap();
    protected HashMap extensionMimeTypes = new HashMap();

    public MimeTypeMapper() {
    }

    public MimeTypeMapper(InputStream inputStream) throws IOException {
        this.parse(new BufferedReader(new InputStreamReader(inputStream, "ISO-8859-1")));
    }

    public MimeTypeMapper(File file) throws IOException {
        FileReader fileReader = new FileReader(file);
        try {
            this.parse(new BufferedReader(fileReader));
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                fileReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            fileReader.close();
        }
        catch (IOException iOException) {}
    }

    public MimeTypeMapper(String string) throws IOException {
        this(new File(string));
    }

    public void setContentType(String string) {
        try {
            this.parse(new BufferedReader(new StringReader(string)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getContentType(String string) {
        return (String)this.mimeTypeExtensions.get(string);
    }

    public String getExtension(String string) {
        return (String)this.extensionMimeTypes.get(string);
    }

    protected synchronized void parse(BufferedReader bufferedReader) throws IOException {
        String string;
        int n = 0;
        String string2 = null;
        HashMap hashMap = (HashMap)this.extensionMimeTypes.clone();
        HashMap hashMap2 = (HashMap)this.mimeTypeExtensions.clone();
        while ((string = bufferedReader.readLine()) != null) {
            int n2 = (string2 = string2 == null ? string : string2 + string).length();
            if (n2 == 0) {
                string2 = null;
                continue;
            }
            if (string2.charAt(n2 - 1) != '\\') {
                n += this.parseMimeTypeExtension(string2, hashMap, hashMap2);
                string2 = null;
                continue;
            }
            string2 = string2.substring(0, n2 - 1);
        }
        if (string2 != null) {
            n += this.parseMimeTypeExtension(string2, hashMap, hashMap2);
        }
        if (n > 0) {
            this.extensionMimeTypes = hashMap;
            this.mimeTypeExtensions = hashMap2;
        }
    }

    protected int parseMimeTypeExtension(String string, Map map, Map map2) {
        int n = 0;
        if ((string = string.trim()).length() > 0 && string.charAt(0) != '#') {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string2 = stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3.length() == 0) continue;
                map2.put(string3, string2);
                if (n++ != 0) continue;
                map.put(string2, string3);
            }
        }
        return n;
    }
}

