/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.schedule;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import org.apache.fulcrum.schedule.JobEntry;

public class JobQueue {
    private Vector queue = new Vector(10);

    public JobEntry getNext() {
        if (this.queue.size() > 0) {
            return (JobEntry)this.queue.elementAt(0);
        }
        return null;
    }

    public JobEntry getJob(JobEntry jobEntry) {
        int n = -1;
        if (jobEntry != null) {
            n = this.queue.indexOf(jobEntry);
        }
        if (n < 0) {
            return null;
        }
        return (JobEntry)this.queue.elementAt(n);
    }

    public Vector list() {
        if (this.queue != null && this.queue.size() > 0) {
            return (Vector)this.queue.clone();
        }
        return null;
    }

    public synchronized void add(JobEntry jobEntry) {
        this.queue.addElement(jobEntry);
        this.sortQueue();
    }

    public synchronized void batchLoad(List list) {
        if (list != null) {
            this.queue.addAll(list);
            this.sortQueue();
        }
    }

    public synchronized void remove(JobEntry jobEntry) {
        this.queue.removeElement(jobEntry);
        this.sortQueue();
    }

    public synchronized void modify(JobEntry jobEntry) {
        this.sortQueue();
    }

    public synchronized void updateQueue(JobEntry jobEntry) throws Exception {
        jobEntry.calcRunTime();
        this.sortQueue();
    }

    private void sortQueue() {
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                Long l = new Long(((JobEntry)object).getNextRuntime());
                Long l2 = new Long(((JobEntry)object2).getNextRuntime());
                return l.compareTo(l2);
            }
        };
        Collections.sort(this.queue, comparator);
    }
}

