/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.schedule;

import java.util.Vector;
import org.apache.fulcrum.InitializationException;
import org.apache.fulcrum.schedule.JobEntry;
import org.apache.fulcrum.schedule.JobQueue;
import org.apache.fulcrum.schedule.TurbineSchedulerService;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;

public class TurbineNonPersistentSchedulerService
extends TurbineSchedulerService {
    public void init() throws InitializationException {
        try {
            this.scheduleQueue = new JobQueue();
            this.mainLoop = new TurbineSchedulerService.MainLoop();
            Vector vector = this.getConfiguration().getVector("scheduler.jobs");
            Vector<JobEntry> vector2 = new Vector<JobEntry>();
            if (!vector.isEmpty()) {
                int n = 0;
                while (n < vector.size()) {
                    String string = (String)vector.elementAt(n);
                    String string2 = "scheduler.job." + string;
                    if (this.getConfiguration().getString(string2 + ".ID", null) == null) {
                        throw new Exception("There is an error in the TurbineResources.properties file. \n" + string2 + ".ID is not found.\n");
                    }
                    int n2 = this.getConfiguration().getInt(string2 + ".SECOND", -1);
                    int n3 = this.getConfiguration().getInt(string2 + ".MINUTE", -1);
                    int n4 = this.getConfiguration().getInt(string2 + ".HOUR", -1);
                    int n5 = this.getConfiguration().getInt(string2 + ".WEEKDAY", -1);
                    int n6 = this.getConfiguration().getInt(string2 + ".DAY_OF_MONTH", -1);
                    JobEntry jobEntry = new JobEntry(n2, n3, n4, n5, n6, string);
                    vector2.addElement(jobEntry);
                    ++n;
                }
            }
            if (vector2 != null && vector2.size() > 0) {
                this.scheduleQueue.batchLoad(vector2);
                this.restart();
            }
            this.setInit(true);
        }
        catch (Exception exception) {
            this.getCategory().error((Object)"Cannot initialize TurbineNonPersistentSchedulerService!: ", (Throwable)exception);
        }
    }

    public JobEntry getJob(int n) throws Exception {
        JobEntry jobEntry = new JobEntry(-1, -1, -1, -1, -1, null);
        jobEntry.setPrimaryKey((ObjectKey)new NumberKey(n));
        return this.scheduleQueue.getJob(jobEntry);
    }

    public void addJob(JobEntry jobEntry) throws Exception {
        this.scheduleQueue.add(jobEntry);
        this.restart();
    }

    public void removeJob(JobEntry jobEntry) throws Exception {
        this.scheduleQueue.remove(jobEntry);
        this.restart();
    }

    public void updateJob(JobEntry jobEntry) throws Exception {
        try {
            jobEntry.calcRunTime();
        }
        catch (Exception exception) {
            this.getCategory().error((Object)("Problem updating Scheduled Job: " + exception));
        }
        this.scheduleQueue.modify(jobEntry);
        this.restart();
    }
}

