/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.impl.db.entity;

import java.util.Iterator;
import org.apache.fulcrum.security.TurbineSecurity;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.SecurityEntity;
import org.apache.fulcrum.security.impl.db.entity.BaseTurbineRole;
import org.apache.fulcrum.security.util.PermissionSet;
import org.apache.fulcrum.security.util.TurbineSecurityException;

public class TurbineRole
extends BaseTurbineRole
implements Role,
Comparable {
    private PermissionSet permissionSet = null;

    public TurbineRole() {
    }

    public TurbineRole(String string) {
        this.setName(string);
    }

    public PermissionSet getPermissions() throws Exception {
        return this.permissionSet;
    }

    public void setPermissions(PermissionSet permissionSet) {
        this.permissionSet = permissionSet;
    }

    public Role create(String string) throws TurbineSecurityException {
        TurbineRole turbineRole = new TurbineRole(string);
        TurbineSecurity.addRole(turbineRole);
        return turbineRole;
    }

    public void save() throws TurbineSecurityException {
        TurbineSecurity.saveRole(this);
    }

    public void remove() throws TurbineSecurityException {
        TurbineSecurity.removeRole(this);
    }

    public void rename(String string) throws TurbineSecurityException {
        TurbineSecurity.renameRole(this, string);
    }

    public void grant(Permission permission) throws TurbineSecurityException {
        TurbineSecurity.grant(this, permission);
    }

    public void grant(PermissionSet permissionSet) throws TurbineSecurityException {
        Iterator iterator = permissionSet.elements();
        while (iterator.hasNext()) {
            TurbineSecurity.grant(this, (Permission)iterator.next());
        }
    }

    public void revoke(Permission permission) throws TurbineSecurityException {
        TurbineSecurity.revoke(this, permission);
    }

    public void revoke(PermissionSet permissionSet) throws TurbineSecurityException {
        Iterator iterator = permissionSet.elements();
        while (iterator.hasNext()) {
            TurbineSecurity.revoke(this, (Permission)iterator.next());
        }
    }

    public int compareTo(Object object) {
        if (this.getClass() != object.getClass()) {
            throw new ClassCastException();
        }
        String string = ((SecurityEntity)object).getName();
        String string2 = this.getName();
        return string2.compareTo(string);
    }
}

