/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.impl.db.entity;

import java.util.Vector;
import org.apache.fulcrum.security.TurbineSecurity;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.impl.db.DBSecurityService;
import org.apache.fulcrum.security.impl.db.entity.BaseTurbineRolePeer;
import org.apache.fulcrum.security.impl.db.entity.BaseTurbineUserGroupRolePeer;
import org.apache.fulcrum.security.impl.db.entity.BaseTurbineUserPeer;
import org.apache.fulcrum.security.impl.db.entity.TurbineUserPeer;
import org.apache.fulcrum.security.impl.db.entity.UserPeer;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.RoleSet;
import org.apache.torque.om.Persistent;
import org.apache.torque.util.BasePeer;
import org.apache.torque.util.Criteria;

public class TurbineRolePeer
extends BaseTurbineRolePeer {
    public static final String NAME = BaseTurbineRolePeer.ROLE_NAME;

    public static boolean checkExists(Role role) throws DataBackendException, Exception {
        Criteria criteria = new Criteria();
        criteria.addSelectColumn(BaseTurbineRolePeer.ROLE_ID);
        criteria.add(NAME, (Object)role.getName());
        Vector vector = BasePeer.doSelect((Criteria)criteria);
        if (vector.size() > 1) {
            throw new DataBackendException("Multiple roles named '" + role.getName() + "' exist!");
        }
        return vector.size() == 1;
    }

    public static String getColumnName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TURBINE_ROLE");
        stringBuffer.append(".");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String getTableName() {
        return "TURBINE_ROLE";
    }

    public static RoleSet retrieveSet(Criteria criteria) throws Exception {
        Vector vector = BaseTurbineRolePeer.doSelect(criteria);
        RoleSet roleSet = new RoleSet();
        int n = 0;
        while (n < vector.size()) {
            roleSet.add((Role)vector.elementAt(n));
            ++n;
        }
        return roleSet;
    }

    public static RoleSet retrieveSet(User user, Group group) throws Exception {
        Criteria criteria = new Criteria();
        UserPeer userPeer = ((DBSecurityService)TurbineSecurity.getService()).getUserPeerInstance();
        criteria.add(TurbineUserPeer.USERNAME, (Object)user.getUserName());
        criteria.add(BaseTurbineUserGroupRolePeer.GROUP_ID, (Object)((Persistent)group).getPrimaryKey());
        criteria.addJoin(BaseTurbineUserPeer.USER_ID, BaseTurbineUserGroupRolePeer.USER_ID);
        criteria.addJoin(BaseTurbineUserGroupRolePeer.ROLE_ID, BaseTurbineRolePeer.ROLE_ID);
        return TurbineRolePeer.retrieveSet(criteria);
    }
}

