/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.impl.db.entity;

import java.util.Vector;
import org.apache.fulcrum.security.TurbineSecurity;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.impl.db.entity.BaseTurbineUserPeer;
import org.apache.fulcrum.security.impl.db.entity.UserPeer;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.torque.TorqueException;
import org.apache.torque.util.BasePeer;
import org.apache.torque.util.Criteria;

public class TurbineUserPeer
extends BaseTurbineUserPeer
implements UserPeer {
    public static final String USERNAME = BaseTurbineUserPeer.LOGIN_NAME;
    public static Class userClass = null;

    public static Class getOMClass() throws TorqueException {
        if (userClass == null) {
            String string = TurbineSecurity.getService().getConfiguration().getString("user.class", "org.apache.turbine.om.security.TurbineUser");
            try {
                userClass = Class.forName(string);
            }
            catch (Exception exception) {
                throw new TorqueException((Throwable)exception);
            }
        }
        return userClass;
    }

    public static String getColumnName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TURBINE_USER");
        stringBuffer.append(".");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public String getFullColumnName(String string) {
        return TurbineUserPeer.getColumnName(string);
    }

    public static String getTableName() {
        return "TURBINE_USER";
    }

    public static boolean checkExists(User user) throws DataBackendException, Exception {
        Criteria criteria = new Criteria();
        criteria.addSelectColumn(BaseTurbineUserPeer.USER_ID);
        criteria.add(USERNAME, (Object)user.getUserName());
        Vector vector = BasePeer.doSelect((Criteria)criteria);
        if (vector.size() > 1) {
            throw new DataBackendException("Multiple users named '" + user.getUserName() + "' exist!");
        }
        return vector.size() == 1;
    }

    public static Vector selectAllUsers() throws Exception {
        Criteria criteria = new Criteria();
        criteria.addAscendingOrderByColumn(BaseTurbineUserPeer.LAST_NAME);
        criteria.addAscendingOrderByColumn(BaseTurbineUserPeer.FIRST_NAME);
        criteria.setIgnoreCase(true);
        return BaseTurbineUserPeer.doSelect(criteria);
    }

    public static Vector selectAllConfirmedUsers() throws Exception {
        Criteria criteria = new Criteria();
        criteria.add("CONFIRM_VALUE", (Object)"CONFIRMED");
        criteria.addAscendingOrderByColumn(BaseTurbineUserPeer.LAST_NAME);
        criteria.addAscendingOrderByColumn(BaseTurbineUserPeer.FIRST_NAME);
        criteria.setIgnoreCase(true);
        return BaseTurbineUserPeer.doSelect(criteria);
    }
}

