/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.upload;

import java.io.File;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.fulcrum.BaseService;
import org.apache.fulcrum.InitializationException;
import org.apache.fulcrum.ServiceException;
import org.apache.fulcrum.upload.UploadService;

public class TurbineUploadService
extends BaseService
implements UploadService {
    protected Object component;
    private boolean automatic;

    public void init() throws InitializationException {
        String string = this.getConfiguration().getString("repository", ".");
        String string2 = this.getRealPath(string);
        File file = new File(string2);
        if (file.exists()) {
            string = string2;
        }
        this.getConfiguration().setProperty("repository", (Object)string);
        this.getCategory().debug((Object)("Upload Service: REPOSITORY_KEY => " + string));
        FileUpload fileUpload = new FileUpload();
        this.automatic = this.getConfiguration().getBoolean("automatic", false);
        fileUpload.setSizeMax(this.getConfiguration().getInt("size.max", 0x100000));
        fileUpload.setSizeThreshold(this.getConfiguration().getInt("size.threshold", 10240));
        fileUpload.setRepositoryPath(this.getConfiguration().getString("repository", "."));
        this.component = fileUpload;
        this.setInit(true);
    }

    public Object getComponent() {
        return this.component;
    }

    public boolean getAutomatic() {
        return this.automatic;
    }

    public int getSizeMax() {
        return ((FileUpload)this.getComponent()).getSizeMax();
    }

    public int getSizeThreshold() {
        return ((FileUpload)this.getComponent()).getSizeThreshold();
    }

    public String getRepository() {
        return ((FileUpload)this.getComponent()).getRepositoryPath();
    }

    public ArrayList parseRequest(HttpServletRequest httpServletRequest, String string) throws ServiceException {
        try {
            return (ArrayList)((FileUpload)this.getComponent()).parseRequest(httpServletRequest, string);
        }
        catch (FileUploadException fileUploadException) {
            throw new ServiceException(fileUploadException);
        }
    }
}

