/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.facilities;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipMFacility;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.facilities.FacilityResultData;
import com.aimluck.eip.facilities.util.FacilitiesUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class FacilityChangeTurnFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)FacilityChangeTurnFormData.class.getName());
    private ALStringField positions;
    private String[] facilityIds = null;
    private List<FacilityResultData> facilityList = null;
    private List<EipMFacility> rawFacilityList = null;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.facilityList = new ArrayList<FacilityResultData>();
        this.rawFacilityList = new ArrayList<EipMFacility>();
    }

    public void initField() {
        this.positions = new ALStringField();
        this.positions.setFieldName(ALLocalizationUtils.getl10n((String)"FACILITIES_FACILITY_NAME_LIST"));
        this.positions.setTrim(true);
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = true;
        try {
            res = super.setFormData(rundata, context, msgList);
            if (res) {
                if (this.positions.getValue() == null || this.positions.getValue().equals("")) {
                    SelectQuery query = Database.query(EipMFacility.class);
                    query.orderAscending("sort");
                    this.facilityList = FacilitiesUtils.getFacilityResultList(query.fetchList());
                } else {
                    StringTokenizer st = new StringTokenizer(this.positions.getValue(), ",");
                    this.facilityIds = new String[st.countTokens()];
                    int count = 0;
                    while (st.hasMoreTokens()) {
                        this.facilityIds[count] = st.nextToken();
                        ++count;
                    }
                    SelectQuery query = Database.query(EipMFacility.class);
                    List list = query.fetchList();
                    for (int i = 0; i < this.facilityIds.length; ++i) {
                        EipMFacility facility = this.getEipMFacilityFromFacilityId(list, this.facilityIds[i]);
                        this.facilityList.add(FacilitiesUtils.getFacilityResultData(facility));
                        this.rawFacilityList.add(facility);
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"facilities", (Throwable)ex);
            return false;
        }
        return res;
    }

    protected void setValidator() {
    }

    protected boolean validate(List<String> msgList) {
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"facilities", (Throwable)e);
            return false;
        }
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        boolean res = true;
        try {
            int newPosition = 1;
            for (EipMFacility facility : this.rawFacilityList) {
                facility.setSort(Integer.valueOf(newPosition));
                ++newPosition;
            }
            Database.commit();
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"facilities", (Throwable)e);
            res = false;
        }
        return res;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    protected boolean isSymbol(char ch) {
        byte[] chars;
        try {
            chars = Character.valueOf(ch).toString().getBytes("shift_jis");
        }
        catch (UnsupportedEncodingException ex) {
            return false;
        }
        return chars != null && chars.length != 2 && !Character.isDigit(ch) && !Character.isLetter(ch);
    }

    private EipMFacility getEipMFacilityFromFacilityId(List<EipMFacility> facilityList, String facilityId) {
        for (int i = 0; i < facilityList.size(); ++i) {
            EipMFacility facility = facilityList.get(i);
            if (!facility.getFacilityId().toString().equals(facilityId)) continue;
            return facility;
        }
        return null;
    }

    public List<FacilityResultData> getFacilityList() {
        return this.facilityList;
    }
}

