/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.facilities;

import com.aimluck.eip.cayenne.om.portlet.EipMFacility;
import com.aimluck.eip.cayenne.om.portlet.EipMFacilityGroupMap;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.facilities.FacilityGroupResultData;
import com.aimluck.eip.facilities.FacilityResultData;
import com.aimluck.eip.facilities.util.FacilitiesUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.Operations;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class FacilitySelectData
extends ALAbstractSelectData<EipMFacility, EipMFacility>
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)FacilitySelectData.class.getName());
    private int facilitySum;
    private List<FacilityGroupResultData> AllFacilitygroup;
    protected String viewtype;
    private List<FacilityResultData> facilityAllList;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        this.loadFacilityAllList(rundata, context);
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p2a-sort"));
        }
        this.AllFacilitygroup = FacilitiesUtils.getFacilityGroupAllList();
        super.init(action, rundata, context);
        this.viewtype = "facility";
    }

    public ResultList<EipMFacility> selectList(RunData rundata, Context context) {
        try {
            SelectQuery<EipMFacility> query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            ResultList list = query.getResultList();
            this.facilitySum = list.getTotalCount();
            return list;
        }
        catch (Exception ex) {
            logger.error((Object)"facilities", (Throwable)ex);
            return null;
        }
    }

    private SelectQuery<EipMFacility> getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = Database.query(EipMFacility.class);
        return this.buildSelectQueryForFilter((SelectQuery<EipMFacility>)query, rundata, context);
    }

    protected Object getResultData(EipMFacility record) {
        try {
            FacilityResultData rd = new FacilityResultData();
            rd.initField();
            rd.setFacilityId(record.getFacilityId().longValue());
            rd.setFacilityName(record.getFacilityName());
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"facilities", (Throwable)ex);
            return null;
        }
    }

    protected SelectQuery<EipMFacility> buildSelectQueryForFilter(SelectQuery<EipMFacility> query, RunData rundata, Context context) {
        String filter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR);
        String filter_type = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR);
        String crt_key = null;
        Attributes map = this.getColumnMap();
        if (filter == null || filter_type == null || filter.equals("")) {
            return query;
        }
        crt_key = map.getValue(filter_type);
        if (crt_key == null) {
            return query;
        }
        if (crt_key.equals("GroupId")) {
            SelectQuery mapquery = Database.query(EipMFacilityGroupMap.class);
            mapquery.where(Operations.eq((String)"GroupId", (Object)Integer.valueOf(filter)));
            List facilityGroupMapList = mapquery.fetchList();
            ArrayList<Integer> facilityIdList = new ArrayList<Integer>();
            for (EipMFacilityGroupMap fmap : facilityGroupMapList) {
                facilityIdList.add(fmap.getFacilityId());
            }
            if (facilityIdList.size() == 0) {
                facilityIdList.add(0);
            }
            Expression exp = ExpressionFactory.inDbExp((String)"FACILITY_ID", facilityIdList);
            query.andQualifier(exp);
        } else {
            Expression exp = ExpressionFactory.matchExp((String)crt_key, (Object)filter);
            query.andQualifier(exp);
        }
        this.current_filter = filter;
        this.current_filter_type = filter_type;
        return query;
    }

    public EipMFacility selectDetail(RunData rundata, Context context) {
        return FacilitiesUtils.getEipMFacility(rundata, context);
    }

    protected Object getResultDataDetail(EipMFacility record) {
        try {
            FacilityResultData rd = new FacilityResultData();
            rd.initField();
            rd.setFacilityName(record.getFacilityName());
            rd.setFacilityId(record.getFacilityId().longValue());
            rd.setNote(record.getNote());
            rd.setCreateDate(record.getCreateDate());
            rd.setUpdateDate(record.getUpdateDate());
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"facilities", (Throwable)ex);
            return null;
        }
    }

    public int getFacilitySum() {
        return this.facilitySum;
    }

    public String getViewtype() {
        return this.viewtype;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("facility_name", "facilityName");
        map.putValue("group_id", "GroupId");
        map.putValue("sort", "sort");
        return map;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }

    public List<FacilityGroupResultData> getAllFacilityGroup() {
        return this.AllFacilitygroup;
    }

    public void loadFacilityAllList(RunData rundata, Context context) {
        this.facilityAllList = new ArrayList<FacilityResultData>();
        this.facilityAllList.addAll(FacilitiesUtils.getFacilityAllList());
    }

    public int getAllFacilitySum() {
        return this.facilityAllList.size();
    }
}

