/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.fileio.util;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.common.ALCsvTokenizer;
import com.aimluck.eip.services.storage.ALStorageService;
import java.util.Calendar;
import java.util.Date;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;

public class FileIOScheduleCsvUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)FileIOScheduleCsvUtils.class.getName());
    public static final String SCHEDULEMAP_TYPE_USER = "U";
    public static final String FOLDER_TMP_FOR_ATTACHMENT_FILES = JetspeedResources.getString((String)"aipo.tmp.account.attachment.directory", (String)"");
    public static final String FOLDER_TMP_FOR_USERINFO_CSV_FILENAME = "schedule_info.csv";
    public static final String FOLDER_TMP_FOR_USERINFO_CSV_TEMP_FILENAME = "schedule_info_error.csv";
    public static final String CSV_SCHEDULE_TEMP_FOLDER = "account_schedule";
    public static final String DEFAULT_TIME_FORMAT = "HH:mm";

    public static String getScheduleCsvFolderName(String index) {
        return ALStorageService.getDocumentPath((String)ALCsvTokenizer.CSV_TEMP_FOLDER, (String)(CSV_SCHEDULE_TEMP_FOLDER + ALStorageService.separator() + index));
    }

    public static int compareToDate(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(date1);
        cal2.setTime(date2);
        int date1Year = cal1.get(1);
        int date1Month = cal1.get(2) + 1;
        int date1Day = cal1.get(5);
        int date2Year = cal2.get(1);
        int date2Month = cal2.get(2) + 1;
        int date2Day = cal2.get(5);
        if (date1Year == date2Year && date1Month == date2Month && date1Day == date2Day) {
            return 0;
        }
        if (cal1.after(cal2)) {
            return 2;
        }
        return 1;
    }

    public static boolean checkDateAcross(ALDateTimeField start_date, ALDateTimeField start_time, ALDateTimeField end_date, ALDateTimeField end_time) {
        boolean result = true;
        if (start_date.toString().equals("") || end_date.toString().equals("")) {
            return true;
        }
        if (start_time.toString().equals("") || end_time.toString().equals("")) {
            return true;
        }
        if (Integer.parseInt(start_time.getHour()) == 0 && Integer.parseInt(start_time.getMinute()) == 0 && Integer.parseInt(end_time.getHour()) == 0 && Integer.parseInt(end_time.getMinute()) == 0) {
            return true;
        }
        if (FileIOScheduleCsvUtils.compareToDate(start_date.getValue(), end_date.getValue()) != 0) {
            result = false;
        }
        return result;
    }

    public static boolean checkDateAcross(ALDateTimeField startDateTime, ALDateTimeField endDateTime) {
        String _sdate = startDateTime.getYear() + "/" + startDateTime.getMonth() + "/" + startDateTime.getDay();
        String _stime = startDateTime.getYear() + "/" + startDateTime.getMonth() + "/" + startDateTime.getDay() + " " + startDateTime.getHour() + ":" + startDateTime.getMinute();
        String _edate = endDateTime.getYear() + "/" + endDateTime.getMonth() + "/" + endDateTime.getDay();
        String _etime = endDateTime.getYear() + "/" + endDateTime.getMonth() + "/" + endDateTime.getDay() + " " + endDateTime.getHour() + ":" + endDateTime.getMinute();
        ALDateTimeField startDate = new ALDateTimeField();
        startDate.setValue(_sdate);
        ALDateTimeField startTime = new ALDateTimeField("yyyy/MM/dd HH:mm");
        startTime.setValue(_stime);
        ALDateTimeField endDate = new ALDateTimeField();
        endDate.setValue(_edate);
        ALDateTimeField endTime = new ALDateTimeField("yyyy/MM/dd HH:mm");
        endTime.setValue(_etime);
        return FileIOScheduleCsvUtils.checkDateAcross(startDate, startTime, endDate, endTime);
    }

    public static boolean isSpan(ALDateTimeField startDateTime, ALDateTimeField endDateTime) {
        try {
            if (Integer.parseInt(startDateTime.getHour()) == 0 && Integer.parseInt(startDateTime.getMinute()) == 0 && Integer.parseInt(endDateTime.getHour()) == 0 && Integer.parseInt(endDateTime.getMinute()) == 0) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }
}

