/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.screens;

import com.aimluck.eip.cayenne.om.account.EipMPosition;
import com.aimluck.eip.cayenne.om.account.EipMPost;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.modules.screens.ALCSVScreen;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.orgutils.ALOrgUtilsService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;

public class FileIOAccountCsvFileScreen
extends ALCSVScreen {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)FileIOAccountCsvFileScreen.class.getName());
    public static final String DEFAULT_VIEW_PASSWORD = "*";

    protected String getContentType(RunData rundata) {
        return "application/octet-stream";
    }

    protected String getCSVString(RunData rundata) throws Exception {
        String LINE_SEPARATOR = System.getProperty("line.separator");
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("\u30e6\u30fc\u30b6\u30fc\u540d,\u30d1\u30b9\u30ef\u30fc\u30c9,\u540d\u524d\uff08\u59d3\uff09,\u540d\u524d\uff08\u540d\uff09");
            sb.append(",\u540d\u524d\uff08\u59d3\u30fb\u30d5\u30ea\u30ac\u30ca\uff09,\u540d\u524d\uff08\u540d\u30fb\u30d5\u30ea\u30ac\u30ca\uff09,\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9");
            sb.append(",\u96fb\u8a71\u756a\u53f7\uff08\u5916\u7dda\uff09,\u96fb\u8a71\u756a\u53f7\uff08\u5185\u7dda\uff09,\u96fb\u8a71\u756a\u53f7\uff08\u643a\u5e2f\uff09,\u643a\u5e2f\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9,\u90e8\u7f72\u540d,\u5f79\u8077").append(LINE_SEPARATOR);
            sb.append("yamada,a,\u5c71\u7530,\u592a\u90ce");
            sb.append(",\u30e4\u30de\u30c0,\u30bf\u30ed\u30a6,a@a.com");
            sb.append(",99-99-91,1001,111-1111-1111,a@a.ne.jp,\u55b6\u696d\u90e8/\u4eba\u4e8b\u90e8").append(LINE_SEPARATOR);
            sb.append("suzuki0,b,\u9234\u6728,\u82b1\u5b50");
            sb.append(",\u30b9\u30ba\u30ad,\u30cf\u30ca\u30b3,b@b.com");
            sb.append(",99-99-92,2002,222-2222-2222,b@b.ne.jp,\u696d\u52d9\u90e8,\u696d\u52d9\u90e8\u9577").append(LINE_SEPARATOR);
            sb.append("suzuki1,c,\u9234\u6728,\u592a\u90ce");
            sb.append(",\u30b9\u30ba\u30ad,\u30bf\u30ed\u30a6,c@c.com");
            sb.append(",99-99-93,,,c@c.ne.jp,,").append(LINE_SEPARATOR);
            return sb.toString();
        }
        catch (Exception e) {
            logger.error((Object)"FileIOAccountCsvFileScreen.getCSVString", (Throwable)e);
            return null;
        }
    }

    protected String getCSVStringDB(RunData rundata) throws Exception {
        String LINE_SEPARATOR = System.getProperty("line.separator");
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("\u30e6\u30fc\u30b6\u30fc\u540d,\u30d1\u30b9\u30ef\u30fc\u30c9,\u540d\u524d\uff08\u59d3\uff09,\u540d\u524d\uff08\u540d\uff09");
            sb.append(",\u540d\u524d\uff08\u59d3\u30fb\u30d5\u30ea\u30ac\u30ca\uff09,\u540d\u524d\uff08\u540d\u30fb\u30d5\u30ea\u30ac\u30ca\uff09,\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9");
            sb.append(",\u96fb\u8a71\u756a\u53f7\uff08\u5916\u7dda\uff09,\u96fb\u8a71\u756a\u53f7\uff08\u5185\u7dda\uff09,\u96fb\u8a71\u756a\u53f7\uff08\u643a\u5e2f\uff09,\u643a\u5e2f\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9,\u90e8\u7f72\u540d,\u5f79\u8077").append(LINE_SEPARATOR);
            SelectQuery query = Database.query(TurbineUser.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"companyId", (Object)1);
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"disabled", (Object)"F");
            query.andQualifier(exp2);
            query.orderAscending("eipMUserPosition.position");
            List list = query.fetchList();
            String position = "";
            TurbineUser record = null;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                record = (TurbineUser)list.get(i);
                List postNames = new ArrayList();
                try {
                    postNames = ALEipUtils.getPostNameList((int)record.getUserId());
                    EipMPosition position_data = this.getEipMPosition(record.getPositionId());
                    position = position_data != null ? position_data.getPositionName() : "";
                }
                catch (Exception e) {
                    position = "";
                    logger.error((Object)"[FileIOAccountCsvFileScreen]", (Throwable)e);
                }
                sb.append(record.getLoginName()).append(",").append(DEFAULT_VIEW_PASSWORD).append(",").append(record.getLastName()).append(",").append(record.getFirstName()).append(",").append(record.getLastNameKana()).append(",").append(record.getFirstNameKana()).append(",").append(record.getEmail()).append(",").append(record.getOutTelephone()).append(",").append(record.getInTelephone()).append(",").append(record.getCellularPhone()).append(",").append(record.getCellularMail()).append(",");
                for (int j = 0; j < postNames.size(); ++j) {
                    if (j != 0) {
                        sb.append("/");
                    }
                    sb.append(postNames.get(j));
                }
                sb.append(",").append(position).append(LINE_SEPARATOR);
            }
            return sb.toString();
        }
        catch (Exception e) {
            logger.error((Object)"FileIOAccountCsvFileScreen.getCSVStringDB", (Throwable)e);
            return null;
        }
    }

    protected String getFileName() {
        return ALOrgUtilsService.getAlias() + "_users.csv";
    }

    private EipMPost getEipMPost(int i) {
        SelectQuery query = Database.query(EipMPost.class);
        Expression exp = ExpressionFactory.matchDbExp((String)"POST_ID", (Object)i);
        query.setQualifier(exp);
        List list = query.fetchList();
        if (list == null || list.size() == 0) {
            return null;
        }
        EipMPost post = (EipMPost)list.get(0);
        return post;
    }

    private EipMPosition getEipMPosition(int i) {
        SelectQuery query = Database.query(EipMPosition.class);
        Expression exp = ExpressionFactory.matchDbExp((String)"POSITION_ID", (Object)i);
        query.setQualifier(exp);
        List list = query.fetchList();
        if (list == null || list.size() == 0) {
            return null;
        }
        EipMPosition position = (EipMPosition)list.get(0);
        return position;
    }
}

