/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.project;

import com.aimluck.eip.cayenne.om.portlet.EipTProject;
import com.aimluck.eip.cayenne.om.portlet.EipTProjectFile;
import com.aimluck.eip.cayenne.om.portlet.EipTProjectMember;
import com.aimluck.eip.cayenne.om.portlet.EipTProjectTask;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.project.ProjectResultData;
import com.aimluck.eip.project.util.ProjectUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.jar.Attributes;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ProjectSelectData
extends ALAbstractSelectData<EipTProject, EipTProject>
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ProjectSelectData.class.getName());
    private int projectCount;
    private List<ProjectResultData> allProject;
    private Integer loginUserId;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)"sort");
        }
        this.allProject = ProjectUtils.getAllProject();
        this.loginUserId = ALEipUtils.getUserId((RunData)rundata);
        super.init(action, rundata, context);
    }

    protected ResultList<EipTProject> selectList(RunData rundata, Context context) {
        try {
            SelectQuery<EipTProject> query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            ResultList list = query.getResultList();
            this.projectCount = list.getTotalCount();
            return list;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private SelectQuery<EipTProject> getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = Database.query(EipTProject.class);
        return this.buildSelectQueryForFilter(query, rundata, context);
    }

    protected EipTProject selectDetail(RunData rundata, Context context) {
        return ProjectUtils.getEipTProject(rundata, context);
    }

    protected Object getResultData(EipTProject record) {
        DataRow row;
        ProjectResultData data = ProjectUtils.getProjectResultData(record);
        List<DataRow> result = ProjectUtils.getProjectProgress(record.getProjectId());
        if (result != null && !result.isEmpty() && Double.valueOf((row = result.get(0)).get((Object)"cnt").toString()) > 0.0) {
            int taskDays;
            int lapsedDays = (int)Double.valueOf(row.get((Object)"lapsed_days").toString()).doubleValue();
            if (lapsedDays > (taskDays = (int)Double.valueOf(row.get((Object)"task_days").toString()).doubleValue())) {
                lapsedDays = taskDays;
            }
            data.setPlanProgressRate(ProjectUtils.getPlanWorkload(lapsedDays, taskDays).intValue());
            data.setPlanWorkload(new BigDecimal(row.get((Object)"plan_workload").toString()));
            BigDecimal workload = new BigDecimal(row.get((Object)"workload").toString());
            data.setWorkload(workload);
            BigDecimal forecastWorkload = BigDecimal.valueOf(0L);
            if (data.getProgressRate().getValue() != 0L) {
                forecastWorkload = workload.multiply(BigDecimal.valueOf(100L)).divide(BigDecimal.valueOf(data.getProgressRate().getValue()), 2, 4);
            }
            data.setForecastWorkload(forecastWorkload);
            data.setTaskUpdateDate((Date)row.get((Object)"task_update_date"));
            SelectQuery query = Database.query(EipTProjectTask.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"projectId", (Object)record.getProjectId());
            Expression exp2 = ExpressionFactory.lessExp((String)"progressRate", (Object)100);
            query.setQualifier(exp1.andExp(exp2).andExp(ProjectUtils.getIncompleteExpression()));
            data.setReminderTask(query.getCount());
        }
        return data;
    }

    protected Object getResultDataDetail(EipTProject record) {
        ProjectResultData data = new ProjectResultData();
        data.initField();
        data.setProjectId(record.getProjectId().intValue());
        data.setProjectName(record.getProjectName());
        data.setExplanation(record.getExplanation());
        data.setAdminUserId(record.getAdminUserId().intValue());
        data.setProgressFlg(record.getProgressFlg());
        data.setProgressRate(record.getProgressRate().intValue());
        data.setLoginUserId(this.loginUserId.longValue());
        data.setCreateUserId(record.getTurbineUser().getUserId().longValue());
        data.setUpdateUserId(record.getUpdateUserId().intValue());
        try {
            data.setCreateUserName(ALEipUtils.getALEipUser((int)record.getTurbineUser().getUserId()).getAliasName().getValue());
            data.setUpdateUserName(ALEipUtils.getALEipUser((int)record.getUpdateUserId()).getAliasName().getValue());
            data.setAdminUserName(ALEipUtils.getALEipUser((int)record.getAdminUserId()).getAliasName().getValue());
        }
        catch (ALDBErrorException ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
        ArrayList<Integer> users1 = new ArrayList<Integer>();
        EipTProjectMember map1 = null;
        List<EipTProjectMember> tmp_maps1 = ProjectUtils.getEipTProjectMember(record);
        int size1 = tmp_maps1.size();
        for (int i = 0; i < size1; ++i) {
            map1 = tmp_maps1.get(i);
            users1.add(map1.getUserId());
        }
        SelectQuery query1 = Database.query(TurbineUser.class);
        Expression exp1 = ExpressionFactory.inDbExp((String)"USER_ID", users1);
        query1.setQualifier(exp1);
        data.setMemberList(ALEipUtils.getUsersFromSelectQuery((SelectQuery)query1));
        List list = ProjectUtils.getSelectQueryForFiles(record.getProjectId()).fetchList();
        if (list != null && list.size() > 0) {
            ArrayList<FileuploadBean> attachmentFileList = new ArrayList<FileuploadBean>();
            FileuploadBean filebean = null;
            for (EipTProjectFile file : list) {
                String realname = file.getFileName();
                DataHandler hData = new DataHandler((DataSource)new FileDataSource(realname));
                filebean = new FileuploadBean();
                filebean.setFileId(file.getFileId().intValue());
                filebean.setFileName(realname);
                if (hData != null) {
                    filebean.setContentType(hData.getContentType());
                }
                filebean.setIsImage(FileuploadUtils.isImage((String)realname));
                attachmentFileList.add(filebean);
            }
            data.setAttachmentFileList(attachmentFileList);
        }
        data.setCreateDate(record.getCreateDate());
        data.setUpdateDate(record.getUpdateDate());
        return data;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("project_name", "projectName");
        return map;
    }

    public int getProjectCount() {
        return this.projectCount;
    }

    public List<ProjectResultData> getAllProject() {
        return this.allProject;
    }

    public String getViewtype() {
        return "project";
    }
}

