/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.project;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.cayenne.om.portlet.EipTProjectTask;
import com.aimluck.eip.cayenne.om.portlet.EipTProjectTaskFile;
import com.aimluck.eip.common.ALAbstractMultiFilterSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipHolidaysManager;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.project.ProjectResultData;
import com.aimluck.eip.project.ProjectTaskMemberResultData;
import com.aimluck.eip.project.ProjectTaskResultData;
import com.aimluck.eip.project.ProjectTaskSelectData;
import com.aimluck.eip.project.util.ProjectFile;
import com.aimluck.eip.project.util.ProjectUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ProjectTaskSimpleSelectData
extends ALAbstractMultiFilterSelectData<EipTProjectTask, EipTProjectTask>
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ProjectTaskSimpleSelectData.class.getName());
    private int taskCount;
    private List<ProjectResultData> allProject;
    private Integer selectedProjectId;
    private final ProjectFile<EipTProjectTaskFile, EipTProjectTask> pfile = new ProjectFile(EipTProjectTaskFile.class);
    private List<ALEipUser> projectMembers;
    private ALDateTimeField base_date_from;
    private ALDateTimeField base_date_to;
    private String target_keyword;
    private String target_user_id;
    private String target_tracker;
    private String target_priority;
    private String target_status;
    private String target_progress_rate_from;
    private String target_progress_rate_to;
    private String target_delay;
    private String progress_line_checked;
    private int viewDateMaxYear;
    private final boolean indentFlg = true;
    private Calendar calFrom;
    private Calendar calTo;
    private boolean topView = false;
    private Integer loginUserId = null;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String resetCondition = rundata.getParameters().get("reset_condition");
        if (resetCondition != null && resetCondition.length() > 0) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"target_keyword", (String)"");
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)"");
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR, (String)"");
        }
        this.allProject = ProjectUtils.getAllProject();
        this.setProject(rundata, context);
        super.init(action, rundata, context);
        Calendar cal = Calendar.getInstance();
        this.viewDateMaxYear = cal.get(1) + 10;
        this.projectMembers = 0 != this.selectedProjectId ? ProjectUtils.getProjectMembers(this.selectedProjectId) : ALEipUtils.getUsers((String)"LoginUser");
        this.calFrom = ProjectUtils.getViewCalendar(rundata, context, "base_date_from");
        this.calTo = ProjectUtils.getViewCalendar(rundata, context, "base_date_to");
        this.calFrom.set(5, 1);
        this.calTo.set(5, this.calTo.getActualMaximum(5));
        this.base_date_from = new ALDateTimeField();
        this.base_date_to = new ALDateTimeField();
        this.base_date_from.setValue(this.calFrom.getTime());
        this.base_date_to.setValue(this.calTo.getTime());
        this.progress_line_checked = ProjectUtils.getParameter(rundata, context, "progress_line_checked");
        this.loginUserId = ALEipUtils.getUserId((RunData)rundata);
    }

    protected ResultList<EipTProjectTask> selectList(RunData rundata, Context context) {
        try {
            if (null == this.selectedProjectId) {
                return null;
            }
            this.setSessionParams(rundata, context);
            SelectQuery<EipTProjectTask> query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSortOrder(query, rundata, context);
            ResultList list = query.getResultList();
            this.taskCount = list.getTotalCount();
            return list;
        }
        catch (Exception ex) {
            logger.error((Object)"ProjectTaskSimpleSelectData", (Throwable)ex);
            return null;
        }
    }

    private void setSessionParams(RunData rundata, Context context) {
        this.target_keyword = ProjectUtils.getParameter(rundata, context, "target_keyword");
        this.target_user_id = ProjectUtils.getParameter(rundata, context, "target_user_id");
        this.target_tracker = ProjectUtils.getParameter(rundata, context, "target_tracker");
        this.target_priority = ProjectUtils.getParameter(rundata, context, "target_priority");
        this.target_status = ProjectUtils.getParameter(rundata, context, "target_status");
        this.target_progress_rate_from = ProjectUtils.getParameter(rundata, context, "target_progress_rate_from");
        this.target_progress_rate_to = ProjectUtils.getParameter(rundata, context, "target_progress_rate_to");
        this.target_delay = ProjectUtils.getParameter(rundata, context, "target_delay");
        if (this.isRejectParameter(this.target_user_id)) {
            this.target_user_id = "0";
        }
        if (this.isRejectParameter(this.target_tracker)) {
            this.target_tracker = "0";
        }
        if (this.isRejectParameter(this.target_priority)) {
            this.target_priority = "0";
        }
        if (this.isRejectParameter(this.target_status)) {
            this.target_status = "0";
        }
        if (this.isRejectParameter(this.target_progress_rate_from)) {
            this.target_progress_rate_from = "0";
        }
        if (this.isRejectParameter(this.target_progress_rate_to)) {
            this.target_progress_rate_to = "0";
        }
    }

    private SelectQuery<EipTProjectTask> getSelectQuery(RunData rundata, Context context) {
        Expression ex1;
        SelectQuery query = Database.query(EipTProjectTask.class);
        query.setQualifier(ExpressionFactory.matchExp((String)"parentTaskId", null));
        if (0 != this.selectedProjectId) {
            ex1 = ExpressionFactory.matchExp((String)"projectId", (Object)this.selectedProjectId);
            query.andQualifier(ex1);
        }
        if (this.target_keyword != null && this.target_keyword.trim().length() > 0) {
            ex1 = ExpressionFactory.likeExp((String)"taskName", (Object)("%" + this.target_keyword + "%"));
            query.andQualifier(ex1);
        }
        if (StringUtils.isNotEmpty((String)this.target_user_id) && !this.target_user_id.equals("all")) {
            Expression exp2 = ExpressionFactory.matchExp((String)"eipTProjectTaskMember.userId", (Object)Integer.valueOf(this.target_user_id));
            query.andQualifier(exp2);
        }
        if (StringUtils.isNotEmpty((String)this.target_tracker) && !this.target_tracker.equals("all")) {
            Expression ex3 = ExpressionFactory.matchExp((String)"tracker", (Object)this.target_tracker);
            query.andQualifier(ex3);
        }
        if (StringUtils.isNotEmpty((String)this.target_priority) && !this.target_priority.equals("all")) {
            Expression ex4 = ExpressionFactory.matchExp((String)"priority", (Object)this.target_priority);
            query.andQualifier(ex4);
        }
        if (StringUtils.isNotEmpty((String)this.target_status) && !this.target_status.equals("all")) {
            Expression ex5 = ExpressionFactory.matchExp((String)"status", (Object)this.target_status);
            query.andQualifier(ex5);
        }
        if (StringUtils.isNotEmpty((String)this.target_progress_rate_from) && !this.target_progress_rate_from.equals("0")) {
            Expression ex6 = ExpressionFactory.greaterOrEqualExp((String)"progressRate", (Object)Integer.valueOf(this.target_progress_rate_from));
            query.andQualifier(ex6);
        }
        if (StringUtils.isNotEmpty((String)this.target_progress_rate_to) && !this.target_progress_rate_to.equals("100")) {
            Expression ex7 = ExpressionFactory.lessOrEqualExp((String)"progressRate", (Object)Integer.valueOf(this.target_progress_rate_to));
            query.andQualifier(ex7);
        }
        if (StringUtils.isNotEmpty((String)this.target_delay) && this.target_delay.equals("t")) {
            StringBuilder sl = new StringBuilder();
            sl.append("(");
            sl.append("( CASE WHEN task.end_plan_date - task.start_plan_date + 1 < 0");
            sl.append("    THEN 0");
            sl.append("    ELSE task.end_plan_date - task.start_plan_date + 1");
            sl.append("  END)");
            sl.append(" <> 0 ");
            sl.append(" AND ");
            sl.append("(");
            sl.append("    ( CASE");
            sl.append("    WHEN task.start_plan_date IS NULL OR task.end_plan_date IS NULL");
            sl.append("      THEN 0");
            sl.append("    WHEN ").append(ProjectUtils.getCurrentDateWithCast()).append(" < task.end_plan_date");
            sl.append("      THEN");
            sl.append("        CASE WHEN ").append(ProjectUtils.getCurrentDateWithCast()).append(" - task.start_plan_date + 1 < 0");
            sl.append("          THEN 0");
            sl.append("          ELSE ").append(ProjectUtils.getCurrentDateWithCast()).append(" - task.start_plan_date + 1");
            sl.append("        END");
            sl.append("      ELSE");
            sl.append("        task.end_plan_date - task.start_plan_date + 1");
            sl.append("  END )");
            sl.append("  * 100 / ");
            sl.append(" ( CASE WHEN task.end_plan_date - task.start_plan_date + 1 < 0");
            sl.append("    THEN 0");
            sl.append("    ELSE task.end_plan_date - task.start_plan_date + 1");
            sl.append("  END ) ");
            sl.append("   > progress_rate ");
            Expression exp = Expression.fromString((String)sl.toString());
            query.andQualifier(exp);
        }
        if (this.topView) {
            Expression exp9 = ExpressionFactory.matchExp((String)"eipTProjectTaskMember.userId", (Object)this.loginUserId);
            query.andQualifier(exp9);
            Expression exp10 = ExpressionFactory.inExp((String)"status", ProjectUtils.incompleteStatus);
            query.andQualifier(exp10);
        }
        return query;
    }

    protected SelectQuery<EipTProjectTask> buildSelectQueryForListViewSortOrder(SelectQuery<EipTProjectTask> query, RunData rundata, Context context) {
        this.buildSelectQueryForListViewSort(query, rundata, context);
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        String crt_key = null;
        Attributes map = this.getColumnMap();
        if (sort != null && sort.length() > 0) {
            crt_key = map.getValue(sort);
        }
        if (crt_key == null) {
            if (this.topView) {
                query.orderAscending("endPlanDate");
                query.orderAscending("orderNo");
            } else {
                query.orderAscending("orderNo");
            }
        }
        return query;
    }

    protected EipTProjectTask selectDetail(RunData rundata, Context context) {
        return ProjectUtils.getEipTProjectTask(rundata, context);
    }

    protected Object getResultData(EipTProjectTask record) {
        ProjectTaskResultData data;
        Integer taskId = (int)(data = ProjectUtils.getProjectTaskResultData(record)).getTaskId().getValue();
        int cntChild = ProjectUtils.getCountChildrenTask(taskId);
        data.setHasChildren(cntChild >= 2);
        data.setHasChildrenForForm(cntChild > 0);
        int lapsedDays = ProjectUtils.getLapsedDays(ProjectUtils.toString(record.getStartPlanDate()), ProjectUtils.toString(Calendar.getInstance().getTime()));
        int taskDays = ProjectUtils.getLapsedDays(ProjectUtils.toString(record.getStartPlanDate()), ProjectUtils.toString(record.getEndPlanDate()));
        data.setPlanTerm(taskDays);
        if (lapsedDays > taskDays) {
            lapsedDays = taskDays;
        }
        data.setPlanProgressRate(ProjectUtils.getPlanWorkload(lapsedDays, taskDays).intValue());
        List<ProjectTaskMemberResultData> memberList = data.getMemberList();
        BigDecimal workload = BigDecimal.valueOf(0L);
        workload = workload.setScale(1);
        for (int i = 0; i < memberList.size(); ++i) {
            ProjectTaskMemberResultData member = memberList.get(i);
            workload = workload.add(member.getWorkload());
        }
        data.setWorkload(workload);
        BigDecimal forecastWorkload = BigDecimal.valueOf(0L);
        if (data.getProgressRate().getValue() != 0L) {
            forecastWorkload = workload.multiply(BigDecimal.valueOf(100L)).divide(BigDecimal.valueOf(data.getProgressRate().getValue()), 2, 4);
        }
        data.setForecastWorkload(forecastWorkload);
        data.setIndentFlg(true);
        return data;
    }

    protected Object getResultDataDetail(EipTProjectTask record) {
        ProjectTaskResultData data = ProjectUtils.getProjectTaskResultData(record);
        int taskId = (int)data.getTaskId().getValue();
        List list = this.pfile.getSelectQueryForFiles("TASK_ID", taskId).fetchList();
        data.setAttachmentFiles(this.pfile.getFileList(list));
        data.setCommentList(ProjectUtils.getProjectTaskCommentList("" + taskId));
        data.setTopicPath(ProjectUtils.getTaskTopicPath(record.getProjectId()));
        return data;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("task_name", "task_name");
        map.putValue("progress_rate", "progress_rate");
        return map;
    }

    public int getTaskCount() {
        return this.taskCount;
    }

    public List<ProjectResultData> getAllProject() {
        return this.allProject;
    }

    public Integer getSelectedProjectId() {
        return this.selectedProjectId;
    }

    public List<ALEipUser> getProjectMembers() {
        return this.projectMembers;
    }

    public String getTargetKeyword() {
        return this.target_keyword;
    }

    public String getTargetUserId() {
        return this.target_user_id;
    }

    public String getTargetTracker() {
        return this.target_tracker;
    }

    public String getTargetPriority() {
        return this.target_priority;
    }

    public String getTargetStatus() {
        return this.target_status;
    }

    public String getTargetProgressRateFrom() {
        return this.target_progress_rate_from;
    }

    public String getTargetProgressRateTo() {
        return this.target_progress_rate_to;
    }

    public String getTargetDelay() {
        return this.target_delay;
    }

    public String getProgressLineChecked() {
        return this.progress_line_checked;
    }

    public int getViewDateMaxYear() {
        return this.viewDateMaxYear;
    }

    public ALDateTimeField getBaseDateFrom() {
        return this.base_date_from;
    }

    public ALDateTimeField getBaseDateTo() {
        return this.base_date_to;
    }

    public int getBaseDateFromYear() {
        return this.calFrom.get(1);
    }

    public int getBaseDateToYear() {
        return this.calTo.get(1);
    }

    public int getDay(int days) {
        Calendar cal = (Calendar)this.calFrom.clone();
        cal.add(5, days - 1);
        return cal.get(5);
    }

    public boolean isToday(int days) {
        Calendar today = Calendar.getInstance();
        Calendar cal = (Calendar)this.calFrom.clone();
        cal.add(5, days - 1);
        return today.get(1) == cal.get(1) && today.get(2) == cal.get(2) && today.get(5) == cal.get(5);
    }

    public int getDays() {
        return ProjectUtils.getLapsedDays(this.calFrom, this.calTo);
    }

    public int getDays(Date dateTo) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dateTo);
        return ProjectUtils.getLapsedDays(this.calFrom, cal);
    }

    public int getYear(int days) {
        Calendar cal = (Calendar)this.calFrom.clone();
        cal.add(5, days - 1);
        return cal.get(1);
    }

    public int getMonth(int days) {
        Calendar cal = (Calendar)this.calFrom.clone();
        cal.add(5, days - 1);
        return cal.get(2);
    }

    public int getWeek(int days) {
        Calendar cal = (Calendar)this.calFrom.clone();
        cal.add(5, days - 1);
        return cal.get(3);
    }

    public Map<String, String> getTrackerMap() {
        return ProjectUtils.getKubunMap("tracker");
    }

    public Map<String, String> getStatusMap() {
        return ProjectUtils.getKubunMap("status");
    }

    public Map<String, String> getPriorityMap() {
        return ProjectUtils.getKubunMap("priority");
    }

    public long getNowTime() {
        return Calendar.getInstance().getTimeInMillis();
    }

    public boolean isHoliday(int days) {
        Calendar cal = (Calendar)this.calFrom.clone();
        cal.add(5, days - 1);
        ALEipHolidaysManager holidaysManager = ALEipHolidaysManager.getInstance();
        return holidaysManager.isHoliday(cal.getTime()) != null;
    }

    public boolean isSaturday(int days) {
        Calendar cal = (Calendar)this.calFrom.clone();
        cal.add(5, days - 1);
        return 7 == cal.get(7);
    }

    public boolean isSunday(int days) {
        Calendar cal = (Calendar)this.calFrom.clone();
        cal.add(5, days - 1);
        return 1 == cal.get(7);
    }

    public String getViewtype() {
        return "project";
    }

    private boolean isRejectParameter(String numeric) {
        return StringUtils.isNotEmpty((String)numeric) && !"all".equals(numeric) && !StringUtils.isNumeric((String)numeric);
    }

    public void setFiltersFromPSML(VelocityPortlet portlet, Context context, RunData rundata) {
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR, (String)portlet.getPortletConfig().getInitParameter("p12f-filters"));
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR, (String)portlet.getPortletConfig().getInitParameter("p12g-filtertypes"));
    }

    public boolean isProjectEmpty() {
        return this.allProject.isEmpty();
    }

    public boolean isTaskEmpty() {
        return null == this.getList() || this.getList().isEmpty();
    }

    public void setProject(RunData rundata, Context context) {
        String filter = rundata.getParameters().getString("filter", "");
        String filterType = rundata.getParameters().getString("filtertype", "");
        String sesFilter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR);
        String sesFilterType = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR);
        sesFilter = sesFilter == null ? "" : sesFilter;
        String string = sesFilterType = sesFilterType == null ? "" : sesFilterType;
        if (filterType.isEmpty()) {
            filter = sesFilter;
            filterType = sesFilterType;
        }
        if (StringUtils.isEmpty((String)filter) || StringUtils.isEmpty((String)filterType)) {
            this.selectedProjectId = 0;
            this.setFilter(rundata, context);
            return;
        }
        boolean existProject = false;
        for (ProjectResultData data : this.allProject) {
            if (!filter.equals(data.getProjectId().toString())) continue;
            existProject = true;
            break;
        }
        this.selectedProjectId = !existProject ? Integer.valueOf(0) : Integer.valueOf(filter);
        this.setFilter(rundata, context);
    }

    private void setFilter(RunData rundata, Context context) {
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR, (String)String.valueOf(this.selectedProjectId));
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR, (String)"project_id");
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)new StringBuffer().append(ProjectTaskSelectData.class.getName()).append("filter").toString(), (String)String.valueOf(this.selectedProjectId));
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)new StringBuffer().append(ProjectTaskSelectData.class.getName()).append("filtertype").toString(), (String)"project_id");
    }

    public void setTopView(boolean bool) {
        this.topView = bool;
    }
}

