/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.message;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTMessageRoom;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.message.MessageRoomResultData;
import com.aimluck.eip.message.util.MessageUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.util.ALEipUtils;
import java.util.jar.Attributes;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.StringUtils;
import org.apache.velocity.context.Context;

public class MessageRoomListSelectData
extends ALAbstractSelectData<EipTMessageRoom, EipTMessageRoom> {
    private int userId;
    private int totalUnreadCount = 0;
    private ALStringField keyword = null;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.userId = ALEipUtils.getUserId((RunData)rundata);
    }

    public void initField() {
        this.keyword = new ALStringField();
    }

    protected ResultList<EipTMessageRoom> selectList(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        return MessageUtils.getRoomList(this.userId, this.keyword.getValue());
    }

    protected EipTMessageRoom selectDetail(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        return null;
    }

    protected Object getResultData(EipTMessageRoom model) throws ALPageNotFoundException, ALDBErrorException {
        boolean isDirect;
        MessageRoomResultData rd = new MessageRoomResultData();
        rd.initField();
        rd.setAutoName("T".equals(model.getAutoName()));
        rd.setLastMessage(model.getLastMessage());
        Integer userId = model.getUserId();
        if (userId != null) {
            rd.setUserId(userId.longValue());
        }
        rd.setName((isDirect = "O".equals(model.getRoomType())) ? model.getLastName() + " " + model.getFirstName() : model.getName());
        rd.setHasPhoto(isDirect ? "T".equals(model.getUserHasPhoto()) : "T".equals(model.getHasPhoto()));
        if (rd.isHasPhoto()) {
            rd.setPhotoModified(isDirect ? model.getUserPhotoModified().longValue() : model.getPhotoModified().getTime());
        }
        rd.setRoomId(model.getRoomId().intValue());
        rd.setRoomType(model.getRoomType());
        rd.setUnreadCount(model.getUnreadCount().intValue());
        rd.setUpdateDate(model.getLastUpdateDate());
        this.totalUnreadCount += model.getUnreadCount().intValue();
        return rd;
    }

    protected Object getResultDataDetail(EipTMessageRoom model) throws ALPageNotFoundException, ALDBErrorException {
        return null;
    }

    protected Attributes getColumnMap() {
        return null;
    }

    public int getTotalUnreadCount() {
        return this.totalUnreadCount;
    }

    public void setKeyword(String keyword) {
        this.keyword.setValue(keyword);
    }

    public ALStringField getKeyword() {
        return this.keyword;
    }

    public boolean hasKeyword() {
        return !StringUtils.isEmpty((String)this.keyword.getValue());
    }
}

