/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.screens;

import com.aimluck.eip.cayenne.om.portlet.EipTMessageRoom;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.message.MessageRoomListSelectData;
import com.aimluck.eip.message.MessageRoomResultData;
import com.aimluck.eip.message.util.MessageUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.modules.screens.ALVelocityScreen;
import com.aimluck.eip.util.ALEipUtils;
import java.util.Date;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.StringUtils;
import org.apache.velocity.context.Context;

public class MessageRoomListScreen
extends ALVelocityScreen {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)MessageRoomListScreen.class.getName());

    protected void doOutput(RunData rundata, Context context) throws Exception {
        try {
            Integer targetUserId = null;
            Integer roomId = null;
            boolean isNewRoom = false;
            EipTMessageRoom room = null;
            ALEipUser targetUser = null;
            String keyword = null;
            try {
                targetUserId = rundata.getParameters().getInteger("u");
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                keyword = rundata.getParameters().getString("k");
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            if (targetUserId != null && targetUserId > 0) {
                int userId = ALEipUtils.getUserId((RunData)rundata);
                room = MessageUtils.getRoom(userId, targetUserId);
                if (room != null) {
                    roomId = room.getRoomId();
                } else {
                    targetUser = ALEipUtils.getALEipUser((int)targetUserId);
                    isNewRoom = true;
                }
            } else {
                try {
                    roomId = rundata.getParameters().getInteger("r");
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
            context.put("currentRoom", (Object)roomId);
            MessageRoomListSelectData listData = new MessageRoomListSelectData();
            listData.initField();
            if (!StringUtils.isEmpty((String)keyword)) {
                listData.setKeyword(keyword);
                context.put("isSearch", (Object)true);
            } else {
                context.put("isSearch", (Object)false);
            }
            listData.doViewList((ALAction)this, rundata, context);
            if (isNewRoom) {
                MessageRoomResultData rd = new MessageRoomResultData();
                rd.initField();
                rd.setAutoName(true);
                rd.setLastMessage("");
                rd.setUserId(targetUser.getUserId().getValue());
                rd.setName(targetUser.getAliasName().getValue());
                rd.setHasPhoto(targetUser.hasPhoto());
                rd.setPhotoModified(targetUser.getPhotoModified());
                rd.setRoomId(0L);
                rd.setRoomType("O");
                rd.setUnreadCount(0L);
                rd.setUpdateDate(new Date());
                listData.getList().add(0, rd);
                context.put("currentRoom", (Object)0);
            }
            String layout_template = "portlets/html/ja/ajax-message-room-list.vm";
            this.setTemplate(rundata, context, layout_template);
        }
        catch (Exception ex) {
            logger.error((Object)"MessageRoomListScreen.doOutput", (Throwable)ex);
            ALEipUtils.redirectDBError((RunData)rundata);
        }
    }

    protected String getPortletName() {
        return "Message";
    }
}

