/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.screens;

import com.aimluck.eip.cayenne.om.portlet.EipTMessageRoom;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.message.MessageRoomMemberListSelectData;
import com.aimluck.eip.message.util.MessageUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.modules.screens.ALVelocityScreen;
import com.aimluck.eip.util.ALEipUtils;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class MessageRoomMemberListScreen
extends ALVelocityScreen {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)MessageRoomMemberListScreen.class.getName());

    protected void doOutput(RunData rundata, Context context) throws Exception {
        try {
            Integer targetUserId = null;
            Integer roomId = null;
            boolean isNewRoom = false;
            EipTMessageRoom room = null;
            ALEipUser targetUser = null;
            try {
                targetUserId = rundata.getParameters().getInteger("u");
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            int userId = ALEipUtils.getUserId((RunData)rundata);
            if (targetUserId != null && targetUserId > 0) {
                room = MessageUtils.getRoom(userId, targetUserId);
                if (room == null) {
                    targetUser = ALEipUtils.getALEipUser((int)targetUserId);
                    isNewRoom = true;
                }
            } else {
                try {
                    roomId = rundata.getParameters().getInteger("r");
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                if (roomId == null) {
                    return;
                }
                room = MessageUtils.getRoom(roomId);
                if (room == null) {
                    return;
                }
            }
            if (!isNewRoom && !MessageUtils.isJoinRoom(room, userId)) {
                return;
            }
            MessageRoomMemberListSelectData listData = new MessageRoomMemberListSelectData();
            if (isNewRoom) {
                listData.setTargetUserId((int)targetUser.getUserId().getValue());
            } else {
                listData.setRoom(room);
            }
            listData.initField();
            listData.doViewList((ALAction)this, rundata, context);
            String layout_template = "portlets/html/ja/ajax-message-room-member-list.vm";
            this.setTemplate(rundata, context, layout_template);
        }
        catch (Exception ex) {
            logger.error((Object)"MessageUserListScreen.doOutput", (Throwable)ex);
            ALEipUtils.redirectDBError((RunData)rundata);
        }
    }

    protected String getPortletName() {
        return "Message";
    }
}

