/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.exttimecard;

import com.aimluck.eip.cayenne.om.portlet.EipTExtTimecardSystem;
import com.aimluck.eip.cayenne.om.portlet.EipTExtTimecardSystemMap;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ExtTimecardSystemMultiDelete
extends ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ExtTimecardSystemMultiDelete.class.getName());

    protected boolean action(RunData rundata, Context context, List<String> values, List<String> msgList) {
        try {
            ArrayList<Integer> intValues = new ArrayList<Integer>();
            for (String value : values) {
                if ("1".equals(value)) continue;
                intValues.add(Integer.valueOf(value));
            }
            SelectQuery query = Database.query(EipTExtTimecardSystem.class);
            Expression exp1 = ExpressionFactory.inDbExp((String)"SYSTEM_ID", intValues);
            query.setQualifier(exp1);
            List list = query.fetchList();
            if (list == null || list.size() == 0) {
                return false;
            }
            for (EipTExtTimecardSystem record : list) {
                this.setAllTimecardMapDefault(record);
                Database.delete((Persistent)record);
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(record.getSystemId().intValue(), 311, record.getSystemName());
            }
            Database.commit();
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"exttimecard", (Throwable)ex);
            return false;
        }
        return true;
    }

    private void setAllTimecardMapDefault(EipTExtTimecardSystem work) {
        try {
            EipTExtTimecardSystem system;
            Expression exp1 = ExpressionFactory.matchExp((String)"eipTExtTimecardSystem", (Object)work);
            List list = Database.query(EipTExtTimecardSystemMap.class).setQualifier(exp1).fetchList();
            if (list.size() > 0 && (system = (EipTExtTimecardSystem)Database.get(EipTExtTimecardSystem.class, (Object)1)) != null) {
                Date now = new Date();
                for (EipTExtTimecardSystemMap item : list) {
                    item.setEipTExtTimecardSystem(system);
                    item.setUpdateDate(now);
                }
            }
            Database.commit();
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"exttimecard", (Throwable)ex);
        }
    }
}

