/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.screens;

import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.exttimecard.ExtTimecardSummaryListSelectData;
import com.aimluck.eip.exttimecard.ExtTimecardSummaryResultData;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.modules.screens.ALXlsScreen;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.List;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ExtTimecardSummaryXlsExportScreen
extends ALXlsScreen {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ExtTimecardSummaryXlsExportScreen.class.getName());
    public static final String FILE_NAME = "timecard_monthly.xls";
    private String userid;
    private String target_group_name;
    private String view_month;
    private String aclPortletFeature = null;

    public void init(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String target_user_id = rundata.getParameters().getString("target_user_id");
        this.target_group_name = rundata.getParameters().getString("target_group_name");
        this.view_month = rundata.getParameters().getString("view_month");
        this.userid = Integer.toString(ALEipUtils.getUserId((RunData)rundata));
        this.aclPortletFeature = target_user_id == null || "".equals(target_user_id) || this.userid.equals(target_user_id) ? "timecard_timecard_self" : "timecard_timecard_other";
        super.init(rundata, context);
    }

    protected boolean createHSSFWorkbook(RunData rundata, Context context, HSSFWorkbook wb) {
        try {
            this.setupTimecardSheet(rundata, context, wb);
        }
        catch (Exception e) {
            logger.error((Object)"TimecardCsvExportScreen", (Throwable)e);
            return false;
        }
        return true;
    }

    private void setupTimecardSheet(RunData rundata, Context context, HSSFWorkbook wb) throws Exception {
        ExtTimecardSummaryListSelectData listData = new ExtTimecardSummaryListSelectData();
        listData.init((ALAction)this, rundata, context);
        listData.setRowsNum(1000);
        listData.doViewList((ALAction)this, rundata, context);
        listData.setuserList(this.target_group_name);
        String sheet_name = "\u30bf\u30a4\u30e0\u30ab\u30fc\u30c9";
        String[] headers = new String[]{"\u6c0f\u540d", "\u5e74", "\u6708", "\u52e4\u52d9\u5f62\u614b", "\u51fa\u52e4\u65e5\u6570", "\u5c31\u696d\u6642\u9593", "\u6b8b\u696d\u65e5\u6570", "\u6b8b\u696d\u6642\u9593", "\u4f11\u51fa\u65e5\u6570", "\u4f11\u51fa\u6642\u9593", "\u9045\u523b\u65e5\u6570", "\u65e9\u9000\u65e5\u6570", "\u6b20\u52e4\u65e5\u6570", "\u6709\u4f11\u65e5\u6570", "\u4ee3\u4f11\u65e5\u6570", "\u305d\u306e\u4ed6\u65e5\u6570", "\u672a\u5165\u529b"};
        short[] cell_enc_types = new short[]{1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        HSSFSheet sheet = this.createHSSFSheet(wb, sheet_name, headers, cell_enc_types);
        int rowcount = 0;
        HSSFCellStyle style_col = wb.createCellStyle();
        style_col.setVerticalAlignment((short)1);
        style_col.setAlignment((short)5);
        ExtTimecardSummaryResultData tclistrd = null;
        List<ExtTimecardSummaryResultData> daykeys = listData.getGroupExtTimecards();
        int daykeysize = daykeys.size();
        for (int i = 0; i < daykeysize; ++i) {
            tclistrd = daykeys.get(i);
            String user_name = tclistrd.getUserName();
            String year = this.view_month.substring(0, 4);
            String month = this.view_month.substring(5);
            String service_form = tclistrd.getSystemName();
            String work_day = tclistrd.getWorkDay().getValueAsString();
            String work_hour = tclistrd.getWorkHour().getValueAsString();
            String overtime_day = tclistrd.getOvertimeDay().getValueAsString();
            String overtime_hour = tclistrd.getOvertimeHour().getValueAsString();
            String off_day = tclistrd.getOffDay().getValueAsString();
            String off_hour = tclistrd.getOffHour().getValueAsString();
            String late_coming_day = tclistrd.getLateComingDay().getValueAsString();
            String early_leaving_day = tclistrd.getEarlyLeavingDay().getValueAsString();
            String absent_day = tclistrd.getAbsentDay().getValueAsString();
            String paid_holiday = tclistrd.getPaidHoliday().getValueAsString();
            String compensatory_holiday = tclistrd.getCompensatoryHoliday().getValueAsString();
            String other_day = tclistrd.getOtherDay().getValueAsString();
            String noinput = tclistrd.getNoInput().getValueAsString();
            String[] rows = new String[]{user_name, year, month, service_form, work_day, work_hour, overtime_day, overtime_hour, off_day, off_hour, late_coming_day, early_leaving_day, absent_day, paid_holiday, compensatory_holiday, other_day, noinput};
            this.addRow(sheet.createRow(++rowcount), cell_enc_types, rows);
        }
        int uid = ALEipUtils.getUserId((RunData)rundata);
        ALEventlogFactoryService.getInstance().getEventlogHandler().logXlsScreen(uid, "\u30bf\u30a4\u30e0\u30ab\u30fc\u30c9\u51fa\u529b", 310);
    }

    protected String getFileName() {
        return FILE_NAME;
    }

    public String getAclPortletFeature() {
        return this.aclPortletFeature;
    }
}

