/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import java.text.ParseException;
import java.util.Enumeration;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.types.GYear;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JType;

public class XSGYear
extends XSType {
    private static final JType jType = new JClass("org.exolab.castor.types.GYear");
    private GYear _maxInclusive;
    private GYear _maxExclusive;
    private GYear _minInclusive;
    private GYear _minExclusive;

    public XSGYear() {
        super((short)7);
    }

    public JType getJType() {
        return jType;
    }

    public GYear getMaxExclusive() {
        return this._maxExclusive;
    }

    public GYear getMaxInclusive() {
        return this._maxInclusive;
    }

    public GYear getMinExclusive() {
        return this._minExclusive;
    }

    public GYear getMinInclusive() {
        return this._minInclusive;
    }

    public boolean hasMaximum() {
        return this._maxInclusive != null || this._maxExclusive != null;
    }

    public boolean hasMinimum() {
        return this._minInclusive != null || this._minExclusive != null;
    }

    public String newInstanceCode() {
        return "new " + this.getJType().getName() + "();";
    }

    public void setFacets(SimpleType simpleType) {
        Enumeration enumeration = XSType.getFacets(simpleType);
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String string = facet.getName();
            try {
                if ("maxExclusive".equals(string)) {
                    this.setMaxExclusive(GYear.parseGYear(facet.getValue()));
                    continue;
                }
                if ("maxInclusive".equals(string)) {
                    this.setMaxInclusive(GYear.parseGYear(facet.getValue()));
                    continue;
                }
                if ("minExclusive".equals(string)) {
                    this.setMinExclusive(GYear.parseGYear(facet.getValue()));
                    continue;
                }
                if ("minInclusive".equals(string)) {
                    this.setMinInclusive(GYear.parseGYear(facet.getValue()));
                    continue;
                }
                if (!"pattern".equals(string)) continue;
                System.out.println("Warning: The facet 'pattern' is not currently supported for XSGYear.");
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
                return;
            }
        }
    }

    public void setMaxExclusive(GYear gYear) {
        this._maxExclusive = gYear;
        this._maxInclusive = null;
    }

    public void setMaxInclusive(GYear gYear) {
        this._maxInclusive = gYear;
        this._maxExclusive = null;
    }

    public void setMinExclusive(GYear gYear) {
        this._minExclusive = gYear;
        this._minInclusive = null;
    }

    public void setMinInclusive(GYear gYear) {
        this._minInclusive = gYear;
        this._minExclusive = null;
    }
}

