/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import java.util.Enumeration;
import org.exolab.castor.builder.types.XSPatternBase;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JType;

public final class XSString
extends XSPatternBase {
    private static final JType jType = new JClass("java.lang.String");
    private int _length = 0;
    private int maxLength = -1;
    private int minLength = 0;
    private String _whiteSpace = "preserve";

    public XSString() {
        super((short)1);
    }

    public String createFromJavaObjectCode(String string) {
        return "(String)" + string;
    }

    public JType getJType() {
        return jType;
    }

    public int getLength() {
        return this._length;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public String getWhiteSpace() {
        return this._whiteSpace;
    }

    public boolean hasLength() {
        return this._length > 0;
    }

    public boolean hasMaxLength() {
        return this.maxLength >= 0;
    }

    public boolean hasMinLength() {
        return this.minLength > 0;
    }

    public boolean hasWhiteSpace() {
        return this._whiteSpace != null;
    }

    public void setFacets(SimpleType simpleType) {
        Enumeration enumeration = XSType.getFacets(simpleType);
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String string = facet.getName();
            if ("maxLength".equals(string)) {
                this.setMaxLength(facet.toInt());
                continue;
            }
            if ("minLength".equals(string)) {
                this.setMinLength(facet.toInt());
                continue;
            }
            if ("length".equals(string)) {
                this.setLength(facet.toInt());
                continue;
            }
            if ("pattern".equals(string)) {
                this.setPattern(facet.getValue());
                continue;
            }
            if (!"whiteSpace".equals(string)) continue;
            this.setWhiteSpace(facet.getValue());
        }
    }

    public void setLength(int n) {
        this._length = n;
        this.setMaxLength(n);
        this.setMinLength(n);
    }

    public void setMaxLength(int n) {
        this.maxLength = n;
    }

    public void setMinLength(int n) {
        this.minLength = n;
    }

    public void setWhiteSpace(String string) {
        if (string.equals("preserve")) {
            this._whiteSpace = string;
        } else if (string.equals("replace")) {
            this._whiteSpace = string;
        } else if (string.equals("collapse")) {
            this._whiteSpace = string;
        } else {
            System.out.println("Warning : " + string + " is a bad entry for the whiteSpace value");
            this._whiteSpace = string;
        }
    }
}

