/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.AttributeGroup;
import org.exolab.castor.xml.schema.AttributeGroupDecl;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.SimpleTypesFactory;
import org.exolab.castor.xml.schema.XMLType;

public class Schema
extends Annotated {
    public static final String DEFAULT_SCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
    private static final String NULL_ARGUMENT = "A null argument was passed to " + (class$org$exolab$castor$xml$schema$Schema != null ? class$org$exolab$castor$xml$schema$Schema : (class$org$exolab$castor$xml$schema$Schema = Schema.class$("org.exolab.castor.xml.schema.Schema"))).getName() + "#";
    private static SimpleTypesFactory simpleTypesFactory = new SimpleTypesFactory();
    private String id = null;
    private String name = null;
    private String schemaNS = null;
    private String targetNS = null;
    private String version = null;
    private Hashtable attributeGroups = null;
    private Hashtable attributes = new Hashtable();
    private Hashtable complexTypes = null;
    private Hashtable simpleTypes = null;
    private Hashtable elements = null;
    private Hashtable _group = null;
    private Hashtable importedSchemas = null;
    private Vector includedSchemas = null;
    private Hashtable namespaces = null;
    static /* synthetic */ Class class$org$exolab$castor$xml$schema$Schema;

    public Schema() {
        this(DEFAULT_SCHEMA_NS);
    }

    public Schema(String string) {
        this.attributeGroups = new Hashtable();
        this.complexTypes = new Hashtable();
        this.simpleTypes = new Hashtable();
        this.elements = new Hashtable();
        this._group = new Hashtable();
        this.importedSchemas = new Hashtable();
        this.includedSchemas = new Vector();
        this.namespaces = new Hashtable();
        this.schemaNS = string;
        this.init();
    }

    public void addAttribute(AttributeDecl attributeDecl) throws SchemaException {
        if (attributeDecl == null) {
            return;
        }
        if (attributeDecl.getSchema() != this) {
            String string = "invalid attempt to add an AttributeDecl which ";
            string = String.valueOf(string) + "belongs to a different Schema; " + this.name;
            throw new SchemaException(string);
        }
        Object v = this.attributes.get(this.name);
        if (v == attributeDecl) {
            return;
        }
        if (v != null) {
            String string = "Error attempting to add an AttributeDecl to this Schema definition, an AttributeDecl already exists with the given name: ";
            throw new SchemaException(String.valueOf(string) + this.name);
        }
        this.attributes.put(this.name, attributeDecl);
    }

    public void addAttributeGroup(AttributeGroupDecl attributeGroupDecl) throws SchemaException {
        String string;
        String string2;
        if (attributeGroupDecl == null) {
            return;
        }
        String string3 = attributeGroupDecl.getName();
        int n = string3.indexOf(58);
        if (n >= 0) {
            string2 = string3.substring(0, n);
            string3 = string3.substring(n + 1);
            string = (String)this.namespaces.get(string2);
            if (string == null) {
                String string4 = "addAttributeGroup: ";
                string4 = String.valueOf(string4) + "Namespace prefix not recognized '" + string2 + "'";
                throw new IllegalArgumentException(string4);
            }
            if (!string.equals(this.targetNS)) {
                String string5 = "AttributeGroup has different namespace than this Schema definition.";
                throw new IllegalArgumentException(string5);
            }
        }
        if (attributeGroupDecl.getSchema() != this) {
            string2 = "invalid attempt to add an AttributeGroup which ";
            string2 = String.valueOf(string2) + "belongs to a different Schema; " + string3;
            throw new SchemaException(string2);
        }
        string2 = this.attributeGroups.get(string3);
        if (string2 == attributeGroupDecl) {
            return;
        }
        if (string2 != null) {
            string = "Error attempting to add an AttributeGroup to this Schema definition, an AttributeGroup already exists with the given name: ";
            throw new SchemaException(String.valueOf(string) + string3);
        }
        this.attributeGroups.put(string3, attributeGroupDecl);
    }

    public synchronized void addComplexType(ComplexType complexType) throws SchemaException {
        String string = complexType.getName();
        if (string == null) {
            String string2 = "a global ComplexType must contain a name.";
            throw new SchemaException(string2);
        }
        if (complexType.getSchema() != this) {
            String string3 = "invalid attempt to add an ComplexType which ";
            string3 = String.valueOf(string3) + "belongs to a different Schema; type name: " + string;
            throw new SchemaException(string3);
        }
        if (this.complexTypes.get(string) != null) {
            String string4 = "a ComplexType already exists with the given name: ";
            throw new SchemaException(String.valueOf(string4) + string);
        }
        this.complexTypes.put(string, complexType);
        complexType.setParent(this);
    }

    public void addElementDecl(ElementDecl elementDecl) throws SchemaException {
        String string = elementDecl.getName();
        if (string == null) {
            String string2 = "an element declaration must contain a name.";
            throw new SchemaException(string2);
        }
        if (this.elements.get(string) != null) {
            String string3 = "an element declaration already exists with the given name: ";
            throw new SchemaException(String.valueOf(string3) + string);
        }
        this.elements.put(string, elementDecl);
    }

    public synchronized void addImportedSchema(Schema schema) throws SchemaException {
        String string = schema.getTargetNamespace();
        if (this.importedSchemas.get(string) != null) {
            String string2 = "a Schema has already been imported with the given namespace: ";
            throw new SchemaException(String.valueOf(string2) + string);
        }
        this.importedSchemas.put(string, schema);
    }

    public void addInclude(String string) {
        this.includedSchemas.addElement(string);
    }

    public void addModelGroup(ModelGroup modelGroup) throws SchemaException {
        String string = modelGroup.getName();
        if (string == null) {
            String string2 = "a group declaration must contain a name.";
            throw new SchemaException(string2);
        }
        if (this._group.get(string) != null) {
            String string3 = "an group declaration already exists with the given name: ";
            throw new SchemaException(String.valueOf(string3) + string);
        }
        this._group.put(string, modelGroup);
    }

    public void addNamespace(String string, String string2) {
        this.namespaces.put(string, string2);
    }

    public synchronized void addSimpleType(SimpleType simpleType) throws SchemaException {
        String string = simpleType.getName();
        if (string == null || string.length() == 0) {
            String string2 = "No name found for top-level SimpleType.  A top-level SimpleType must have a name.";
            throw new SchemaException(string2);
        }
        if (simpleType.getSchema() != this) {
            String string3 = "invalid attempt to add a SimpleType which ";
            string3 = String.valueOf(string3) + "belongs to a different Schema; type name: " + string;
            throw new SchemaException(string3);
        }
        if (this.simpleTypes.get(string) != null) {
            String string4 = "a SimpleType already exists with the given name: ";
            throw new SchemaException(String.valueOf(string4) + string);
        }
        simpleType.setParent(this);
        this.simpleTypes.put(string, simpleType);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ComplexType createComplexType() {
        return new ComplexType(this);
    }

    public ComplexType createComplexType(String string) {
        return new ComplexType(this, string);
    }

    public SimpleType createSimpleType(String string, String string2, String string3) {
        return simpleTypesFactory.createUserSimpleType(this, string, string2, string3, true);
    }

    public SimpleType createSimpleType(String string, SimpleType simpleType) {
        return simpleTypesFactory.createUserSimpleType(this, string, simpleType, "restriction");
    }

    public AttributeDecl getAttribute(String string) {
        if (string == null) {
            String string2 = String.valueOf(NULL_ARGUMENT) + "getAttribute: ";
            string2 = String.valueOf(string2) + "'name' cannot be null.";
            throw new IllegalArgumentException(string2);
        }
        String string3 = string;
        String string4 = "";
        String string5 = this.targetNS;
        int n = string.indexOf(58);
        if (n != -1) {
            string3 = string.substring(n + 1);
            string4 = string.substring(0, n);
            string5 = (String)this.namespaces.get(string4);
            if (string5 == null) {
                String string6 = "getAttribute: ";
                string6 = String.valueOf(string6) + "Namespace prefix not recognized '" + string + "'";
                throw new IllegalArgumentException(string6);
            }
        }
        if (string5 == null || string5.equals(this.targetNS)) {
            return (AttributeDecl)this.attributes.get(string3);
        }
        Schema schema = this.getImportedSchema(string5);
        if (schema != null) {
            return schema.getAttribute(string3);
        }
        return null;
    }

    public AttributeGroup getAttributeGroup(String string) {
        if (string == null) {
            String string2 = String.valueOf(NULL_ARGUMENT) + "getAttributeGroup: ";
            string2 = String.valueOf(string2) + "'name' cannot be null.";
            throw new IllegalArgumentException(string2);
        }
        String string3 = string;
        String string4 = "";
        String string5 = this.targetNS;
        int n = string.indexOf(58);
        if (n != -1) {
            string3 = string.substring(n + 1);
            string4 = string.substring(0, n);
            string5 = (String)this.namespaces.get(string4);
            if (string5 == null) {
                String string6 = "getAttributeGroup: ";
                string6 = String.valueOf(string6) + "Namespace prefix not recognized '" + string + "'";
                throw new IllegalArgumentException(string6);
            }
        }
        if (string5 == null || string5.equals(this.targetNS)) {
            return (AttributeGroup)this.attributeGroups.get(string3);
        }
        Schema schema = this.getImportedSchema(string5);
        if (schema != null) {
            return schema.getAttributeGroup(string3);
        }
        return null;
    }

    public Enumeration getAttributeGroups() {
        return this.attributeGroups.elements();
    }

    public Enumeration getAttributes() {
        return this.attributes.elements();
    }

    public String getBuiltInTypeName(int n) {
        return simpleTypesFactory.getBuiltInTypeName(n);
    }

    public ComplexType getComplexType(String string) {
        if (string == null) {
            String string2 = String.valueOf(NULL_ARGUMENT) + "getComplexType: ";
            string2 = String.valueOf(string2) + "'name' cannot be null.";
            throw new IllegalArgumentException(string2);
        }
        String string3 = string;
        String string4 = "";
        String string5 = this.targetNS;
        int n = string.indexOf(58);
        if (n != -1) {
            string3 = string.substring(n + 1);
            string4 = string.substring(0, n);
            string5 = (String)this.namespaces.get(string4);
            if (string5 == null) {
                String string6 = "getComplexType: ";
                string6 = String.valueOf(string6) + "Namespace prefix not recognized '" + string + "'";
                throw new IllegalArgumentException(string6);
            }
        }
        if (string5 == null || string5.equals(this.targetNS)) {
            return (ComplexType)this.complexTypes.get(string3);
        }
        Schema schema = this.getImportedSchema(string5);
        if (schema != null) {
            return schema.getComplexType(string3);
        }
        return null;
    }

    public Enumeration getComplexTypes() {
        return this.complexTypes.elements();
    }

    public ElementDecl getElementDecl(String string) {
        Object object;
        String string2 = null;
        if (string == null) {
            String string3 = String.valueOf(NULL_ARGUMENT) + "getElementDecl: ";
            string3 = String.valueOf(string3) + " 'name' can not be null";
            throw new IllegalArgumentException(string3);
        }
        int n = string.indexOf(58);
        if (n >= 0) {
            object = string.substring(0, n);
            string = string.substring(n + 1);
            string2 = (String)this.namespaces.get(object);
            if (string2 == null) {
                String string4 = "getElementDecl: ";
                string4 = String.valueOf(string4) + "Namespace prefix not recognized '" + (String)object + "'";
                throw new IllegalArgumentException(string4);
            }
        }
        if (string2 == null || string2.equals(this.targetNS)) {
            return (ElementDecl)this.elements.get(string);
        }
        object = this.getImportedSchema(string2);
        if (object != null) {
            String string5 = "Warning : do not forget to generate the source ";
            string5 = String.valueOf(string5) + "for the schema with this targetNamespace: " + ((Schema)object).getTargetNamespace();
            System.out.println(string5);
            return ((Schema)object).getElementDecl(string);
        }
        return null;
    }

    public Enumeration getElementDecls() {
        return this.elements.elements();
    }

    public String getId() {
        return this.id;
    }

    public Schema getImportedSchema(String string) {
        return (Schema)this.importedSchemas.get(string);
    }

    public ModelGroup getModelGroup(String string) {
        Object object;
        String string2 = null;
        if (string == null) {
            String string3 = String.valueOf(NULL_ARGUMENT) + "getModelGroup: ";
            string3 = String.valueOf(string3) + " 'name' can not be null";
            throw new IllegalArgumentException(string3);
        }
        int n = string.indexOf(58);
        if (n >= 0) {
            object = string.substring(0, n);
            string = string.substring(n + 1);
            string2 = (String)this.namespaces.get(object);
            if (string2 == null) {
                String string4 = "getModelGroup: ";
                string4 = String.valueOf(string4) + "Namespace prefix not recognized '" + (String)object + "'";
                throw new IllegalArgumentException(string4);
            }
        }
        if (string2 == null || string2.equals(this.targetNS)) {
            return (ModelGroup)this._group.get(string);
        }
        object = this.getImportedSchema(string2);
        if (object != null) {
            String string5 = "Warning : do not forget to generate the source ";
            string5 = String.valueOf(string5) + "for the schema with this targetNamespace: " + ((Schema)object).getTargetNamespace();
            System.out.println(string5);
            return ((Schema)object).getModelGroup(string);
        }
        return null;
    }

    public Enumeration getModelGroups() {
        return this._group.elements();
    }

    public Hashtable getNamespaces() {
        return this.namespaces;
    }

    public String getSchemaNamespace() {
        return this.schemaNS;
    }

    public SimpleType getSimpleType(String string) {
        if (string == null) {
            String string2 = String.valueOf(NULL_ARGUMENT) + "getSimpleType: ";
            string2 = String.valueOf(string2) + "'name' cannot be null.";
            throw new IllegalArgumentException(string2);
        }
        String string3 = string;
        String string4 = "";
        String string5 = null;
        int n = string.indexOf(58);
        if (n >= 0) {
            string3 = string.substring(n + 1);
            string4 = string.substring(0, n);
            string5 = (String)this.namespaces.get(string4);
            if (string5 == null) {
                String string6 = "getSimpleType: ";
                string6 = String.valueOf(string6) + "Namespace prefix not recognised '" + string + "'";
                throw new IllegalArgumentException(string6);
            }
        }
        SimpleType simpleType = null;
        if (string5 == null) {
            simpleType = simpleTypesFactory.getBuiltInType(string);
            if (simpleType != null && this.namespaces.contains(DEFAULT_SCHEMA_NS)) {
                String string7 = "getSimpleType: the simple type '" + string + "' has not been declared in XML Schema namespace.";
                throw new IllegalArgumentException(string7);
            }
            if (simpleType == null) {
                simpleType = (SimpleType)this.simpleTypes.get(string);
            }
        } else if (string5.equals(this.schemaNS)) {
            simpleType = simpleTypesFactory.getBuiltInType(string3);
        } else if (string5.equals(this.targetNS)) {
            simpleType = (SimpleType)this.simpleTypes.get(string3);
        } else {
            Schema schema = this.getImportedSchema(string5);
            if (schema != null) {
                simpleType = schema.getSimpleType(string3);
            }
        }
        if (simpleType != null) {
            simpleType = (SimpleType)simpleType.getType();
        }
        return simpleType;
    }

    public Enumeration getSimpleTypes() {
        return this.simpleTypes.elements();
    }

    public short getStructureType() {
        return 12;
    }

    public String getTargetNamespace() {
        return this.targetNS;
    }

    public XMLType getType(String string) {
        XMLType xMLType = this.getSimpleType(string);
        if (xMLType == null) {
            xMLType = this.getComplexType(string);
        }
        return xMLType;
    }

    static SimpleTypesFactory getTypeFactory() {
        return simpleTypesFactory;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean includeProcessed(String string) {
        return this.includedSchemas.contains(string);
    }

    private void init() {
    }

    public boolean isKnownNamespace(String string) {
        Enumeration enumeration = this.namespaces.elements();
        while (enumeration.hasMoreElements()) {
            if (!enumeration.nextElement().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean removeComplexType(ComplexType complexType) {
        if (complexType.isTopLevel() && this.complexTypes.contains(complexType)) {
            this.complexTypes.remove(complexType.getName());
            complexType.setParent(null);
            return true;
        }
        return false;
    }

    public boolean removeSimpleType(SimpleType simpleType) {
        if (this.simpleTypes.contains(simpleType)) {
            this.simpleTypes.remove(simpleType.getName());
            return true;
        }
        return false;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setTargetNamespace(String string) {
        this.targetNS = string;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public void validate() throws ValidationException {
    }
}

