/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.validators;

import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.validators.PatternValidator;

public class ByteValidator
extends PatternValidator
implements TypeValidator {
    private boolean useMin = false;
    private boolean useMax = false;
    private boolean useFixed = false;
    private byte min = 0;
    private byte max = 0;
    private byte fixed = 0;

    public void clearFixed() {
        this.useFixed = false;
    }

    public void clearMax() {
        this.useMax = false;
    }

    public void clearMin() {
        this.useMin = false;
    }

    public void setFixed(byte by) {
        this.useFixed = true;
        this.fixed = by;
    }

    public void setMaxExclusive(byte by) {
        this.useMax = true;
        this.max = (byte)(by - 1);
    }

    public void setMaxInclusive(byte by) {
        this.useMax = true;
        this.max = by;
    }

    public void setMinExclusive(byte by) {
        this.useMin = true;
        this.min = (byte)(by + 1);
    }

    public void setMinInclusive(byte by) {
        this.useMin = true;
        this.min = by;
    }

    public void validate(byte by) throws ValidationException {
        if (this.useFixed) {
            if (by != this.fixed) {
                String string = String.valueOf(by) + " is not equal to the fixed value of " + this.fixed;
                throw new ValidationException(string);
            }
            return;
        }
        if (this.useMin && by < this.min) {
            String string = String.valueOf(by) + " is less than the minimum allowable ";
            string = String.valueOf(string) + "value of " + this.min;
            throw new ValidationException(string);
        }
        if (this.useMax && by > this.max) {
            String string = String.valueOf(by) + " is greater than the maximum allowable ";
            string = String.valueOf(string) + "value of " + this.max;
            throw new ValidationException(string);
        }
        if (this.hasPattern()) {
            super.validate(Byte.toString(by));
        }
    }

    public void validate(Object object) throws ValidationException {
        if (object == null) {
            String string = "ByteValidator cannot validate a null object.";
            throw new ValidationException(string);
        }
        byte by = 0;
        try {
            by = (Byte)object;
        }
        catch (Exception exception) {
            String string = "Expecting a Byte, received instead: ";
            string = String.valueOf(string) + object.getClass().getName();
            throw new ValidationException(string);
        }
        this.validate(by);
    }
}

