/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.model;

import info.bliki.htmlcleaner.ContentToken;
import info.bliki.htmlcleaner.TagToken;
import info.bliki.wiki.filter.Encoder;
import info.bliki.wiki.filter.HTMLConverter;
import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.filter.WikipediaParser;
import info.bliki.wiki.model.AbstractWikiModel;
import info.bliki.wiki.model.Configuration;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.model.ImageFormat;
import info.bliki.wiki.model.SemanticAttribute;
import info.bliki.wiki.model.SemanticRelation;
import info.bliki.wiki.namespaces.INamespace;
import info.bliki.wiki.tags.PTag;
import info.bliki.wiki.tags.WPATag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiModel
extends AbstractWikiModel {
    protected Map<String, String> categories = null;
    protected Set<String> links = null;
    protected Set<String> templates = null;
    protected List<SemanticRelation> semanticRelations = null;
    protected List<SemanticAttribute> semanticAttributes = null;
    private String fExternalImageBaseURL;
    private String fExternalWikiBaseURL;

    public WikiModel(String imageBaseURL, String linkBaseURL) {
        this(Configuration.DEFAULT_CONFIGURATION, imageBaseURL, linkBaseURL);
    }

    public WikiModel(Configuration configuration, String imageBaseURL, String linkBaseURL) {
        super(configuration);
        this.fExternalImageBaseURL = imageBaseURL;
        this.fExternalWikiBaseURL = linkBaseURL;
    }

    public WikiModel(Configuration configuration, Locale locale, String imageBaseURL, String linkBaseURL) {
        super(configuration, locale);
        this.fExternalImageBaseURL = imageBaseURL;
        this.fExternalWikiBaseURL = linkBaseURL;
    }

    public WikiModel(Configuration configuration, ResourceBundle resourceBundle, INamespace namespace, String imageBaseURL, String linkBaseURL) {
        super(configuration, resourceBundle, namespace);
        this.fExternalImageBaseURL = imageBaseURL;
        this.fExternalWikiBaseURL = linkBaseURL;
    }

    @Override
    public void addCategory(String categoryName, String sortKey) {
        this.categories.put(categoryName, sortKey);
    }

    @Override
    public void addLink(String topicName) {
        this.links.add(topicName);
    }

    @Override
    public boolean addSemanticAttribute(String attribute, String attributeValue) {
        if (this.semanticAttributes == null) {
            this.semanticAttributes = new ArrayList<SemanticAttribute>();
        }
        this.semanticAttributes.add(new SemanticAttribute(attribute, attributeValue));
        return true;
    }

    @Override
    public boolean addSemanticRelation(String relation, String relationValue) {
        if (this.semanticRelations == null) {
            this.semanticRelations = new ArrayList<SemanticRelation>();
        }
        this.semanticRelations.add(new SemanticRelation(relation, relationValue));
        return true;
    }

    @Override
    public void addTemplate(String template) {
        this.templates.add(template);
    }

    @Override
    public void appendInternalLink(String topic, String hashSection, String topicDescription, String cssClass, boolean parseRecursive) {
        String hrefLink;
        String description = topicDescription;
        WPATag aTagNode = new WPATag();
        if (topic.length() > 0) {
            aTagNode.addAttribute("title", topic, true);
            String encodedtopic = this.encodeTitleToUrl(topic, true);
            if (this.replaceColon()) {
                encodedtopic = encodedtopic.replace(':', '/');
            }
            hrefLink = this.getWikiBaseURL().replace("${title}", encodedtopic);
        } else if (hashSection != null) {
            hrefLink = "";
            if (description.length() == 0) {
                description = "&#35;" + hashSection;
            }
        } else {
            hrefLink = this.getWikiBaseURL().replace("${title}", "");
        }
        String href = hrefLink;
        if (hashSection != null) {
            href = href + '#' + this.encodeTitleDotUrl(hashSection, true);
        }
        aTagNode.addAttribute("href", href, true);
        if (cssClass != null) {
            aTagNode.addAttribute("class", cssClass, true);
        }
        aTagNode.addObjectAttribute("wikilink", topic);
        this.pushNode(aTagNode);
        if (parseRecursive) {
            WikipediaParser.parseRecursive(description.trim(), this, false, true);
        } else {
            aTagNode.addChild(new ContentToken(description));
        }
        this.popNode();
    }

    public Map<String, String> getCategories() {
        return this.categories;
    }

    @Override
    public Set<String> getLinks() {
        return this.links;
    }

    @Override
    public List<SemanticAttribute> getSemanticAttributes() {
        return this.semanticAttributes;
    }

    @Override
    public List<SemanticRelation> getSemanticRelations() {
        return this.semanticRelations;
    }

    public Set<String> getTemplates() {
        return this.templates;
    }

    @Override
    public void parseInternalImageLink(String imageNamespace, String rawImageLink) {
        String imageSrc = this.getImageBaseURL();
        if (imageSrc != null) {
            String link;
            String imageHref = this.getWikiBaseURL();
            ImageFormat imageFormat = ImageFormat.getImageFormat(rawImageLink, imageNamespace);
            String imageName = imageFormat.getFilename();
            String sizeStr = imageFormat.getWidthStr();
            if (sizeStr != null) {
                imageName = sizeStr + '-' + imageName;
            }
            if (imageName.endsWith(".svg")) {
                imageName = imageName + ".png";
            }
            imageName = Encoder.encodeUrl(imageName);
            if (this.replaceColon()) {
                imageName = imageName.replace(':', '/');
            }
            if ((link = imageFormat.getLink()) != null) {
                if (link.length() == 0) {
                    imageHref = "";
                } else {
                    String encodedTitle = this.encodeTitleToUrl(link, true);
                    imageHref = imageHref.replace("${title}", encodedTitle);
                }
            } else {
                imageHref = this.replaceColon() ? imageHref.replace("${title}", imageNamespace + '/' + imageName) : imageHref.replace("${title}", imageNamespace + ':' + imageName);
            }
            imageSrc = imageSrc.replace("${image}", imageName);
            String type = imageFormat.getType();
            TagToken tag = null;
            if ("thumb".equals(type) || "frame".equals(type)) {
                if (this.fTagStack.size() > 0) {
                    tag = this.peekNode();
                }
                this.reduceTokenStack(Configuration.HTML_DIV_OPEN);
            }
            this.appendInternalImageLink(imageHref, imageSrc, imageFormat);
            if (tag instanceof PTag) {
                this.pushNode(new PTag());
            }
        }
    }

    @Override
    public boolean replaceColon() {
        return false;
    }

    @Override
    public void setUp() {
        super.setUp();
        this.categories = new HashMap<String, String>();
        this.links = new HashSet<String>();
        this.templates = new HashSet<String>();
        this.semanticRelations = null;
        this.semanticAttributes = null;
    }

    @Override
    public INamespace getNamespace() {
        return this.fNamespace;
    }

    public static void toText(IWikiModel model, ITextConverter converter, String rawWikiText, Appendable resultBuffer, boolean templateTopic, boolean parseTemplates) throws IOException {
        model.render(converter, rawWikiText, resultBuffer, templateTopic, parseTemplates);
    }

    public static void toHtml(String rawWikiText, Appendable resultBuffer, String imageBaseURL, String linkBaseURL) throws IOException {
        WikiModel.toText(new WikiModel(imageBaseURL, linkBaseURL), new HTMLConverter(), rawWikiText, resultBuffer, false, false);
    }

    public static void toHtml(String rawWikiText, Appendable resultBuffer) throws IOException {
        WikiModel.toText(new WikiModel("/${image}", "/${title}"), new HTMLConverter(), rawWikiText, resultBuffer, false, false);
    }

    public static String toHtml(String rawWikiText) {
        try {
            StringBuilder resultBuffer = new StringBuilder(rawWikiText.length() + rawWikiText.length() / 10);
            WikiModel.toText(new WikiModel("/${image}", "/${title}"), new HTMLConverter(), rawWikiText, resultBuffer, false, false);
            return resultBuffer.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    @Override
    public String getImageBaseURL() {
        return this.fExternalImageBaseURL;
    }

    @Override
    public String getWikiBaseURL() {
        return this.fExternalWikiBaseURL;
    }
}

