/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.screens;

import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.modules.screens.FileuploadThumbnailScreen;
import com.aimluck.eip.util.ALCellularUtils;
import java.io.ByteArrayInputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Date;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.om.security.UserIdPrincipal;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;

public class FileuploadFacePhotoScreen
extends FileuploadThumbnailScreen {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)FileuploadFacePhotoScreen.class.getName());
    private static final String KEY_FACE_PHOTO_ID = "uid";

    @Override
    protected void doOutput(RunData rundata) throws Exception {
        try {
            byte[] photo;
            String uid = rundata.getParameters().getString(KEY_FACE_PHOTO_ID);
            if (uid == null || uid.length() <= 0) {
                return;
            }
            ALBaseUser user = (ALBaseUser)JetspeedSecurity.getUser((Principal)new UserIdPrincipal(uid));
            if (!ALCellularUtils.isSmartPhone((RunData)rundata)) {
                photo = user.getPhoto();
                if (photo == null) {
                    return;
                }
                Date date = user.getPhotoModified();
                if (date != null) {
                    super.setLastModified(date);
                }
            } else {
                Date date;
                photo = user.getPhotoSmartphone();
                if (photo == null && user.getPhoto() == null) {
                    return;
                }
                if (photo == null && user.getPhoto() != null) {
                    ByteArrayInputStream tmpStream = new ByteArrayInputStream(user.getPhoto());
                    byte[] shrinkPhoto = FileuploadUtils.getBytesShrink(tmpStream, 64, 64, new ArrayList<String>());
                    user.setPhotoSmartphone(shrinkPhoto);
                    user.setHasPhotoSmartphone(true);
                    user.setPhotoModifiedSmartphone(new Date());
                    JetspeedSecurity.saveUser((JetspeedUser)user);
                    photo = shrinkPhoto;
                }
                if ((date = user.getPhotoModifiedSmartphone()) != null) {
                    super.setLastModified(date);
                }
            }
            super.setFile(photo);
            super.setFileName("photo.jpg");
            super.doOutput(rundata);
        }
        catch (Exception e) {
            logger.error((Object)"FileuploadFacePhotoScreen.doOutput", (Throwable)e);
        }
    }
}

