/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.DeleteDenyException;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.ObjectStore;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;

class DataContextDeleteAction {
    DataContext dataContext;

    DataContextDeleteAction(DataContext context) {
        this.dataContext = context;
    }

    boolean performDelete(Persistent object) throws DeleteDenyException {
        int oldState = object.getPersistenceState();
        if (oldState == 6 || oldState == 1) {
            return false;
        }
        if (!(object instanceof DataObject)) {
            throw new IllegalArgumentException(this + ": this implementation of ObjectContext only supports full DataObjects. Object " + object + " is not supported.");
        }
        DataObject dataObject = (DataObject)object;
        if (dataObject.getDataContext() == null) {
            throw new CayenneRuntimeException("Attempt to delete unregistered non-TRANSIENT object: " + object);
        }
        if (dataObject.getDataContext() != this.dataContext) {
            throw new CayenneRuntimeException("Attempt to delete object regsitered in a different DataContext. Object: " + object + ", data context: " + this.dataContext);
        }
        this.dataContext.prepareForAccess(dataObject, null);
        if (oldState == 2) {
            this.deleteNew(dataObject, oldState);
        } else {
            this.deletePersistent(dataObject, oldState);
        }
        return true;
    }

    private void deletePersistent(DataObject object, int oldState) throws DeleteDenyException {
        this.dataContext.getObjectStore().recordObjectDeleted(object);
        this.processDeleteRules(object, oldState);
    }

    private void deleteNew(DataObject object, int oldState) throws DeleteDenyException {
        object.setPersistenceState(1);
        this.processDeleteRules(object, oldState);
        this.dataContext.getObjectStore().objectsUnregistered(Collections.singletonList(object));
        object.setDataContext(null);
    }

    private void processDeleteRules(DataObject object, int oldState) throws DeleteDenyException {
        ObjEntity entity = this.dataContext.getEntityResolver().lookupObjEntity(object);
        Iterator it = entity.getRelationships().iterator();
        block5: while (it.hasNext()) {
            DataObject relatedObject;
            Iterator<Object> iterator;
            boolean processFlattened;
            ObjRelationship relationship = (ObjRelationship)it.next();
            boolean bl = processFlattened = relationship.isFlattened() && relationship.isToDependentEntity() && !relationship.isReadOnly();
            if (relationship.getDeleteRule() == 0 && !processFlattened) continue;
            List<Object> relatedObjects = Collections.EMPTY_LIST;
            if (relationship.isToMany()) {
                List toMany = (List)object.readNestedProperty(relationship.getName());
                if (toMany.size() > 0) {
                    relatedObjects = new ArrayList<Object>(toMany);
                }
            } else {
                Object relatedObject2 = object.readNestedProperty(relationship.getName());
                if (relatedObject2 != null) {
                    relatedObjects = Collections.singletonList(relatedObject2);
                }
            }
            if (relatedObjects.size() == 0) continue;
            if (relationship.getDeleteRule() == 3) {
                object.setPersistenceState(oldState);
                String message = relatedObjects.size() == 1 ? "1 related object" : relatedObjects.size() + " related objects";
                throw new DeleteDenyException(object, relationship.getName(), message);
            }
            if (processFlattened) {
                ObjectStore objectStore = this.dataContext.getObjectStore();
                iterator = relatedObjects.iterator();
                while (iterator.hasNext()) {
                    relatedObject = (DataObject)iterator.next();
                    objectStore.recordArcDeleted(object, relatedObject.getObjectId(), relationship.getName());
                }
            }
            switch (relationship.getDeleteRule()) {
                case 0: {
                    break;
                }
                case 1: {
                    ObjRelationship inverseRelationship = relationship.getReverseRelationship();
                    if (inverseRelationship == null) break;
                    if (inverseRelationship.isToMany()) {
                        iterator = relatedObjects.iterator();
                        while (iterator.hasNext()) {
                            relatedObject = (DataObject)iterator.next();
                            relatedObject.removeToManyTarget(inverseRelationship.getName(), object, true);
                        }
                        continue block5;
                    }
                    iterator = relatedObjects.iterator();
                    while (iterator.hasNext()) {
                        relatedObject = (DataObject)iterator.next();
                        relatedObject.setToOneTarget(inverseRelationship.getName(), null, true);
                    }
                    continue block5;
                }
                case 2: {
                    iterator = relatedObjects.iterator();
                    while (iterator.hasNext()) {
                        relatedObject = (DataObject)iterator.next();
                        new DataContextDeleteAction(this.dataContext).performDelete(relatedObject);
                    }
                    continue block5;
                }
                default: {
                    object.setPersistenceState(oldState);
                    throw new CayenneRuntimeException("Invalid delete rule " + relationship.getDeleteRule());
                }
            }
        }
    }
}

