/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.access.DataDomainDBDiffBuilder;
import org.apache.cayenne.access.DataDomainFlushAction;
import org.apache.cayenne.access.DataDomainSyncBucket;
import org.apache.cayenne.access.DataNodeSyncQualifierDescriptor;
import org.apache.cayenne.access.ObjectDiff;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.UpdateBatchQuery;

class DataDomainUpdateBucket
extends DataDomainSyncBucket {
    DataDomainUpdateBucket(DataDomainFlushAction parent) {
        super(parent);
    }

    void appendQueriesInternal(Collection queries) {
        DataDomainDBDiffBuilder diffBuilder = new DataDomainDBDiffBuilder();
        DataNodeSyncQualifierDescriptor qualifierBuilder = new DataNodeSyncQualifierDescriptor();
        Iterator i = this.dbEntities.iterator();
        while (i.hasNext()) {
            DbEntity dbEntity = (DbEntity)i.next();
            List objEntitiesForDbEntity = (List)this.objEntitiesByDbEntity.get(dbEntity);
            LinkedHashMap<List<Object>, UpdateBatchQuery> batches = new LinkedHashMap<List<Object>, UpdateBatchQuery>();
            Iterator j = objEntitiesForDbEntity.iterator();
            while (j.hasNext()) {
                ObjEntity entity = (ObjEntity)j.next();
                diffBuilder.reset(entity, dbEntity);
                qualifierBuilder.reset(entity, dbEntity);
                boolean isRootDbEntity = entity.getDbEntity() == dbEntity;
                List objects = (List)this.objectsByEntity.get(entity);
                Iterator k = objects.iterator();
                while (k.hasNext()) {
                    DataObject o = (DataObject)k.next();
                    ObjectDiff diff = this.parent.objectDiff(o.getObjectId());
                    Map snapshot = diffBuilder.buildDBDiff(diff);
                    if (snapshot == null) {
                        if (!isRootDbEntity) continue;
                        k.remove();
                        o.setPersistenceState(3);
                        continue;
                    }
                    this.checkReadOnly(entity);
                    Map qualifierSnapshot = qualifierBuilder.createQualifierSnapshot(diff);
                    Set snapshotSet = snapshot.keySet();
                    HashSet nullQualifierNames = new HashSet();
                    Iterator it = qualifierSnapshot.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        if (entry.getValue() != null) continue;
                        nullQualifierNames.add(entry.getKey());
                    }
                    List<Object> batchKey = Arrays.asList(snapshotSet, nullQualifierNames);
                    UpdateBatchQuery batch = (UpdateBatchQuery)batches.get(batchKey);
                    if (batch == null) {
                        batch = new UpdateBatchQuery(dbEntity, qualifierBuilder.getAttributes(), this.updatedAttributes(dbEntity, snapshot), nullQualifierNames, 10);
                        batch.setUsingOptimisticLocking(qualifierBuilder.isUsingOptimisticLocking());
                        batches.put(batchKey, batch);
                    }
                    batch.add(qualifierSnapshot, snapshot, o.getObjectId());
                    if (!isRootDbEntity) continue;
                    Map replacementId = o.getObjectId().getReplacementIdMap();
                    Iterator pkIt = dbEntity.getPrimaryKey().iterator();
                    while (pkIt.hasNext()) {
                        String name = ((DbAttribute)pkIt.next()).getName();
                        if (!snapshot.containsKey(name) || replacementId.containsKey(name)) continue;
                        replacementId.put(name, snapshot.get(name));
                    }
                }
            }
            queries.addAll(batches.values());
        }
    }

    private List updatedAttributes(DbEntity entity, Map updatedSnapshot) {
        ArrayList attributes = new ArrayList(updatedSnapshot.size());
        SortedMap entityAttributes = entity.getAttributeMap();
        Iterator it = updatedSnapshot.keySet().iterator();
        while (it.hasNext()) {
            Object name = it.next();
            attributes.add(entityAttributes.get(name));
        }
        return attributes;
    }
}

