/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.Fault;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.ObjectDiff;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.util.Util;

class DataRowUtils {
    static void mergeObjectWithSnapshot(ObjEntity entity, DataObject object, DataRow snapshot) {
        int state = object.getPersistenceState();
        if (entity.isReadOnly() || state == 5) {
            DataRowUtils.refreshObjectWithSnapshot(entity, object, snapshot, true);
        } else if (state != 3) {
            DataRowUtils.forceMergeWithSnapshot(entity, object, snapshot);
        } else {
            DataRowUtils.refreshObjectWithSnapshot(entity, object, snapshot, false);
        }
    }

    static void refreshObjectWithSnapshot(ObjEntity objEntity, DataObject object, DataRow snapshot, boolean invalidateToManyRelationships) {
        SortedMap rMap;
        boolean isPartialSnapshot = false;
        SortedMap attrMap = objEntity.getAttributeMap();
        if (!attrMap.isEmpty()) {
            Iterator it = attrMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                ObjAttribute attr = (ObjAttribute)entry.getValue();
                String dbAttrPath = attr.getDbAttributePath();
                Object value = snapshot.get(dbAttrPath);
                object.writePropertyDirectly(attr.getName(), value);
                if (value != null || snapshot.containsKey(dbAttrPath)) continue;
                isPartialSnapshot = true;
            }
        }
        if (!(rMap = objEntity.getRelationshipMap()).isEmpty()) {
            Iterator it = rMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                ObjRelationship rel = (ObjRelationship)e.getValue();
                if (rel.isToMany()) {
                    Object toManyList = object.readPropertyDirectly(rel.getName());
                    if (toManyList == null) {
                        object.writePropertyDirectly(rel.getName(), Fault.getToManyFault());
                        continue;
                    }
                    if (!invalidateToManyRelationships || !(toManyList instanceof ValueHolder)) continue;
                    ((ValueHolder)toManyList).invalidate();
                    continue;
                }
                object.writePropertyDirectly(rel.getName(), Fault.getToOneFault());
            }
        }
        object.setPersistenceState(isPartialSnapshot ? 5 : 3);
    }

    static void forceMergeWithSnapshot(ObjEntity entity, DataObject object, DataRow snapshot) {
        DataContext context = object.getDataContext();
        ObjectDiff diff = (ObjectDiff)context.getObjectStore().getChangesByObjectId().get(object.getObjectId());
        SortedMap attrMap = entity.getAttributeMap();
        Iterator it = attrMap.entrySet().iterator();
        while (it.hasNext()) {
            Object oldVal;
            Map.Entry entry = it.next();
            String attrName = (String)entry.getKey();
            ObjAttribute attr = (ObjAttribute)entry.getValue();
            String dbAttrPath = attr.getDbAttributePath();
            Object newVal = snapshot.get(dbAttrPath);
            if (newVal == null && !snapshot.containsKey(dbAttrPath)) continue;
            Object curVal = object.readPropertyDirectly(attrName);
            if (!Util.nullSafeEquals(curVal, oldVal = diff != null ? diff.getSnapshotValue(attrName) : null) || Util.nullSafeEquals(newVal, curVal)) continue;
            object.writePropertyDirectly(attrName, newVal);
        }
        Iterator rit = entity.getRelationships().iterator();
        while (rit.hasNext()) {
            Serializable target;
            DbRelationship dbRelationship;
            ObjRelationship rel = (ObjRelationship)rit.next();
            if (rel.isToMany() || !rel.isToPK() || DataRowUtils.isToOneTargetModified(rel, object, diff) || !DataRowUtils.hasFK(dbRelationship = (DbRelationship)rel.getDbRelationships().get(0), snapshot)) continue;
            ObjectId id = snapshot.createTargetObjectId(rel.getTargetEntityName(), dbRelationship);
            if (diff != null && diff.containsArcSnapshot(rel.getName()) && Util.nullSafeEquals(id, diff.getArcSnapshotValue(rel.getName()))) continue;
            if (id == null) {
                target = null;
            } else {
                ObjEntity targetEntity = (ObjEntity)rel.getTargetEntity();
                target = context.getEntityResolver().lookupInheritanceTree(targetEntity) != null ? Fault.getToOneFault() : context.localObject(id, null);
            }
            object.writeProperty(rel.getName(), target);
        }
    }

    static boolean hasFK(DbRelationship relationship, Map snapshot) {
        Iterator joins = relationship.getJoins().iterator();
        while (joins.hasNext()) {
            DbJoin join = (DbJoin)joins.next();
            if (snapshot.containsKey(join.getSourceName())) continue;
            return false;
        }
        return true;
    }

    static boolean isToOneTargetModified(ObjRelationship relationship, DataObject object, ObjectDiff diff) {
        ObjectId currentId;
        if (object.getPersistenceState() != 4 || diff == null) {
            return false;
        }
        Object targetObject = object.readPropertyDirectly(relationship.getName());
        if (targetObject instanceof Fault) {
            return false;
        }
        DataObject toOneTarget = (DataObject)targetObject;
        ObjectId objectId = currentId = toOneTarget != null ? toOneTarget.getObjectId() : null;
        if (currentId != null && currentId.isTemporary()) {
            return true;
        }
        if (!diff.containsArcSnapshot(relationship.getName())) {
            return false;
        }
        ObjectId targetId = diff.getArcSnapshotValue(relationship.getName());
        return !Util.nullSafeEquals(currentId, targetId);
    }

    DataRowUtils() {
    }
}

