/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.DataDomainSyncBucket;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.util.DefaultOperationObserver;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;

final class FlattenedArcKey {
    ObjectId sourceId;
    ObjectId destinationId;
    ObjRelationship relationship;
    ObjRelationship reverseRelationship;
    String compareToken;

    FlattenedArcKey(ObjectId sourceId, ObjectId destinationId, ObjRelationship relationship) {
        String relName2;
        this.sourceId = sourceId;
        this.destinationId = destinationId;
        this.relationship = relationship;
        this.reverseRelationship = relationship.getReverseRelationship();
        String relName1 = relationship.getName();
        this.compareToken = this.reverseRelationship != null ? (relName1.compareTo(relName2 = this.reverseRelationship.getName()) <= 0 ? relName1 + "." + relName2 : relName2 + "." + relName1) : relName1;
    }

    DbEntity getJoinEntity() {
        List relList = this.relationship.getDbRelationships();
        if (relList.size() != 2) {
            throw new CayenneRuntimeException("Only single-step flattened relationships are supported in this operation: " + this.relationship);
        }
        DbRelationship firstDbRel = (DbRelationship)relList.get(0);
        return (DbEntity)firstDbRel.getTargetEntity();
    }

    Map buildJoinSnapshotForInsert(DataNode node) {
        Map snapshot = this.lazyJoinSnapshot();
        boolean autoPkDone = false;
        DbEntity joinEntity = this.getJoinEntity();
        List pkAttributes = joinEntity.getPrimaryKey();
        Iterator it = pkAttributes.iterator();
        while (it.hasNext()) {
            DbAttribute dbAttr = (DbAttribute)it.next();
            String dbAttrName = dbAttr.getName();
            if (snapshot.containsKey(dbAttrName)) continue;
            if (autoPkDone) {
                throw new CayenneRuntimeException("Primary Key autogeneration only works for a single attribute.");
            }
            try {
                PkGenerator pkGenerator = node.getAdapter().getPkGenerator();
                Object pkValue = pkGenerator.generatePkForDbEntity(node, joinEntity);
                snapshot.put(dbAttrName, pkValue);
                autoPkDone = true;
            }
            catch (Exception ex) {
                throw new CayenneRuntimeException("Error generating PK: " + ex.getMessage(), ex);
            }
        }
        return snapshot;
    }

    List buildJoinSnapshotsForDelete(DataNode node) {
        Map snapshot = this.eagerJoinSnapshot();
        DbEntity joinEntity = this.getJoinEntity();
        List pkAttributes = joinEntity.getPrimaryKey();
        boolean fetchKey = false;
        Iterator it = pkAttributes.iterator();
        while (it.hasNext()) {
            DbAttribute dbAttr = (DbAttribute)it.next();
            String dbAttrName = dbAttr.getName();
            if (snapshot.containsKey(dbAttrName)) continue;
            fetchKey = true;
            break;
        }
        if (!fetchKey) {
            return Collections.singletonList(snapshot);
        }
        SelectQuery query = new SelectQuery(joinEntity, ExpressionFactory.matchAllDbExp(snapshot, 3));
        query.setFetchingDataRows(true);
        it = pkAttributes.iterator();
        while (it.hasNext()) {
            DbAttribute dbAttr = (DbAttribute)it.next();
            query.addCustomDbAttribute(dbAttr.getName());
        }
        final List[] result = new List[1];
        node.performQueries(Collections.singleton(query), new DefaultOperationObserver(){

            public void nextDataRows(Query query, List dataRows) {
                result[0] = dataRows;
            }
        });
        return result[0];
    }

    boolean isBidirectional() {
        return this.reverseRelationship != null;
    }

    public int hashCode() {
        return this.sourceId.hashCode() + this.destinationId.hashCode() + this.compareToken.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FlattenedArcKey)) {
            return false;
        }
        FlattenedArcKey update = (FlattenedArcKey)object;
        if (!this.compareToken.equals(update.compareToken)) {
            return false;
        }
        boolean bidi = this.isBidirectional();
        if (bidi != update.isBidirectional()) {
            return false;
        }
        return bidi ? this.bidiEquals(update) : this.uniEquals(update);
    }

    private boolean bidiEquals(FlattenedArcKey update) {
        return this.sourceId.equals(update.sourceId) && this.destinationId.equals(update.destinationId) || this.sourceId.equals(update.destinationId) && this.destinationId.equals(update.sourceId);
    }

    private boolean uniEquals(FlattenedArcKey update) {
        return this.sourceId.equals(update.sourceId) && this.destinationId.equals(update.destinationId);
    }

    private Map eagerJoinSnapshot() {
        DbJoin join;
        int i;
        List relList = this.relationship.getDbRelationships();
        if (relList.size() != 2) {
            throw new CayenneRuntimeException("Only single-step flattened relationships are supported in this operation: " + this.relationship);
        }
        DbRelationship firstDbRel = (DbRelationship)relList.get(0);
        DbRelationship secondDbRel = (DbRelationship)relList.get(1);
        Map sourceId = this.sourceId.getIdSnapshot();
        Map destinationId = this.destinationId.getIdSnapshot();
        HashMap snapshot = new HashMap(sourceId.size() + destinationId.size(), 1.0f);
        List joins = firstDbRel.getJoins();
        int numJoins = joins.size();
        for (i = 0; i < numJoins; ++i) {
            join = (DbJoin)joins.get(i);
            snapshot.put(join.getTargetName(), sourceId.get(join.getSourceName()));
        }
        joins = secondDbRel.getJoins();
        numJoins = joins.size();
        for (i = 0; i < numJoins; ++i) {
            join = (DbJoin)joins.get(i);
            snapshot.put(join.getSourceName(), destinationId.get(join.getTargetName()));
        }
        return snapshot;
    }

    private Map lazyJoinSnapshot() {
        DataDomainSyncBucket.PropagatedValueFactory value;
        DbJoin join;
        int i;
        List relList = this.relationship.getDbRelationships();
        if (relList.size() != 2) {
            throw new CayenneRuntimeException("Only single-step flattened relationships are supported in this operation: " + this.relationship);
        }
        DbRelationship firstDbRel = (DbRelationship)relList.get(0);
        DbRelationship secondDbRel = (DbRelationship)relList.get(1);
        List fromSourceJoins = firstDbRel.getJoins();
        List toTargetJoins = secondDbRel.getJoins();
        HashMap<String, DataDomainSyncBucket.PropagatedValueFactory> snapshot = new HashMap<String, DataDomainSyncBucket.PropagatedValueFactory>(fromSourceJoins.size() + toTargetJoins.size(), 1.0f);
        int numJoins = fromSourceJoins.size();
        for (i = 0; i < numJoins; ++i) {
            join = (DbJoin)fromSourceJoins.get(i);
            value = new DataDomainSyncBucket.PropagatedValueFactory(this.sourceId, join.getSourceName());
            snapshot.put(join.getTargetName(), value);
        }
        numJoins = toTargetJoins.size();
        for (i = 0; i < numJoins; ++i) {
            join = (DbJoin)toTargetJoins.get(i);
            value = new DataDomainSyncBucket.PropagatedValueFactory(this.destinationId, join.getTargetName());
            snapshot.put(join.getSourceName(), value);
        }
        return snapshot;
    }
}

