/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.trans;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.trans.OrderingTranslator;
import org.apache.cayenne.access.trans.QualifierTranslator;
import org.apache.cayenne.access.trans.QueryAssembler;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.DerivedDbEntity;
import org.apache.cayenne.map.EntityInheritanceTree;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.query.PrefetchSelectQuery;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.SelectQuery;

public class SelectTranslator
extends QueryAssembler {
    protected static final int[] UNSUPPORTED_DISTINCT_TYPES = new int[]{2004, 2005, -4, -1};
    final Map aliasLookup = new HashMap();
    final List tableList = new ArrayList();
    final List aliasList = new ArrayList();
    final List dbRelList = new ArrayList();
    List resultColumns;
    List groupByList;
    Map attributeOverrides;
    Map defaultAttributesByColumn;
    int aliasCounter;
    boolean suppressingDistinct;
    boolean forcingDistinct;

    protected static boolean isUnsupportedForDistinct(int type) {
        for (int i = 0; i < UNSUPPORTED_DISTINCT_TYPES.length; ++i) {
            if (UNSUPPORTED_DISTINCT_TYPES[i] != type) continue;
            return true;
        }
        return false;
    }

    protected List getColumns() {
        return this.resultColumns;
    }

    public String createSqlString() throws Exception {
        int groupByCount;
        int i;
        this.forcingDistinct = false;
        this.resultColumns = this.buildResultColumns();
        QualifierTranslator tr = this.adapter.getQualifierTranslator(this);
        String parentQualifierStr = null;
        if (this.getSelectQuery().isQualifiedOnParent()) {
            tr.setTranslateParentQual(true);
            parentQualifierStr = tr.doTranslation();
        }
        tr.setTranslateParentQual(false);
        String qualifierStr = tr.doTranslation();
        this.groupByList = this.buildGroupByList();
        OrderingTranslator orderingTranslator = new OrderingTranslator(this);
        String orderByStr = orderingTranslator.doTranslation();
        StringBuffer queryBuf = new StringBuffer();
        queryBuf.append("SELECT ");
        if (this.forcingDistinct || this.getSelectQuery().isDistinct()) {
            this.suppressingDistinct = false;
            Iterator it = this.resultColumns.iterator();
            while (it.hasNext()) {
                ColumnDescriptor column = (ColumnDescriptor)it.next();
                if (!SelectTranslator.isUnsupportedForDistinct(column.getJdbcType())) continue;
                this.suppressingDistinct = true;
                break;
            }
            if (!this.suppressingDistinct) {
                queryBuf.append("DISTINCT ");
            }
        }
        ArrayList<String> selectColumnExpList = new ArrayList<String>();
        Iterator it = this.resultColumns.iterator();
        while (it.hasNext()) {
            ColumnDescriptor column = (ColumnDescriptor)it.next();
            selectColumnExpList.add(column.getQualifiedColumnName());
        }
        if (this.forcingDistinct || this.getSelectQuery().isDistinct()) {
            List orderByColumnList = orderingTranslator.getOrderByColumnList();
            for (i = 0; i < orderByColumnList.size(); ++i) {
                Object orderByColumnExp = orderByColumnList.get(i);
                if (selectColumnExpList.contains(orderByColumnExp)) continue;
                selectColumnExpList.add((String)orderByColumnExp);
            }
        }
        int columnCount = selectColumnExpList.size();
        queryBuf.append((String)selectColumnExpList.get(0));
        for (i = 1; i < columnCount; ++i) {
            queryBuf.append(", ");
            queryBuf.append((String)selectColumnExpList.get(i));
        }
        queryBuf.append(" FROM ");
        int tableCount = this.tableList.size();
        this.appendTable(queryBuf, 0);
        for (int i2 = 1; i2 < tableCount; ++i2) {
            queryBuf.append(", ");
            this.appendTable(queryBuf, i2);
        }
        boolean hasWhere = false;
        int dbRelCount = this.dbRelList.size();
        if (dbRelCount > 0) {
            hasWhere = true;
            queryBuf.append(" WHERE ");
            this.appendJoins(queryBuf, 0);
            for (int i3 = 1; i3 < dbRelCount; ++i3) {
                queryBuf.append(" AND ");
                this.appendJoins(queryBuf, i3);
            }
        }
        if (parentQualifierStr != null) {
            if (hasWhere) {
                queryBuf.append(" AND (");
                queryBuf.append(parentQualifierStr);
                queryBuf.append(")");
            } else {
                hasWhere = true;
                queryBuf.append(" WHERE ");
                queryBuf.append(parentQualifierStr);
            }
        }
        boolean hasGroupBy = false;
        if (this.groupByList != null && (groupByCount = this.groupByList.size()) > 0) {
            hasGroupBy = true;
            queryBuf.append(" GROUP BY ");
            this.appendGroupBy(queryBuf, 0);
            for (int i4 = 1; i4 < groupByCount; ++i4) {
                queryBuf.append(", ");
                this.appendGroupBy(queryBuf, i4);
            }
        }
        if (qualifierStr != null) {
            if (hasGroupBy) {
                queryBuf.append(" HAVING ");
                queryBuf.append(qualifierStr);
            } else if (hasWhere) {
                queryBuf.append(" AND (");
                queryBuf.append(qualifierStr);
                queryBuf.append(")");
            } else {
                hasWhere = true;
                queryBuf.append(" WHERE ");
                queryBuf.append(qualifierStr);
            }
        }
        if (orderByStr != null) {
            queryBuf.append(" ORDER BY ").append(orderByStr);
        }
        return queryBuf.toString();
    }

    public ColumnDescriptor[] getResultColumns() {
        if (this.resultColumns == null || this.resultColumns.isEmpty()) {
            return new ColumnDescriptor[0];
        }
        return this.resultColumns.toArray(new ColumnDescriptor[this.resultColumns.size()]);
    }

    public Map getAttributeOverrides() {
        return this.attributeOverrides != null ? this.attributeOverrides : Collections.EMPTY_MAP;
    }

    public boolean isSuppressingDistinct() {
        return this.suppressingDistinct;
    }

    private SelectQuery getSelectQuery() {
        return (SelectQuery)this.getQuery();
    }

    private List buildGroupByList() {
        DbEntity dbEntity = this.getRootDbEntity();
        return dbEntity instanceof DerivedDbEntity ? ((DerivedDbEntity)dbEntity).getGroupByAttributes() : Collections.EMPTY_LIST;
    }

    List buildResultColumns() {
        this.defaultAttributesByColumn = new HashMap();
        this.newAliasForTable(this.getRootDbEntity());
        ArrayList columns = new ArrayList();
        SelectQuery query = this.getSelectQuery();
        if (query.isFetchingCustomAttributes()) {
            this.appendCustomColumns(columns, query);
        } else {
            this.appendQueryColumns(columns, query);
        }
        return columns;
    }

    List appendQueryColumns(List columns, SelectQuery query) {
        Iterator joins;
        Iterator rels;
        Iterator attrs;
        HashSet attributes = new HashSet();
        ObjEntity oe = this.getRootEntity();
        EntityInheritanceTree tree = null;
        if (query.isResolvingInherited()) {
            tree = this.getRootInheritanceTree();
        }
        Iterator iterator = attrs = tree != null ? tree.allAttributes().iterator() : oe.getAttributes().iterator();
        while (attrs.hasNext()) {
            ObjAttribute oa = (ObjAttribute)attrs.next();
            Iterator dbPathIterator = oa.getDbPathIterator();
            while (dbPathIterator.hasNext()) {
                Object pathPart = dbPathIterator.next();
                if (pathPart instanceof DbRelationship) {
                    DbRelationship rel = (DbRelationship)pathPart;
                    this.dbRelationshipAdded(rel);
                    continue;
                }
                if (!(pathPart instanceof DbAttribute)) continue;
                DbAttribute dbAttr = (DbAttribute)pathPart;
                if (dbAttr == null) {
                    throw new CayenneRuntimeException("ObjAttribute has no DbAttribute: " + oa.getName());
                }
                this.appendColumn(columns, oa, dbAttr, attributes, null);
            }
        }
        Iterator iterator2 = rels = tree != null ? tree.allRelationships().iterator() : oe.getRelationships().iterator();
        while (rels.hasNext()) {
            ObjRelationship rel = (ObjRelationship)rels.next();
            DbRelationship dbRel = (DbRelationship)rel.getDbRelationships().get(0);
            List joins2 = dbRel.getJoins();
            int len = joins2.size();
            for (int i = 0; i < len; ++i) {
                DbJoin join = (DbJoin)joins2.get(i);
                DbAttribute src = join.getSource();
                this.appendColumn(columns, null, src, attributes, null);
            }
        }
        DbEntity table = this.getRootDbEntity();
        Iterator pk = table.getPrimaryKey().iterator();
        while (pk.hasNext()) {
            DbAttribute dba = (DbAttribute)pk.next();
            this.appendColumn(columns, null, dba, attributes, null);
        }
        if (query instanceof PrefetchSelectQuery) {
            Iterator extraPaths = ((PrefetchSelectQuery)query).getResultPaths().iterator();
            while (extraPaths.hasNext()) {
                String path = (String)extraPaths.next();
                Expression pathExp = oe.translateToDbPath(Expression.fromString(path));
                Iterator it = table.resolvePathComponents(pathExp);
                Object pathComponent = null;
                while (it.hasNext()) {
                    pathComponent = it.next();
                    if (!it.hasNext() || !(pathComponent instanceof DbRelationship)) continue;
                    this.dbRelationshipAdded(pathComponent);
                }
                String labelPrefix = pathExp.toString().substring("db:".length());
                if (pathComponent instanceof DbAttribute) {
                    this.appendColumn(columns, null, pathComponent, attributes, labelPrefix);
                    continue;
                }
                if (!(pathComponent instanceof DbRelationship)) continue;
                DbRelationship relationship = pathComponent;
                if (relationship.isToMany()) {
                    this.dbRelationshipAdded(relationship);
                }
                joins = relationship.getJoins().iterator();
                while (joins.hasNext()) {
                    DbJoin j = (DbJoin)joins.next();
                    DbAttribute attribute = relationship.isToMany() ? j.getTarget() : j.getSource();
                    this.appendColumn(columns, null, attribute, attributes, labelPrefix + '.' + j.getTargetName());
                }
            }
        }
        if (query.getPrefetchTree() != null) {
            Iterator jointPrefetches = query.getPrefetchTree().adjacentJointNodes().iterator();
            while (jointPrefetches.hasNext()) {
                PrefetchTreeNode prefetch = (PrefetchTreeNode)jointPrefetches.next();
                Expression prefetchExp = Expression.fromString(prefetch.getPath());
                Expression dbPrefetch = oe.translateToDbPath(prefetchExp);
                Iterator it = table.resolvePathComponents(dbPrefetch);
                DbRelationship r = null;
                while (it.hasNext()) {
                    r = (DbRelationship)it.next();
                    this.dbRelationshipAdded(r);
                }
                if (r == null) {
                    throw new CayenneRuntimeException("Invalid joint prefetch '" + prefetch + "' for entity: " + oe.getName());
                }
                ArrayList<DbAttribute> skipColumns = Collections.EMPTY_LIST;
                if (r.getSourceEntity() == table) {
                    skipColumns = new ArrayList<DbAttribute>(2);
                    joins = r.getJoins().iterator();
                    while (joins.hasNext()) {
                        DbJoin join = (DbJoin)joins.next();
                        if (!attributes.contains(join.getSource())) continue;
                        skipColumns.add(join.getTarget());
                    }
                }
                ObjRelationship targetRel = (ObjRelationship)prefetchExp.evaluate(oe);
                Iterator targetObjAttrs = targetRel.getTargetEntity().getAttributes().iterator();
                String labelPrefix = dbPrefetch.toString().substring("db:".length());
                while (targetObjAttrs.hasNext()) {
                    ObjAttribute oa = (ObjAttribute)targetObjAttrs.next();
                    Iterator dbPathIterator = oa.getDbPathIterator();
                    while (dbPathIterator.hasNext()) {
                        Object pathPart = dbPathIterator.next();
                        if (pathPart instanceof DbRelationship) {
                            DbRelationship rel = (DbRelationship)pathPart;
                            this.dbRelationshipAdded(rel);
                            continue;
                        }
                        if (!(pathPart instanceof DbAttribute)) continue;
                        DbAttribute attribute = (DbAttribute)pathPart;
                        if (attribute == null) {
                            throw new CayenneRuntimeException("ObjAttribute has no DbAttribute: " + oa.getName());
                        }
                        if (skipColumns.contains(attribute)) continue;
                        this.appendColumn(columns, oa, attribute, attributes, labelPrefix + '.' + attribute.getName());
                    }
                }
                Iterator targetAttributes = r.getTargetEntity().getAttributes().iterator();
                while (targetAttributes.hasNext()) {
                    DbAttribute attribute = (DbAttribute)targetAttributes.next();
                    if (skipColumns.contains(attribute)) continue;
                    this.appendColumn(columns, null, attribute, attributes, labelPrefix + '.' + attribute.getName());
                }
            }
        }
        return columns;
    }

    List appendCustomColumns(List columns, SelectQuery query) {
        List customAttributes = query.getCustomDbAttributes();
        DbEntity table = this.getRootDbEntity();
        int len = customAttributes.size();
        for (int i = 0; i < len; ++i) {
            DbAttribute attribute = (DbAttribute)table.getAttribute((String)customAttributes.get(i));
            if (attribute == null) {
                throw new CayenneRuntimeException("Attribute does not exist: " + customAttributes.get(i));
            }
            String alias = this.aliasForTable((DbEntity)attribute.getEntity());
            columns.add(new ColumnDescriptor(attribute, alias));
        }
        return columns;
    }

    private void appendColumn(List columns, ObjAttribute objAttribute, DbAttribute attribute, Set skipSet, String label) {
        if (skipSet.add(attribute)) {
            ColumnDescriptor column;
            String alias = this.aliasForTable((DbEntity)attribute.getEntity());
            ColumnDescriptor columnDescriptor = column = objAttribute != null ? new ColumnDescriptor(objAttribute, attribute, alias) : new ColumnDescriptor(attribute, alias);
            if (label != null) {
                column.setLabel(label);
            }
            columns.add(column);
            this.defaultAttributesByColumn.put(column, objAttribute);
        } else if (objAttribute != null) {
            for (int i = 0; i < columns.size(); ++i) {
                ColumnDescriptor column = (ColumnDescriptor)columns.get(i);
                if (!attribute.getName().equals(column.getName())) continue;
                if (this.attributeOverrides == null) {
                    this.attributeOverrides = new HashMap();
                }
                this.attributeOverrides.put(objAttribute, column);
                ObjAttribute original = (ObjAttribute)this.defaultAttributesByColumn.remove(column);
                if (original == null) break;
                this.attributeOverrides.put(original, column);
                column.setJavaClass(Void.TYPE.getName());
                break;
            }
        }
    }

    private void appendGroupBy(StringBuffer queryBuf, int index) {
        DbAttribute column = (DbAttribute)this.groupByList.get(index);
        String alias = this.aliasForTable((DbEntity)column.getEntity());
        queryBuf.append(column.getAliasedName(alias));
    }

    private void appendTable(StringBuffer queryBuf, int index) {
        DbEntity ent = (DbEntity)this.tableList.get(index);
        queryBuf.append(ent.getFullyQualifiedName());
        queryBuf.append(' ').append((String)this.aliasList.get(index));
    }

    private void appendJoins(StringBuffer queryBuf, int index) {
        DbRelationship rel = (DbRelationship)this.dbRelList.get(index);
        String srcAlias = this.aliasForTable((DbEntity)rel.getSourceEntity());
        String targetAlias = (String)this.aliasLookup.get(rel);
        boolean andFlag = false;
        List joins = rel.getJoins();
        int len = joins.size();
        for (int i = 0; i < len; ++i) {
            DbJoin join = (DbJoin)joins.get(i);
            if (andFlag) {
                queryBuf.append(" AND ");
            } else {
                andFlag = true;
            }
            queryBuf.append(srcAlias).append('.').append(join.getSourceName()).append(" = ").append(targetAlias).append('.').append(join.getTargetName());
        }
    }

    public void dbRelationshipAdded(DbRelationship rel) {
        String existAlias;
        if (rel.isToMany()) {
            this.forcingDistinct = true;
        }
        if ((existAlias = (String)this.aliasLookup.get(rel)) == null) {
            this.dbRelList.add(rel);
            String newAlias = this.newAliasForTable((DbEntity)rel.getTargetEntity());
            this.aliasLookup.put(rel, newAlias);
        }
    }

    protected String newAliasForTable(DbEntity ent) {
        if (ent instanceof DerivedDbEntity) {
            ent = ((DerivedDbEntity)ent).getParentEntity();
        }
        String newAlias = "t" + this.aliasCounter++;
        this.tableList.add(ent);
        this.aliasList.add(newAlias);
        return newAlias;
    }

    public String aliasForTable(DbEntity ent, DbRelationship rel) {
        return (String)this.aliasLookup.get(rel);
    }

    public String aliasForTable(DbEntity ent) {
        int entIndex;
        if (ent instanceof DerivedDbEntity) {
            ent = ((DerivedDbEntity)ent).getParentEntity();
        }
        if ((entIndex = this.tableList.indexOf(ent)) >= 0) {
            return (String)this.aliasList.get(entIndex);
        }
        StringBuffer msg = new StringBuffer();
        msg.append("Alias not found, DbEntity: '").append(ent != null ? ent.getName() : "<null entity>").append("'\nExisting aliases:");
        int len = this.aliasList.size();
        for (int i = 0; i < len; ++i) {
            String dbeName = this.tableList.get(i) != null ? ((DbEntity)this.tableList.get(i)).getName() : "<null entity>";
            msg.append("\n").append(this.aliasList.get(i)).append(" => ").append(dbeName);
        }
        throw new CayenneRuntimeException(msg.toString());
    }

    public boolean supportsTableAliases() {
        return true;
    }
}

