/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.Fault;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.query.InsertBatchQuery;
import org.apache.cayenne.query.UpdateBatchQuery;
import org.apache.cayenne.util.Util;
import org.apache.commons.collections.Factory;

public class BatchQueryUtils {
    private BatchQueryUtils() {
    }

    public static boolean updatesLOBColumns(BatchQuery query) {
        boolean isInsert = query instanceof InsertBatchQuery;
        boolean isUpdate = query instanceof UpdateBatchQuery;
        if (!isInsert && !isUpdate) {
            return false;
        }
        List updatedAttributes = isInsert ? query.getDbAttributes() : ((UpdateBatchQuery)query).getUpdatedAttributes();
        Iterator it = updatedAttributes.iterator();
        while (it.hasNext()) {
            int type = ((DbAttribute)it.next()).getType();
            if (type != 2005 && type != 2004) continue;
            return true;
        }
        return false;
    }

    public static Map buildSnapshotForUpdate(DataObject o) {
        Object oldValue;
        DataContext context = o.getDataContext();
        DataRow committedSnapshot = context.getObjectStore().getSnapshot(o.getObjectId());
        DataRow currentSnapshot = o.getDataContext().currentSnapshot(o);
        if (committedSnapshot == null || committedSnapshot.isEmpty()) {
            return currentSnapshot;
        }
        HashMap snapshot = new HashMap(currentSnapshot.size());
        Iterator it = currentSnapshot.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String attrName = (String)entry.getKey();
            Object newValue = entry.getValue();
            oldValue = committedSnapshot.get(attrName);
            if (Util.nullSafeEquals(oldValue, newValue)) continue;
            snapshot.put(attrName, newValue);
        }
        Iterator origit = committedSnapshot.entrySet().iterator();
        while (origit.hasNext()) {
            Map.Entry entry = origit.next();
            String attrName = (String)entry.getKey();
            oldValue = entry.getValue();
            if (oldValue == null || currentSnapshot.containsKey(attrName)) continue;
            snapshot.put(attrName, null);
        }
        return snapshot;
    }

    public static Map buildSnapshotForInsert(ObjEntity entity, DataObject o, DbRelationship masterDependentRel) {
        return BatchQueryUtils.buildSnapshotForInsert(entity, o, masterDependentRel, false);
    }

    public static Map buildSnapshotForInsert(ObjEntity entity, DataObject o, DbRelationship masterDependentRel, boolean supportsGeneratedKeys) {
        boolean isMasterDbEntity = masterDependentRel == null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        SortedMap attrMap = entity.getAttributeMap();
        Iterator attributes = attrMap.entrySet().iterator();
        while (attributes.hasNext()) {
            DbAttribute dbAttr;
            Map.Entry entry = attributes.next();
            String attrName = (String)entry.getKey();
            ObjAttribute objAttr = (ObjAttribute)entry.getValue();
            if (isMasterDbEntity && !objAttr.isCompound()) {
                map.put(objAttr.getDbAttributePath(), o.readPropertyDirectly(attrName));
                continue;
            }
            if (isMasterDbEntity || !objAttr.isCompound() || (dbAttr = objAttr.getDbAttribute()).getEntity() != masterDependentRel.getTargetEntity()) continue;
            map.put(dbAttr.getName(), o.readPropertyDirectly(attrName));
        }
        Iterator relationships = entity.getRelationshipMap().entrySet().iterator();
        while (relationships.hasNext()) {
            DbRelationship dbRel;
            Map targetKeyMap;
            DataObject target;
            Map.Entry entry = relationships.next();
            String relName = (String)entry.getKey();
            ObjRelationship rel = (ObjRelationship)entry.getValue();
            if (rel.isSourceIndependentFromTargetChange() || (target = (DataObject)o.readPropertyDirectly(relName)) == null || (targetKeyMap = target.getObjectId().getIdSnapshot()) == null) continue;
            if (isMasterDbEntity) {
                dbRel = (DbRelationship)rel.getDbRelationships().get(0);
            } else {
                dbRel = (DbRelationship)rel.getDbRelationships().get(1);
                if (dbRel.getSourceEntity() != masterDependentRel.getTargetEntity()) continue;
            }
            Iterator joins = dbRel.getJoins().iterator();
            while (joins.hasNext()) {
                DbJoin join = (DbJoin)joins.next();
                Object value = targetKeyMap.get(join.getTargetName());
                if (value == null) {
                    if (supportsGeneratedKeys && join.getTarget().isGenerated()) {
                        value = new PropagatedValueFactory(target.getObjectId(), join.getTargetName());
                    } else {
                        throw new CayenneRuntimeException("Some parts of FK are missing in snapshot, join: " + join);
                    }
                }
                map.put(join.getSourceName(), value);
            }
        }
        Map thisIdParts = o.getObjectId().getIdSnapshot();
        if (thisIdParts != null) {
            if (!isMasterDbEntity) {
                thisIdParts = masterDependentRel.targetPkSnapshotWithSrcSnapshot(thisIdParts);
            }
            Iterator itm = thisIdParts.entrySet().iterator();
            while (itm.hasNext()) {
                Map.Entry entry = itm.next();
                Object nextKey = entry.getKey();
                if (map.containsKey(nextKey)) continue;
                map.put((String)nextKey, entry.getValue());
            }
        }
        return map;
    }

    private static String getTargetDbAttributeName(String srcDbAttributeName, DbRelationship masterDependentRel) {
        Iterator i = masterDependentRel.getJoins().iterator();
        while (i.hasNext()) {
            DbJoin join = (DbJoin)i.next();
            if (!srcDbAttributeName.equals(join.getSourceName())) continue;
            return join.getTargetName();
        }
        return null;
    }

    public static Map buildSnapshotForUpdate(ObjEntity entity, DataObject o, DbRelationship masterDependentRel) {
        return BatchQueryUtils.buildSnapshotForUpdate(entity, o, masterDependentRel, false);
    }

    public static Map buildSnapshotForUpdate(ObjEntity entity, DataObject o, DbRelationship masterDependentRel, boolean supportsGeneratedKeys) {
        boolean isMasterDbEntity = masterDependentRel == null;
        DataContext context = o.getDataContext();
        DataRow committedSnapshot = context.getObjectStore().getSnapshot(o.getObjectId());
        DataRow currentSnapshot = o.getDataContext().currentSnapshot(o);
        HashMap snapshot = new HashMap(currentSnapshot.size());
        if (committedSnapshot == null || committedSnapshot.isEmpty()) {
            Iterator i = currentSnapshot.entrySet().iterator();
            while (i.hasNext()) {
                String pkAttrName;
                Map.Entry entry = i.next();
                String dbAttrPath = (String)entry.getKey();
                boolean compoundDbAttr = dbAttrPath.indexOf(".") > 0;
                Object newValue = entry.getValue();
                if (isMasterDbEntity && !compoundDbAttr) {
                    snapshot.put(dbAttrPath, newValue);
                    continue;
                }
                if (!isMasterDbEntity && compoundDbAttr) {
                    Iterator pathIterator = entity.getDbEntity().resolvePathComponents(dbAttrPath);
                    if (!pathIterator.hasNext() || !masterDependentRel.equals(pathIterator.next())) continue;
                    DbAttribute dbAttr = (DbAttribute)pathIterator.next();
                    snapshot.put(dbAttr.getName(), newValue);
                    continue;
                }
                if (isMasterDbEntity || compoundDbAttr || (pkAttrName = BatchQueryUtils.getTargetDbAttributeName(dbAttrPath, masterDependentRel)) == null) continue;
                snapshot.put(pkAttrName, newValue);
            }
            return snapshot;
        }
        Iterator it = currentSnapshot.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String dbAttrPath = (String)entry.getKey();
            boolean compoundDbAttr = dbAttrPath.indexOf(".") > 0;
            Object newValue = entry.getValue();
            Object oldValue = committedSnapshot.get(dbAttrPath);
            if (Util.nullSafeEquals(oldValue, newValue)) continue;
            if (!isMasterDbEntity) {
                if (compoundDbAttr) {
                    Iterator pathIterator = entity.getDbEntity().resolvePathComponents(dbAttrPath);
                    if (!pathIterator.hasNext() || !masterDependentRel.equals(pathIterator.next())) continue;
                    DbAttribute dbAttr = (DbAttribute)pathIterator.next();
                    snapshot.put(dbAttr.getName(), newValue);
                    continue;
                }
                String pkAttrName = BatchQueryUtils.getTargetDbAttributeName(dbAttrPath, masterDependentRel);
                if (pkAttrName == null) continue;
                snapshot.put(pkAttrName, newValue);
                continue;
            }
            if (compoundDbAttr) continue;
            snapshot.put(dbAttrPath, newValue);
        }
        Iterator origit = committedSnapshot.entrySet().iterator();
        while (origit.hasNext()) {
            String pkAttrName;
            boolean compoundDbAttr;
            Map.Entry entry = origit.next();
            String dbAttrPath = (String)entry.getKey();
            if (entry.getValue() == null || currentSnapshot.containsKey(dbAttrPath)) continue;
            boolean bl = compoundDbAttr = dbAttrPath.indexOf(".") > 0;
            if (isMasterDbEntity && !compoundDbAttr) {
                snapshot.put(dbAttrPath, null);
                continue;
            }
            if (!isMasterDbEntity && compoundDbAttr) {
                Iterator pathIterator = entity.getDbEntity().resolvePathComponents(dbAttrPath);
                if (!pathIterator.hasNext() || !masterDependentRel.equals(pathIterator.next())) continue;
                DbAttribute dbAttr = (DbAttribute)pathIterator.next();
                snapshot.put(dbAttr.getName(), null);
                continue;
            }
            if (isMasterDbEntity || compoundDbAttr || (pkAttrName = BatchQueryUtils.getTargetDbAttributeName(dbAttrPath, masterDependentRel)) == null) continue;
            snapshot.put(pkAttrName, null);
        }
        if (supportsGeneratedKeys) {
            Iterator relationships = entity.getRelationships().iterator();
            while (relationships.hasNext()) {
                DbRelationship dbRel;
                ObjectId targetId;
                Map targetKeyMap;
                Object target;
                ObjRelationship rel = (ObjRelationship)relationships.next();
                if (rel.isSourceIndependentFromTargetChange() || (target = o.readPropertyDirectly(rel.getName())) == null || target instanceof Fault || (targetKeyMap = (targetId = ((DataObject)target).getObjectId()).getIdSnapshot()) == null) continue;
                if (isMasterDbEntity) {
                    dbRel = (DbRelationship)rel.getDbRelationships().get(0);
                } else {
                    dbRel = (DbRelationship)rel.getDbRelationships().get(1);
                    if (dbRel.getSourceEntity() != masterDependentRel.getTargetEntity()) continue;
                }
                Iterator joins = dbRel.getJoins().iterator();
                while (joins.hasNext()) {
                    DbJoin join = (DbJoin)joins.next();
                    if (snapshot.get(join.getSourceName()) != null || !join.getTarget().isGenerated()) continue;
                    PropagatedValueFactory value = new PropagatedValueFactory(targetId, join.getTargetName());
                    snapshot.put(join.getSourceName(), value);
                }
            }
        }
        return snapshot;
    }

    static final class PropagatedValueFactory
    implements Factory {
        ObjectId masterID;
        String masterKey;

        PropagatedValueFactory(ObjectId masterID, String masterKey) {
            this.masterID = masterID;
            this.masterKey = masterKey;
        }

        public Object create() {
            if (!this.masterID.isReplacementIdAttached()) {
                throw new CayenneRuntimeException("Deferred propagated key (" + this.masterKey + ") wasn't generated for object with ID " + this.masterID);
            }
            Map replacementId = this.masterID.getReplacementIdMap();
            Object value = replacementId.get(this.masterKey);
            if (value == null) {
                throw new CayenneRuntimeException("Deferred propagated key (" + this.masterKey + ") wasn't generated for object with ID " + this.masterID);
            }
            return value;
        }
    }
}

