/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.util;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.QueryEngine;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.query.SelectQuery;

public class QueryUtils {
    public static SelectQuery selectObjectForId(ObjectId oid) {
        return new SelectQuery(oid.getEntityName(), ExpressionFactory.matchAllDbExp(oid.getIdSnapshot(), 3));
    }

    public static SelectQuery selectQueryForIds(List oids) {
        if (oids == null || oids.size() == 0) {
            throw new IllegalArgumentException("List must contain at least one ObjectId");
        }
        SelectQuery sel = new SelectQuery();
        sel.setRoot(((ObjectId)oids.get(0)).getEntityName());
        Iterator it = oids.iterator();
        ObjectId firstId = (ObjectId)it.next();
        Expression exp = ExpressionFactory.matchAllDbExp(firstId.getIdSnapshot(), 3);
        while (it.hasNext()) {
            ObjectId anId = (ObjectId)it.next();
            exp = exp.orExp(ExpressionFactory.matchAllDbExp(anId.getIdSnapshot(), 3));
        }
        sel.setQualifier(exp);
        return sel;
    }

    public static SelectQuery selectRelationshipObjects(QueryEngine e, DataObject source, String relName) {
        ObjEntity ent = e.getEntityResolver().lookupObjEntity(source);
        ObjRelationship rel = (ObjRelationship)ent.getRelationship(relName);
        ObjEntity destEnt = (ObjEntity)rel.getTargetEntity();
        List dbRels = rel.getDbRelationships();
        if (dbRels == null || dbRels.size() == 0) {
            throw new CayenneRuntimeException("ObjRelationship '" + rel.getName() + "' is unmapped.");
        }
        StringBuffer buf = new StringBuffer();
        ListIterator it = dbRels.listIterator(dbRels.size());
        while (it.hasPrevious()) {
            DbRelationship dbRel;
            DbRelationship reverse;
            if (buf.length() > 0) {
                buf.append(".");
            }
            if ((reverse = (dbRel = (DbRelationship)it.previous()).getReverseRelationship()) == null) {
                throw new CayenneRuntimeException("DbRelationship '" + dbRel.getName() + "' has no reverse relationship");
            }
            buf.append(reverse.getName());
        }
        SelectQuery select = new SelectQuery(destEnt);
        select.setQualifier(ExpressionFactory.matchDbExp(buf.toString(), source));
        select.setResolvingInherited(true);
        return select;
    }
}

