/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.conf;

import java.io.InputStream;
import javax.sql.DataSource;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.access.ConnectionLogger;
import org.apache.cayenne.access.QueryLogger;
import org.apache.cayenne.conf.AbstractHandler;
import org.apache.cayenne.conf.Configuration;
import org.apache.cayenne.conf.DataSourceFactory;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.conn.PoolManager;
import org.apache.cayenne.util.Util;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class DriverDataSourceFactory
implements DataSourceFactory {
    private static Logger logObj = Logger.getLogger(DriverDataSourceFactory.class);
    protected XMLReader parser = Util.createXmlReader();
    protected DataSourceInfo driverInfo;
    protected Configuration parentConfiguration;

    public void initializeWithParentConfiguration(Configuration parentConfiguration) {
        this.parentConfiguration = parentConfiguration;
    }

    public DataSource getDataSource(String location, Level logLevel) throws Exception {
        return this.getDataSource(location);
    }

    public DataSource getDataSource(String location) throws Exception {
        this.load(location);
        ConnectionLogger logger = new ConnectionLogger();
        try {
            return new PoolManager(this.driverInfo.getJdbcDriver(), this.driverInfo.getDataSourceUrl(), this.driverInfo.getMinConnections(), this.driverInfo.getMaxConnections(), this.driverInfo.getUserName(), this.driverInfo.getPassword(), logger);
        }
        catch (Exception ex) {
            QueryLogger.logConnectFailure(ex);
            throw ex;
        }
    }

    protected DataSourceInfo getDriverInfo() {
        return this.driverInfo;
    }

    protected InputStream getInputStream(String location) {
        if (this.parentConfiguration == null) {
            throw new ConfigurationException("No parent Configuration set - cannot continue.");
        }
        return this.parentConfiguration.getResourceLocator().findResourceStream(location);
    }

    protected void load(String location) throws Exception {
        logObj.info("loading driver information from '" + location + "'.");
        InputStream in = this.getInputStream(location);
        if (in == null) {
            logObj.info("Error: location '" + location + "' not found.");
            throw new ConfigurationException("Can't find DataSource configuration file at " + location);
        }
        RootHandler handler = new RootHandler();
        this.parser.setContentHandler(handler);
        this.parser.setErrorHandler(handler);
        this.parser.parse(new InputSource(in));
    }

    private class ConnectionHandler
    extends AbstractHandler {
        public ConnectionHandler(XMLReader parser, ContentHandler parentHandler) {
            super(parser, parentHandler);
        }

        public void init(String name, Attributes atts, DataSourceInfo driverInfo) throws SAXException {
            try {
                String max;
                String min = atts.getValue("min");
                if (min != null) {
                    driverInfo.setMinConnections(Integer.parseInt(min));
                }
                if ((max = atts.getValue("max")) != null) {
                    driverInfo.setMaxConnections(Integer.parseInt(max));
                }
            }
            catch (NumberFormatException nfex) {
                logObj.info("Error loading numeric attribute", nfex);
                throw new SAXException("Error reading numeric attribute.", nfex);
            }
        }
    }

    private class LoginHandler
    extends AbstractHandler {
        public LoginHandler(XMLReader parser, ContentHandler parentHandler) {
            super(parser, parentHandler);
        }

        public void init(String name, Attributes atts, DataSourceInfo driverInfo) {
            logObj.info("loading user name and password.");
            driverInfo.setUserName(atts.getValue("userName"));
            driverInfo.setPassword(atts.getValue("password"));
        }
    }

    private class UrlHandler
    extends AbstractHandler {
        public UrlHandler(XMLReader parser, ContentHandler parentHandler) {
            super(parser, parentHandler);
        }

        public void init(String name, Attributes atts, DataSourceInfo driverInfo) throws SAXException {
            driverInfo.setDataSourceUrl(atts.getValue("value"));
            if (driverInfo.getDataSourceUrl() == null) {
                logObj.info("error: <url> has no 'value'.");
                throw new SAXException("'<url value=' attribute is required.");
            }
        }
    }

    private class DriverHandler
    extends AbstractHandler {
        public DriverHandler(XMLReader parser, ContentHandler parentHandler) {
            super(parser, parentHandler);
        }

        public void init(String name, Attributes attrs) {
            String className = attrs.getValue("", "class");
            logObj.info("loading driver " + className);
            DriverDataSourceFactory.this.driverInfo = new DataSourceInfo();
            DriverDataSourceFactory.this.driverInfo.setJdbcDriver(className);
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (localName.equals("login")) {
                new LoginHandler(this.parser, this).init(localName, atts, DriverDataSourceFactory.this.driverInfo);
            } else if (localName.equals("url")) {
                new UrlHandler(this.parser, this).init(localName, atts, DriverDataSourceFactory.this.driverInfo);
            } else if (localName.equals("connectionPool")) {
                new ConnectionHandler(this.parser, this).init(localName, atts, DriverDataSourceFactory.this.driverInfo);
            } else {
                logObj.info("<login, url, connectionPool> are valid. <" + localName + "> is unexpected.");
                throw new SAXException("Config file is not of expected XML type");
            }
        }
    }

    private class RootHandler
    extends DefaultHandler {
        private RootHandler() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (!localName.equals("driver")) {
                logObj.info("<driver> must be the root element. <" + localName + "> is unexpected.");
                throw new SAXException("Config file is not of expected XML type. '" + localName + "' unexpected.");
            }
            new DriverHandler(DriverDataSourceFactory.this.parser, this).init(localName, atts);
        }
    }
}

