/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cayenne.exp.ASTCompiler;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.commons.collections.Transformer;

public class ListExpression
extends Expression {
    protected List operands = new ArrayList();

    public ListExpression() {
    }

    public ListExpression(int type) {
        this.type = type;
    }

    public Object evaluate(Object o) {
        return ASTCompiler.compile(this).evaluateASTChain(o);
    }

    public Expression notExp() {
        Expression exp = ExpressionFactory.expressionOfType(2);
        exp.setOperand(0, this);
        return exp;
    }

    protected void flattenTree() {
    }

    protected boolean pruneNodeForPrunedChild(Object prunedChild) {
        return false;
    }

    protected Object transformExpression(Transformer transformer) {
        Object transformed = super.transformExpression(transformer);
        if (!(transformed instanceof ListExpression)) {
            return transformed;
        }
        ListExpression listExpression = (ListExpression)transformed;
        switch (listExpression.getOperandCount()) {
            case 1: {
                return listExpression.getOperand(0);
            }
            case 0: {
                return PRUNED_NODE;
            }
        }
        return listExpression;
    }

    public Expression shallowCopy() {
        return new ListExpression(this.type);
    }

    public int getOperandCount() {
        return this.operands.size();
    }

    public Object getOperand(int index) {
        if (this.operands.size() <= index) {
            throw new IllegalArgumentException("Attempt to retrieve operand " + index + ", while current number of operands is " + this.operands.size());
        }
        return this.operands.get(index);
    }

    public void setOperand(int index, Object value) {
        if (this.operands.size() == index) {
            this.appendOperand(value);
        } else if (this.operands.size() > index) {
            this.operands.set(index, value);
        } else {
            throw new IllegalArgumentException("Attempt to set operand " + index + ", while current number of operands is " + this.operands.size());
        }
    }

    public void appendOperand(Object value) {
        this.operands.add(value);
    }

    public void appendOperands(Collection operands) {
        this.operands.addAll(operands);
    }

    public void removeOperand(Object value) {
        this.operands.remove(value);
    }

    public Expression joinExp(int type, Expression exp) {
        if (type != this.type) {
            return super.joinExp(type, exp);
        }
        ListExpression copy = new ListExpression();
        copy.setType(type);
        copy.appendOperands(this.operands);
        copy.appendOperand(exp);
        return copy;
    }

    public void encodeAsString(PrintWriter pw) {
        for (int i = 0; i < this.getOperandCount(); ++i) {
            Object op;
            if (i > 0 || this.getOperandCount() == 1) {
                pw.print(" ");
                pw.print(this.expName());
                pw.print(" ");
            }
            if ((op = this.getOperand(i)) == null) {
                pw.print("<null>");
                continue;
            }
            if (op instanceof String) {
                pw.print("'" + op + "'");
                continue;
            }
            if (op instanceof Expression) {
                pw.print('(');
                ((Expression)op).encodeAsString(pw);
                pw.print(')');
                continue;
            }
            pw.print(String.valueOf(op));
        }
    }
}

