/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DerivedDbEntity;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.util.XMLEncoder;

public class DerivedDbAttribute
extends DbAttribute {
    public static final String ATTRIBUTE_TOKEN = "%@";
    protected String expressionSpec;
    protected List params = new ArrayList();
    protected boolean groupBy;

    public DerivedDbAttribute() {
    }

    public DerivedDbAttribute(String name) {
        super(name);
    }

    public DerivedDbAttribute(String name, int type, DbEntity entity, String spec) {
        super(name, type, entity);
        this.setExpressionSpec(spec);
    }

    public DerivedDbAttribute(DbEntity entity, DbAttribute parentProto) {
        this.setName(parentProto.getName());
        this.setType(parentProto.getType());
        this.setMandatory(parentProto.isMandatory());
        this.setMaxLength(parentProto.getMaxLength());
        this.setPrecision(parentProto.getPrecision());
        this.setPrimaryKey(parentProto.isPrimaryKey());
        this.setExpressionSpec(ATTRIBUTE_TOKEN);
        this.addParam(parentProto);
        this.setEntity(entity);
    }

    public void encodeAsXML(XMLEncoder encoder) {
        List params;
        String spec;
        encoder.print("<db-attribute-derived name=\"" + Util.encodeXmlAttribute(this.getName()) + '\"');
        String type = TypesMapping.getSqlNameByType(this.getType());
        if (type != null) {
            encoder.print(" type=\"" + type + '\"');
        }
        if (this.isPrimaryKey()) {
            encoder.print(" isPrimaryKey=\"true\"");
        }
        if (this.isMandatory()) {
            encoder.print(" isMandatory=\"true\"");
        }
        if (this.getMaxLength() > 0) {
            encoder.print(" length=\"");
            encoder.print(this.getMaxLength());
            encoder.print('\"');
        }
        if (this.getPrecision() > 0) {
            encoder.print(" precision=\"");
            encoder.print(this.getPrecision());
            encoder.print('\"');
        }
        if (((DerivedDbEntity)this.getEntity()).getGroupByAttributes().contains(this)) {
            encoder.print(" isGroupBy=\"true\"");
        }
        if ((spec = this.getExpressionSpec()) != null && spec.trim().length() > 0) {
            encoder.print(" spec=\"");
            encoder.print(spec);
            encoder.print('\"');
        }
        if ((params = this.getParams()).size() > 0) {
            encoder.println(">");
            encoder.indent(1);
            Iterator refs = params.iterator();
            while (refs.hasNext()) {
                DbAttribute ref = (DbAttribute)refs.next();
                encoder.println("<db-attribute-ref name=\"" + Util.encodeXmlAttribute(ref.getName()) + "\"/>");
            }
            encoder.indent(-1);
            encoder.println("</db-attribute-derived>");
        } else {
            encoder.println("/>");
        }
    }

    public String getAliasedName(String alias) {
        if (this.expressionSpec == null) {
            return super.getAliasedName(alias);
        }
        int len = this.params.size();
        StringBuffer buf = new StringBuffer();
        int ind = 0;
        for (int i = 0; i < len; ++i) {
            int match = this.expressionSpec.indexOf(ATTRIBUTE_TOKEN, ind);
            DbAttribute at = (DbAttribute)this.params.get(i);
            if (match > i) {
                buf.append(this.expressionSpec.substring(ind, match));
            }
            buf.append(at.getAliasedName(alias));
            ind = match + 2;
        }
        if (ind < this.expressionSpec.length()) {
            buf.append(this.expressionSpec.substring(ind));
        }
        return buf.toString();
    }

    public boolean isGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(boolean flag) {
        this.groupBy = flag;
    }

    public List getParams() {
        return Collections.unmodifiableList(this.params);
    }

    public String getExpressionSpec() {
        return this.expressionSpec;
    }

    public void addParam(DbAttribute param) {
        this.params.add(param);
    }

    public void removeParam(DbAttribute param) {
        this.params.remove(param);
    }

    public void clearParams() {
        this.params.clear();
    }

    public void setExpressionSpec(String expressionSpec) {
        this.expressionSpec = expressionSpec;
    }
}

