/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.ObjAttributeListener;
import org.apache.cayenne.map.event.ObjEntityListener;
import org.apache.cayenne.map.event.ObjRelationshipListener;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.util.CayenneMapEntry;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.commons.collections.Transformer;

public class ObjEntity
extends Entity
implements ObjEntityListener,
ObjAttributeListener,
ObjRelationshipListener {
    public static final int LOCK_TYPE_NONE = 0;
    public static final int LOCK_TYPE_OPTIMISTIC = 1;
    static final String CAYENNE_DATA_OBJECT_CLASS = "org.apache.cayenne.CayenneDataObject";
    protected static final Collection DEFAULT_GENERIC_CLASSES = Arrays.asList("org.apache.cayenne.CayenneDataObject");
    protected String superClassName;
    protected String className;
    protected String dbEntityName;
    protected String superEntityName;
    protected Expression qualifier;
    protected boolean readOnly;
    protected int lockType;
    protected boolean serverOnly;
    protected String clientClassName;
    protected String clientSuperClassName;

    public ObjEntity() {
        this(null);
    }

    public ObjEntity(String name) {
        this.setName(name);
        this.lockType = 0;
    }

    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<obj-entity name=\"");
        encoder.print(this.getName());
        if (this.getSuperEntityName() != null && this.getSuperEntity() != null) {
            encoder.print("\" superEntityName=\"");
            encoder.print(this.getSuperEntityName());
        }
        if (this.isServerOnly()) {
            encoder.print("\" serverOnly=\"true");
        }
        if (this.getClassName() != null) {
            encoder.print("\" className=\"");
            encoder.print(this.getClassName());
        }
        if (this.getClientClassName() != null) {
            encoder.print("\" clientClassName=\"");
            encoder.print(this.getClientClassName());
        }
        if (this.isReadOnly()) {
            encoder.print("\" readOnly=\"true");
        }
        if (this.getDeclaredLockType() == 1) {
            encoder.print("\" lock-type=\"optimistic");
        }
        if (this.getSuperEntityName() == null && this.getDbEntity() != null) {
            encoder.print("\" dbEntityName=\"");
            encoder.print(Util.encodeXmlAttribute(this.getDbEntityName()));
        }
        if (this.getSuperEntityName() == null && this.getSuperClassName() != null) {
            encoder.print("\" superClassName=\"");
            encoder.print(this.getSuperClassName());
        }
        if (this.getSuperEntityName() == null && this.getClientSuperClassName() != null) {
            encoder.print("\" clientSuperClassName=\"");
            encoder.print(this.getClientSuperClassName());
        }
        encoder.println("\">");
        encoder.indent(1);
        if (this.qualifier != null) {
            encoder.print("<qualifier>");
            this.qualifier.encodeAsXML(encoder);
            encoder.println("</qualifier>");
        }
        encoder.print(this.getDeclaredAttributes());
        encoder.indent(-1);
        encoder.println("</obj-entity>");
    }

    public ObjEntity getClientEntity() {
        ObjEntity entity = new ObjEntity(this.getName());
        entity.setClassName(this.getClientClassName());
        entity.setSuperClassName(this.getClientSuperClassName());
        entity.setSuperEntityName(this.getSuperEntityName());
        Iterator attributes = this.getDeclaredAttributes().iterator();
        while (attributes.hasNext()) {
            ObjAttribute attribute = (ObjAttribute)attributes.next();
            entity.addAttribute(attribute.getClientAttribute());
        }
        Iterator relationships = this.getDeclaredRelationships().iterator();
        while (relationships.hasNext()) {
            ObjRelationship relationship = (ObjRelationship)relationships.next();
            entity.addRelationship(relationship.getClientRelationship());
        }
        return entity;
    }

    public Class getJavaClass(ClassLoader classLoader) {
        return this.getJavaClass();
    }

    public Class getJavaClass() {
        String name = this.getClassName();
        if (name == null && this.getDataMap() != null) {
            name = this.getDataMap().getDefaultSuperclass();
        }
        if (name == null) {
            name = CAYENNE_DATA_OBJECT_CLASS;
        }
        try {
            return Util.getJavaClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new CayenneRuntimeException("Failed to load class " + name + ": " + e.getMessage(), e);
        }
    }

    public int getLockType() {
        if (this.lockType != 0) {
            return this.lockType;
        }
        ObjEntity superEntity = this.getSuperEntity();
        return superEntity != null ? superEntity.getLockType() : this.lockType;
    }

    public int getDeclaredLockType() {
        return this.lockType;
    }

    public void setDeclaredLockType(int i) {
        this.lockType = i;
    }

    public boolean isGeneric() {
        String className = this.getClassName();
        return className == null || DEFAULT_GENERIC_CLASSES.contains(className) || this.getDataMap() != null && className.equals(this.getDataMap().getDefaultSuperclass());
    }

    public boolean isClientAllowed() {
        return this.getDataMap() == null || this.isServerOnly() ? false : this.getDataMap().isClientSupported();
    }

    public boolean isServerOnly() {
        return this.serverOnly;
    }

    public void setServerOnly(boolean serverOnly) {
        this.serverOnly = serverOnly;
    }

    public Expression getDeclaredQualifier() {
        return this.qualifier;
    }

    public String getSuperEntityName() {
        return this.superEntityName;
    }

    public void setDeclaredQualifier(Expression qualifier) {
        this.qualifier = qualifier;
    }

    public void setSuperEntityName(String superEntityName) {
        this.superEntityName = superEntityName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClientClassName() {
        return this.clientClassName;
    }

    public void setClientClassName(String clientClassName) {
        this.clientClassName = clientClassName;
    }

    public String getSuperClassName() {
        ObjEntity superEntity = this.getSuperEntity();
        return superEntity != null ? superEntity.getClassName() : this.superClassName;
    }

    public void setSuperClassName(String superClassName) {
        this.superClassName = superClassName;
    }

    public String getClientSuperClassName() {
        ObjEntity superEntity = this.getSuperEntity();
        return superEntity != null ? superEntity.getClientClassName() : this.clientSuperClassName;
    }

    public void setClientSuperClassName(String clientSuperClassName) {
        this.clientSuperClassName = clientSuperClassName;
    }

    public ObjEntity getSuperEntity() {
        return this.superEntityName != null ? this.getNonNullNamespace().getObjEntity(this.superEntityName) : null;
    }

    public DbEntity getDbEntity() {
        if (this.dbEntityName != null) {
            return this.getNonNullNamespace().getDbEntity(this.dbEntityName);
        }
        ObjEntity superEntity = this.getSuperEntity();
        if (superEntity != null) {
            return superEntity.getDbEntity();
        }
        return null;
    }

    public void setDbEntity(DbEntity dbEntity) {
        this.dbEntityName = dbEntity != null ? dbEntity.getName() : null;
    }

    public Attribute getAttribute(String name) {
        Attribute attribute = super.getAttribute(name);
        if (attribute != null) {
            return attribute;
        }
        if (this.superEntityName == null) {
            return null;
        }
        ObjEntity superEntity = this.getSuperEntity();
        return superEntity != null ? superEntity.getAttribute(name) : null;
    }

    public SortedMap getAttributeMap() {
        if (this.superEntityName == null) {
            return super.getAttributeMap();
        }
        TreeMap attributeMap = new TreeMap();
        this.appendAttributes(attributeMap);
        return attributeMap;
    }

    final void appendAttributes(Map map) {
        map.putAll(super.getAttributeMap());
        ObjEntity superEntity = this.getSuperEntity();
        if (superEntity != null) {
            superEntity.appendAttributes(map);
        }
    }

    public Collection getAttributes() {
        if (this.superEntityName == null) {
            return super.getAttributes();
        }
        return this.getAttributeMap().values();
    }

    public Collection getDeclaredAttributes() {
        return super.getAttributes();
    }

    public Relationship getRelationship(String name) {
        Relationship relationship = super.getRelationship(name);
        if (relationship != null) {
            return relationship;
        }
        if (this.superEntityName == null) {
            return null;
        }
        ObjEntity superEntity = this.getSuperEntity();
        return superEntity != null ? superEntity.getRelationship(name) : null;
    }

    public SortedMap getRelationshipMap() {
        if (this.superEntityName == null) {
            return super.getRelationshipMap();
        }
        TreeMap relationshipMap = new TreeMap();
        this.appendRelationships(relationshipMap);
        return relationshipMap;
    }

    final void appendRelationships(Map map) {
        map.putAll(super.getRelationshipMap());
        ObjEntity superEntity = this.getSuperEntity();
        if (superEntity != null) {
            superEntity.appendRelationships(map);
        }
    }

    public Collection getRelationships() {
        if (this.superEntityName == null) {
            return super.getRelationships();
        }
        return this.getRelationshipMap().values();
    }

    public Collection getDeclaredRelationships() {
        return super.getRelationships();
    }

    public ObjAttribute getAttributeForDbAttribute(DbAttribute dbAttribute) {
        Iterator it = this.getAttributeMap().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            ObjAttribute objAttr = (ObjAttribute)entry.getValue();
            if (objAttr.getDbAttribute() != dbAttribute) continue;
            return objAttr;
        }
        return null;
    }

    public ObjRelationship getRelationshipForDbRelationship(DbRelationship dbRelationship) {
        Iterator it = this.getRelationshipMap().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            ObjRelationship objRel = (ObjRelationship)entry.getValue();
            List relList = objRel.getDbRelationships();
            if (relList.size() != 1 || relList.get(0) != dbRelationship) continue;
            return objRel;
        }
        return null;
    }

    public void clearDbMapping() {
        if (this.dbEntityName == null) {
            return;
        }
        Iterator it = this.getAttributeMap().values().iterator();
        while (it.hasNext()) {
            ObjAttribute objAttr = (ObjAttribute)it.next();
            DbAttribute dbAttr = objAttr.getDbAttribute();
            if (null == dbAttr) continue;
            objAttr.setDbAttribute(null);
        }
        Iterator rels = this.getRelationships().iterator();
        while (rels.hasNext()) {
            ((ObjRelationship)rels.next()).clearDbRelationships();
        }
        this.dbEntityName = null;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isSubentityOf(ObjEntity entity) {
        if (entity == null) {
            return false;
        }
        if (entity == this) {
            return false;
        }
        ObjEntity superEntity = this.getSuperEntity();
        if (superEntity == entity) {
            return true;
        }
        return superEntity != null ? superEntity.isSubentityOf(entity) : false;
    }

    public Iterator resolvePathComponents(Expression pathExp) throws ExpressionException {
        if (pathExp.getType() == 27) {
            if (this.getDbEntity() == null) {
                throw new ExpressionException("Can't resolve DB_PATH '" + pathExp + "', DbEntity is not set.");
            }
            return this.getDbEntity().resolvePathComponents(pathExp);
        }
        if (pathExp.getType() == 26) {
            return new Entity.PathIterator((String)pathExp.getOperand(0));
        }
        throw new ExpressionException("Invalid expression type: '" + pathExp.expName() + "',  OBJ_PATH is expected.");
    }

    public Expression translateToDbPath(Expression expression) {
        if (expression == null) {
            return null;
        }
        if (this.getDbEntity() == null) {
            throw new CayenneRuntimeException("Can't translate expression to DB_PATH, no DbEntity for '" + this.getName() + "'.");
        }
        return expression.transform(new DBPathConverter());
    }

    public Expression translateToRelatedEntity(Expression expression, String relationshipPath) {
        if (expression == null) {
            return null;
        }
        if (relationshipPath == null) {
            return expression;
        }
        if (this.getDbEntity() == null) {
            throw new CayenneRuntimeException("Can't transform expression, no DbEntity for '" + this.getName() + "'.");
        }
        DBPathConverter transformer = new DBPathConverter();
        String dbPath = transformer.toDbPath(this.resolvePathComponents(relationshipPath));
        Expression dbClone = expression.transform(transformer);
        return this.getDbEntity().translateToRelatedEntity(dbClone, dbPath);
    }

    public String getDbEntityName() {
        return this.dbEntityName;
    }

    public void setDbEntityName(String string) {
        this.dbEntityName = string;
    }

    public void objEntityChanged(EntityEvent e) {
        if (e == null || e.getEntity() != this) {
            return;
        }
        if (e.getId() == 1 && e.isNameChange()) {
            String oldName = e.getOldName();
            String newName = e.getNewName();
            DataMap map = this.getDataMap();
            if (map != null) {
                ObjEntity oe = (ObjEntity)e.getEntity();
                Iterator rit = oe.getRelationships().iterator();
                while (rit.hasNext()) {
                    ObjRelationship or = (ObjRelationship)rit.next();
                    if (null == (or = or.getReverseRelationship()) || !or.targetEntityName.equals(oldName)) continue;
                    or.targetEntityName = newName;
                }
            }
        }
    }

    public void objEntityAdded(EntityEvent e) {
    }

    public void objEntityRemoved(EntityEvent e) {
    }

    public void objAttributeChanged(AttributeEvent e) {
    }

    public void objAttributeAdded(AttributeEvent e) {
    }

    public void objAttributeRemoved(AttributeEvent e) {
    }

    public void objRelationshipChanged(RelationshipEvent e) {
    }

    public void objRelationshipAdded(RelationshipEvent e) {
    }

    public void objRelationshipRemoved(RelationshipEvent e) {
    }

    final class DBPathConverter
    implements Transformer {
        DBPathConverter() {
        }

        String toDbPath(Iterator objectPathComponents) {
            StringBuffer buf = new StringBuffer();
            while (objectPathComponents.hasNext()) {
                Iterator dbSubpath;
                Object component = objectPathComponents.next();
                if (component instanceof ObjRelationship) {
                    dbSubpath = ((ObjRelationship)component).getDbRelationships().iterator();
                } else if (component instanceof ObjAttribute) {
                    dbSubpath = ((ObjAttribute)component).getDbPathIterator();
                } else {
                    throw new CayenneRuntimeException("Unknown path component: " + component);
                }
                while (dbSubpath.hasNext()) {
                    CayenneMapEntry subComponent = (CayenneMapEntry)dbSubpath.next();
                    if (buf.length() > 0) {
                        buf.append(".");
                    }
                    buf.append(subComponent.getName());
                }
            }
            return buf.toString();
        }

        public Object transform(Object input) {
            if (!(input instanceof Expression)) {
                return input;
            }
            Expression expression = (Expression)input;
            if (expression.getType() != 26) {
                return input;
            }
            String converted = this.toDbPath(ObjEntity.this.resolvePathComponents(expression));
            Expression exp = ExpressionFactory.expressionOfType(27);
            exp.setOperand(0, converted);
            return exp;
        }
    }
}

