/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validator;

import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.project.ProjectPath;
import org.apache.cayenne.project.validator.TreeNodeValidator;
import org.apache.cayenne.project.validator.Validator;
import org.apache.cayenne.util.Util;

public class ProcedureParameterValidator
extends TreeNodeValidator {
    public void validateObject(ProjectPath treeNodePath, Validator validator) {
        ProcedureParameter parameter = (ProcedureParameter)treeNodePath.getObject();
        if (Util.isEmptyString(parameter.getName())) {
            validator.registerError("Unnamed ProcedureParameter.", treeNodePath);
        }
        if (parameter.getType() == Integer.MAX_VALUE) {
            validator.registerWarning("ProcedureParameter has no type.", treeNodePath);
        }
        if (parameter.getMaxLength() < 0 && (parameter.getType() == 12 || parameter.getType() == 1)) {
            validator.registerWarning("Character procedure parameter doesn't have max length.", treeNodePath);
        }
        if (parameter.getDirection() <= 0) {
            validator.registerWarning("ProcedureParameter has no direction.", treeNodePath);
        }
    }
}

