/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.property;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.property.ConverterFactory;
import org.apache.cayenne.util.Util;

public class PropertyUtils {
    public static Object getProperty(Object object, String nestedPropertyName) throws CayenneRuntimeException {
        if (object == null) {
            throw new IllegalArgumentException("Null object.");
        }
        if (Util.isEmptyString(nestedPropertyName)) {
            throw new IllegalArgumentException("Null or empty property name.");
        }
        StringTokenizer path = new StringTokenizer(nestedPropertyName, ".");
        int len = path.countTokens();
        Object value = object;
        String pathSegment = null;
        try {
            for (int i = 1; i <= len; ++i) {
                pathSegment = path.nextToken();
                if (value == null) {
                    throw new CayenneRuntimeException("Null value in the middle of the path");
                }
                value = PropertyUtils.getSimpleProperty(value, pathSegment);
            }
            return value;
        }
        catch (Exception e) {
            String objectType = value != null ? value.getClass().getName() : "<null>";
            throw new CayenneRuntimeException("Error reading property segment '" + pathSegment + "' in path '" + nestedPropertyName + "' for type " + objectType, e);
        }
    }

    public static void setProperty(Object object, String nestedPropertyName, Object value) throws CayenneRuntimeException {
        String lastSegment;
        if (object == null) {
            throw new IllegalArgumentException("Null object.");
        }
        if (Util.isEmptyString(nestedPropertyName)) {
            throw new IllegalArgumentException("Null or invalid property name.");
        }
        int dot = nestedPropertyName.lastIndexOf(".");
        if (dot > 0) {
            lastSegment = nestedPropertyName.substring(dot + 1);
            String pathSegment = nestedPropertyName.substring(0, dot);
            if ((object = PropertyUtils.getProperty(object, pathSegment)) == null) {
                throw new IllegalArgumentException("Null object at the end of the segment '" + pathSegment + "'");
            }
        } else {
            lastSegment = nestedPropertyName;
        }
        try {
            PropertyUtils.setSimpleProperty(object, lastSegment, value);
        }
        catch (Exception e) {
            throw new CayenneRuntimeException("Error setting property segment '" + lastSegment + "' in path '" + nestedPropertyName + "'", e);
        }
    }

    static Object getSimpleProperty(Object object, String pathSegment) throws IntrospectionException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor(object.getClass(), pathSegment);
        if (descriptor != null) {
            Method reader = descriptor.getReadMethod();
            if (reader == null) {
                throw new IntrospectionException("Unreadable property '" + pathSegment + "'");
            }
            return reader.invoke(object, null);
        }
        if (object instanceof Map) {
            return ((Map)object).get(pathSegment);
        }
        throw new IntrospectionException("No property '" + pathSegment + "' found in class " + object.getClass().getName());
    }

    static void setSimpleProperty(Object object, String pathSegment, Object value) throws IntrospectionException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor(object.getClass(), pathSegment);
        if (descriptor != null) {
            Method writer = descriptor.getWriteMethod();
            if (writer == null) {
                throw new IntrospectionException("Unwritable property '" + pathSegment + "'");
            }
            value = ConverterFactory.factory.getConverter(descriptor.getPropertyType()).convert(value, descriptor.getPropertyType());
            writer.invoke(object, value);
        } else if (object instanceof Map) {
            ((Map)object).put(pathSegment, value);
        } else {
            throw new IntrospectionException("No property '" + pathSegment + "' found in class " + object.getClass().getName());
        }
    }

    static PropertyDescriptor getPropertyDescriptor(Class beanClass, String propertyName) throws IntrospectionException {
        BeanInfo info = Introspector.getBeanInfo(beanClass);
        PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
        for (int i = 0; i < descriptors.length; ++i) {
            if (!propertyName.equals(descriptors[i].getName())) continue;
            return descriptors[i];
        }
        return null;
    }

    static Class normalizeType(Class type) {
        if (type.isPrimitive()) {
            String className = type.getName();
            if ("byte".equals(className)) {
                return Byte.class;
            }
            if ("int".equals(className)) {
                return Integer.class;
            }
            if ("short".equals(className)) {
                return Short.class;
            }
            if ("char".equals(className)) {
                return Character.class;
            }
            if ("double".equals(className)) {
                return Double.class;
            }
            if ("float".equals(className)) {
                return Float.class;
            }
            if ("boolean".equals(className)) {
                return Boolean.class;
            }
        }
        return type;
    }

    static Object defaultNullValueForType(Class type) {
        if (type.isPrimitive()) {
            String className = type.getName();
            if ("byte".equals(className)) {
                return new Byte(0);
            }
            if ("int".equals(className)) {
                return new Integer(0);
            }
            if ("short".equals(className)) {
                return new Short(0);
            }
            if ("char".equals(className)) {
                return new Character('\u0000');
            }
            if ("double".equals(className)) {
                return new Double(0.0);
            }
            if ("float".equals(className)) {
                return new Float(0.0f);
            }
            if ("boolean".equals(className)) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    private PropertyUtils() {
    }
}

