/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.QueryMetadata;

class QueryMetadataWrapper
implements QueryMetadata {
    static final String CACHE_KEY_PROPERTY = "QueryMetadataWrapper.CacheKey";
    QueryMetadata info;
    Map overrides;

    public QueryMetadataWrapper(QueryMetadata info) {
        this.info = info;
    }

    void override(String key, Object value) {
        if (this.overrides == null) {
            this.overrides = new HashMap();
        }
        this.overrides.put(key, value);
    }

    boolean overrideExists(String key) {
        return this.overrides != null && this.overrides.containsKey(key);
    }

    public DataMap getDataMap() {
        return this.info.getDataMap();
    }

    public Procedure getProcedure() {
        return this.info.getProcedure();
    }

    public DbEntity getDbEntity() {
        return this.info.getDbEntity();
    }

    public ObjEntity getObjEntity() {
        return this.info.getObjEntity();
    }

    public String getCacheKey() {
        return this.overrideExists(CACHE_KEY_PROPERTY) ? (String)this.overrides.get(CACHE_KEY_PROPERTY) : this.info.getCacheKey();
    }

    public String getCachePolicy() {
        return this.overrideExists("cayenne.GenericSelectQuery.cachePolicy") ? (String)this.overrides.get("cayenne.GenericSelectQuery.cachePolicy") : this.info.getCachePolicy();
    }

    public boolean isFetchingDataRows() {
        if (!this.overrideExists("cayenne.GenericSelectQuery.fetchingDataRows")) {
            return this.info.isFetchingDataRows();
        }
        Boolean b = (Boolean)this.overrides.get("cayenne.GenericSelectQuery.fetchingDataRows");
        return b != null && b != false;
    }

    public boolean isRefreshingObjects() {
        if (!this.overrideExists("cayenne.GenericSelectQuery.refreshingObjects")) {
            return this.info.isRefreshingObjects();
        }
        Boolean b = (Boolean)this.overrides.get("cayenne.GenericSelectQuery.refreshingObjects");
        return b != null && b != false;
    }

    public boolean isResolvingInherited() {
        if (!this.overrideExists("cayenne.GenericSelectQuery.resolvingInherited")) {
            return this.info.isResolvingInherited();
        }
        Boolean b = (Boolean)this.overrides.get("cayenne.GenericSelectQuery.resolvingInherited");
        return b != null && b != false;
    }

    public int getPageSize() {
        if (!this.overrideExists("cayenne.GenericSelectQuery.pageSize")) {
            return this.info.getPageSize();
        }
        Number n = (Number)this.overrides.get("cayenne.GenericSelectQuery.pageSize");
        return n != null ? n.intValue() : 0;
    }

    public int getFetchStartIndex() {
        return this.info.getFetchStartIndex();
    }

    public int getFetchLimit() {
        if (!this.overrideExists("cayenne.GenericSelectQuery.fetchLimit")) {
            return this.info.getFetchLimit();
        }
        Number n = (Number)this.overrides.get("cayenne.GenericSelectQuery.fetchLimit");
        return n != null ? n.intValue() : 0;
    }

    public PrefetchTreeNode getPrefetchTree() {
        return this.info.getPrefetchTree();
    }
}

