/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.remote;

import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.QueryRouter;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SQLActionVisitor;

class RangeQuery
implements Query {
    private String cacheKey;
    private int fetchStartIndex;
    private int fetchLimit;
    private boolean fetchingDataRows;
    private PrefetchTreeNode prefetchTree;

    private RangeQuery() {
    }

    public RangeQuery(String cacheKey, int fetchStartIndex, int fetchLimit, QueryMetadata rootMetadata) {
        this.cacheKey = cacheKey;
        this.fetchStartIndex = fetchStartIndex;
        this.fetchLimit = fetchLimit;
        this.fetchingDataRows = rootMetadata.isFetchingDataRows();
        this.prefetchTree = rootMetadata.getPrefetchTree();
    }

    public QueryMetadata getMetaData(EntityResolver resolver) {
        return new QueryMetadata(){

            public String getCacheKey() {
                return RangeQuery.this.cacheKey;
            }

            public int getFetchStartIndex() {
                return RangeQuery.this.fetchStartIndex;
            }

            public int getFetchLimit() {
                return RangeQuery.this.fetchLimit;
            }

            public boolean isFetchingDataRows() {
                return RangeQuery.this.fetchingDataRows;
            }

            public int getPageSize() {
                return 0;
            }

            public String getCachePolicy() {
                return "nocache";
            }

            public PrefetchTreeNode getPrefetchTree() {
                return RangeQuery.this.prefetchTree;
            }

            public DataMap getDataMap() {
                throw new UnsupportedOperationException();
            }

            public DbEntity getDbEntity() {
                throw new UnsupportedOperationException();
            }

            public ObjEntity getObjEntity() {
                throw new UnsupportedOperationException();
            }

            public Procedure getProcedure() {
                throw new UnsupportedOperationException();
            }

            public boolean isRefreshingObjects() {
                throw new UnsupportedOperationException();
            }

            public boolean isResolvingInherited() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public SQLAction createSQLAction(SQLActionVisitor visitor) {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        throw new UnsupportedOperationException();
    }

    public void route(QueryRouter router, EntityResolver resolver, Query substitutedQuery) {
        throw new UnsupportedOperationException();
    }

    public Object getRoot() {
        throw new UnsupportedOperationException();
    }

    public void setName(String name) {
        throw new UnsupportedOperationException();
    }

    public void setRoot(Object root) {
        throw new UnsupportedOperationException();
    }
}

