/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.DataPort;
import org.apache.cayenne.conf.Configuration;
import org.apache.cayenne.conf.FileConfiguration;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.tools.AntDataPortDelegate;
import org.apache.cayenne.tools.CayenneTask;
import org.apache.cayenne.util.Util;
import org.apache.tools.ant.BuildException;

public class DataPortTask
extends CayenneTask {
    protected File projectFile;
    protected String maps;
    protected String srcNode;
    protected String destNode;
    protected String includeTables;
    protected String excludeTables;
    protected boolean cleanDest = true;

    public void execute() throws BuildException {
        this.configureLogging();
        this.validateParameters();
        FileConfiguration configuration = new FileConfiguration(this.projectFile);
        try {
            configuration.initialize();
        }
        catch (Exception ex) {
            throw new BuildException("Error loading Cayenne configuration from " + this.projectFile, (Throwable)ex);
        }
        DataNode source = this.findNode(configuration, this.srcNode);
        if (source == null) {
            throw new BuildException("srcNode not found in the project: " + this.srcNode);
        }
        DataNode destination = this.findNode(configuration, this.destNode);
        if (destination == null) {
            throw new BuildException("destNode not found in the project: " + this.destNode);
        }
        this.log("Porting from '" + this.srcNode + "' to '" + this.destNode + "'.");
        AntDataPortDelegate portDelegate = new AntDataPortDelegate(this, this.maps, this.includeTables, this.excludeTables);
        DataPort dataPort = new DataPort(portDelegate);
        dataPort.setEntities(this.getAllEntities(source, destination));
        dataPort.setCleaningDestination(this.cleanDest);
        dataPort.setSourceNode(source);
        dataPort.setDestinationNode(destination);
        try {
            dataPort.execute();
        }
        catch (Exception e) {
            Throwable topOfStack = Util.unwindException(e);
            throw new BuildException("Error porting data: " + topOfStack.getMessage(), topOfStack);
        }
    }

    protected DataNode findNode(Configuration configuration, String name) {
        Iterator domains = configuration.getDomains().iterator();
        while (domains.hasNext()) {
            DataDomain domain = (DataDomain)domains.next();
            DataNode node = domain.getNode(name);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    protected Collection getAllEntities(DataNode source, DataNode target) {
        DataMap map;
        HashSet allEntities = new HashSet();
        Iterator maps = source.getDataMaps().iterator();
        while (maps.hasNext()) {
            map = (DataMap)maps.next();
            allEntities.addAll(map.getDbEntities());
        }
        maps = target.getDataMaps().iterator();
        while (maps.hasNext()) {
            map = (DataMap)maps.next();
            allEntities.addAll(map.getDbEntities());
        }
        this.log("Number of entities: " + allEntities.size(), 3);
        if (allEntities.size() == 0) {
            this.log("No entities found for either source or target.");
        }
        return allEntities;
    }

    protected void validateParameters() throws BuildException {
        if (this.projectFile == null) {
            throw new BuildException("Required 'projectFile' parameter is missing.");
        }
        if (!this.projectFile.exists()) {
            throw new BuildException("'projectFile' does not exist: " + this.projectFile);
        }
        if (this.srcNode == null) {
            throw new BuildException("Required 'srcNode' parameter is missing.");
        }
        if (this.destNode == null) {
            throw new BuildException("Required 'destNode' parameter is missing.");
        }
    }

    public void setDestNode(String destNode) {
        this.destNode = destNode;
    }

    public void setExcludeTables(String excludeTables) {
        this.excludeTables = excludeTables;
    }

    public void setIncludeTables(String includeTables) {
        this.includeTables = includeTables;
    }

    public void setMaps(String maps) {
        this.maps = maps;
    }

    public void setProjectFile(File projectFile) {
        this.projectFile = projectFile;
    }

    public void setSrcNode(String srcNode) {
        this.srcNode = srcNode;
    }

    public void setCleanDest(boolean flag) {
        this.cleanDest = flag;
    }
}

