/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph.convert;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.objectstyle.ashwood.graph.ArcIterator;
import org.objectstyle.ashwood.graph.Digraph;
import org.objectstyle.ashwood.graph.access.DataAccessor;

public class PropertiesConverter {
    private Properties graphData = new Properties();
    private DataAccessor vertexAccessor = new DataAccessor();

    public Properties getGraphData() {
        return (Properties)this.graphData.clone();
    }

    public void reset() {
        this.graphData.clear();
    }

    public void build(Digraph digraph) {
        Iterator<Map.Entry<Object, Object>> iterator = this.graphData.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            Object object = this.vertexAccessor.create(entry.getKey());
            digraph.addVertex(object);
            StringTokenizer stringTokenizer = new StringTokenizer((String)entry.getValue(), ";");
            while (stringTokenizer.hasMoreTokens()) {
                digraph.putArc(object, this.vertexAccessor.create(stringTokenizer.nextToken()), Boolean.TRUE);
            }
        }
    }

    public void convert(Digraph digraph) {
        Iterator iterator = digraph.vertexIterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            String string = this.vertexAccessor.getId(e).toString();
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            ArcIterator arcIterator = digraph.outgoingIterator(e);
            while (arcIterator.hasNext()) {
                arcIterator.next();
                if (bl) {
                    stringBuffer.append(this.vertexAccessor.getId(arcIterator.getDestination()));
                    bl = false;
                    continue;
                }
                stringBuffer.append(';').append(arcIterator.getDestination());
            }
            this.graphData.setProperty(string, stringBuffer.toString());
        }
    }

    public void setVertexAccessor(DataAccessor dataAccessor) {
        this.vertexAccessor = dataAccessor;
    }

    public DataAccessor getVertexAccessor() {
        return this.vertexAccessor;
    }
}

