/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph.layout;

import java.util.Map;
import java.util.Set;
import org.objectstyle.ashwood.graph.layout.DefaultLayerPartition;
import org.objectstyle.ashwood.graph.layout.DigraphLayout;
import org.objectstyle.ashwood.graph.layout.RankFunction;
import org.objectstyle.ashwood.graph.layout.TopologicalRankFunction;
import org.objectstyle.ashwood.util.IndexComparator;

public class HierarchyLayout
extends DigraphLayout {
    private RankFunction rankFunction;
    private DefaultLayerPartition layerPartition;
    private int sortIterationCount = 20;
    private IndexComparator layerSortComparator = new IndexComparator();
    private Set[] subgraphPartition;

    public void doLayout() {
        this.rankVertices();
        this.sortVertices();
        this.positionVertices();
        this.positionArcs();
    }

    protected void rankVertices() {
        this.rankFunction = new TopologicalRankFunction(this.digraph);
    }

    protected void sortVertices() {
        this.layerPartition = new DefaultLayerPartition(this.digraph, this.rankFunction, this.vertexShape, this.subgraphPartition);
        this.layerPartition.breadthFirstSort();
        int n = this.layerPartition.countCrossings();
        Map map = this.layerPartition.makeOrderSnapshot();
        boolean bl = true;
        int n2 = 0;
        while (n2 < this.sortIterationCount) {
            if (n2 % 2 == 0) {
                this.layerPartition.sortDownByMedian();
            } else {
                this.layerPartition.sortUpByMedian();
            }
            int n3 = this.layerPartition.countCrossings();
            if (n3 < n) {
                n = n3;
                map = this.layerPartition.makeOrderSnapshot();
                bl = true;
            } else if (n3 > n) {
                bl = false;
            }
            ++n2;
        }
        if (!bl) {
            this.layerPartition.restoreOrder(map);
        }
        this.layerPartition.refreshIndices();
    }

    protected void positionVertices() {
        this.layerPartition.setAlternatePendulumTraversals(false);
        this.layerPartition.setHorizontalSpacing(this.horizontalSpacing);
        this.layerPartition.setVerticalSpacing(this.verticalSpacing);
        this.layerPartition.setVerticalAlignment(this.verticalAligment);
        this.layerPartition.setRubberForceThreshold(1.0);
        this.layerPartition.createSubgraphPartition();
        this.layerPartition.positionDummies();
        this.layerPartition.setDummyFixed(true);
        this.layerPartition.balancePendulum(100);
        this.layerPartition.balanceRubberBends(100);
        this.layerPartition.positionLayers();
        this.layerPartition.updateGeometry(this.vertexShape, this.areaBounds);
    }

    protected void positionArcs() {
        this.arcGeometry = this.layerPartition.positionArcs();
    }

    public void setSubgraphPartition(Set[] setArray) {
        this.subgraphPartition = setArray;
    }

    public Set[] getSubgraphPartition() {
        return this.subgraphPartition;
    }
}

