/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph.layout;

import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.collections.Predicate;
import org.objectstyle.ashwood.function.DoubleFunction;
import org.objectstyle.ashwood.graph.layout.NestedSubgraph;
import org.objectstyle.ashwood.graph.layout.NestingTreeNode;
import org.objectstyle.ashwood.util.Attribute;
import org.objectstyle.ashwood.util.MedianUtils;

public class LayerVertex
implements Comparable,
NestingTreeNode {
    public static final Comparator LAYER_INDEX_COMPARATOR = new LayerIndexComparator();
    public static final DoubleFunction POSITION_IN_LAYER = new PositionInLayer();
    private int rank;
    private int indexInLayer;
    private double weight;
    private double centerX;
    private double centerY;
    private double width;
    private double height;
    private ArrayList predecessors;
    private ArrayList successors;
    private Object userVertex;
    private NestedSubgraph parentSubgraph;
    private double leftX = Double.NaN;
    private double rightX = Double.NaN;
    private int classIndex = -1;

    public LayerVertex(Object object, int n, int n2) {
        this.userVertex = object;
        this.predecessors = new ArrayList(Math.max(n, 1));
        this.successors = new ArrayList(Math.max(n2, 1));
    }

    public int[] getSuccessorIndices() {
        int n = this.successors.size();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = ((LayerVertex)this.successors.get((int)n2)).indexInLayer;
            ++n2;
        }
        Arrays.sort(nArray);
        return nArray;
    }

    public int compareTo(Object object) {
        return Double.compare(this.weight, ((LayerVertex)object).weight);
    }

    public double rubberForce() {
        int n;
        double d = 0.0;
        int n2 = this.predecessors.size();
        if (n2 + (n = this.successors.size()) == 0) {
            return 0.0;
        }
        d = this.deflection() / (double)(n2 + n);
        return d;
    }

    public double predecessorPendulumForce() {
        return this.pendulumForce(this.predecessors);
    }

    public double successorPendulumForce() {
        return this.pendulumForce(this.successors);
    }

    public double predecessorDeflection() {
        return this.deflection(this.predecessors);
    }

    public double successorDeflection() {
        return this.deflection(this.successors);
    }

    public double deflection() {
        return this.deflection(this.predecessors) + this.deflection(this.successors);
    }

    public double successorMedianValue() {
        return this.medianValue(this.successors);
    }

    public double predecessorMedianValue() {
        return this.medianValue(this.predecessors);
    }

    public double distanceToLeft(LayerVertex layerVertex) {
        if (layerVertex == null) {
            return Double.POSITIVE_INFINITY;
        }
        return this.getMinX() - layerVertex.getMaxX();
    }

    public boolean isTouchingToLeft(LayerVertex layerVertex, double d) {
        return this.distanceToLeft(layerVertex) <= d;
    }

    public double minCenterDistance(LayerVertex layerVertex, double d) {
        return (this.width + layerVertex.width) / 2.0 + d;
    }

    public double getMaxX() {
        return this.centerX + this.width / 2.0;
    }

    public double getMinX() {
        return this.centerX - this.width / 2.0;
    }

    public double getMaxY() {
        return this.centerY + this.height / 2.0;
    }

    public double getMinY() {
        return this.centerY - this.height / 2.0;
    }

    public double moveX(double d) {
        return this.centerX += d;
    }

    public double getCenterX() {
        return this.centerX;
    }

    public void setCenterX(double d) {
        this.centerX = d;
    }

    public double getCenterY() {
        return this.centerY;
    }

    public void setCenterY(double d) {
        this.centerY = d;
    }

    public int getIndexInLayer() {
        return this.indexInLayer;
    }

    public void setIndexInLayer(int n) {
        this.indexInLayer = n;
    }

    public ArrayList getPredecessors() {
        return this.predecessors;
    }

    public int getRank() {
        return this.rank;
    }

    public ArrayList getSuccessors() {
        return this.successors;
    }

    public Object getUserVertex() {
        return this.userVertex;
    }

    public double getWeight() {
        return this.weight;
    }

    public double getWidth() {
        return this.width;
    }

    public void setUserVertex(Object object) {
        this.userVertex = object;
    }

    public void setWeight(double d) {
        this.weight = d;
    }

    public void setWidth(double d) {
        this.width = d;
    }

    public void setRank(int n) {
        this.rank = n;
    }

    public void setSuccessors(ArrayList arrayList) {
        this.successors = arrayList;
    }

    public void setPredecessors(ArrayList arrayList) {
        this.predecessors = arrayList;
    }

    private double pendulumForce(ArrayList arrayList) {
        double d = 0.0;
        int n = arrayList.size();
        if (n == 0) {
            return 0.0;
        }
        d = this.deflection(arrayList) / (double)n;
        return d;
    }

    private double deflection(ArrayList arrayList) {
        double d = 0.0;
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            LayerVertex layerVertex = (LayerVertex)arrayList.get(n2);
            d += layerVertex.centerX - this.centerX;
            ++n2;
        }
        return d;
    }

    private double medianValue(ArrayList arrayList) {
        if (arrayList.size() > 1) {
            Collections.sort(arrayList, LAYER_INDEX_COMPARATOR);
        }
        this.weight = MedianUtils.weightedMedianValue(arrayList, POSITION_IN_LAYER);
        return this.weight;
    }

    public int inDegree() {
        return this.predecessors.size();
    }

    public int outDegree() {
        return this.successors.size();
    }

    public int degree() {
        return this.predecessors.size() + this.successors.size();
    }

    public LayerVertex getPredecessor(int n) {
        return n < this.inDegree() ? (LayerVertex)this.predecessors.get(n) : null;
    }

    public LayerVertex getSuccessor(int n) {
        return n < this.outDegree() ? (LayerVertex)this.successors.get(n) : null;
    }

    public int countLeftCrossings(int[] nArray) {
        int n = this.successors.size();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            LayerVertex layerVertex = (LayerVertex)this.successors.get(n3);
            int n4 = layerVertex.getIndexInLayer();
            int n5 = nArray.length - 1;
            while (n5 >= 0) {
                if (nArray[n5] <= n4) break;
                ++n2;
                --n5;
            }
            ++n3;
        }
        return n2;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double d) {
        this.height = d;
    }

    public void setGeometry(Attribute attribute) {
        RectangularShape rectangularShape = (RectangularShape)attribute.get(this.userVertex);
        if (rectangularShape != null) {
            this.width = rectangularShape.getWidth();
            this.height = rectangularShape.getHeight();
            this.centerX = rectangularShape.getCenterX();
            this.centerY = rectangularShape.getCenterY();
        } else {
            this.centerY = 0.0;
            this.centerX = 0.0;
            this.height = 0.0;
            this.width = 0.0;
        }
    }

    public void updateGeometry(Attribute attribute) {
        RectangularShape rectangularShape = (RectangularShape)attribute.get(this.userVertex);
        if (rectangularShape != null) {
            rectangularShape.setFrame(this.centerX - this.width / 2.0, this.centerY - this.height / 2.0, this.width, this.height);
        }
    }

    public boolean isDummy() {
        return this.userVertex == null;
    }

    public void setParentSubgraph(NestedSubgraph nestedSubgraph) {
        this.parentSubgraph = nestedSubgraph;
    }

    public NestedSubgraph getParentSubgraph() {
        return this.parentSubgraph;
    }

    public void setLeftX(double d) {
        this.leftX = d;
    }

    public double getLeftX() {
        return this.leftX;
    }

    public void setRightX(double d) {
        this.rightX = d;
    }

    public double getRightX() {
        return this.rightX;
    }

    public void setClassIndex(int n) {
        this.classIndex = n;
    }

    public int getClassIndex() {
        return this.classIndex;
    }

    public double getPosition() {
        return this.indexInLayer;
    }

    public int countVertices(int n) {
        return n != this.rank ? 0 : 1;
    }

    public int getVertexCount(int n) {
        return n != this.rank ? 0 : 1;
    }

    public double computePosition(int n) {
        return n != this.rank ? Double.NaN : (double)this.indexInLayer;
    }

    public int countVertices() {
        return 1;
    }

    public double getPosition(int n) {
        return this.computePosition(n);
    }

    public int getVertexCount() {
        return 1;
    }

    public double computePosition() {
        return this.indexInLayer;
    }

    public int reindex(int n, int n2, Comparator comparator, Predicate predicate) {
        this.indexInLayer = n2++;
        return n2;
    }

    public boolean isDefinedLeftX() {
        return !Double.isNaN(this.leftX);
    }

    public boolean isDefinedRightX() {
        return !Double.isNaN(this.rightX);
    }

    public String toString() {
        return this.userVertex != null ? this.userVertex.toString() : "*";
    }

    public boolean includesRank(int n) {
        return this.rank == n;
    }

    public static class PositionInLayer
    implements DoubleFunction {
        public double doubleValue(Object object) {
            return ((LayerVertex)object).indexInLayer;
        }
    }

    public static class LayerIndexComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            return ((LayerVertex)object).indexInLayer - ((LayerVertex)object2).indexInLayer;
        }
    }
}

