/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.account;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.account.EipMUserPosition;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AccountChangeTurnFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AccountChangeTurnFormData.class.getName());
    private ALStringField positions;
    private String[] userNames = null;
    private List<ALEipUser> userList = null;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.userList = new ArrayList<ALEipUser>();
    }

    public void initField() {
        this.positions = new ALStringField();
        this.positions.setFieldName(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_USERNAME_LIST", (Object[])new Object[0]));
        this.positions.setTrim(true);
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = true;
        try {
            res = super.setFormData(rundata, context, msgList);
            if (res) {
                if (this.positions.getValue() == null || this.positions.getValue().equals("")) {
                    SelectQuery query = Database.query(TurbineUser.class);
                    ObjectId oid = new ObjectId("TurbineUser", "USER_ID", 3);
                    Expression exp1 = ExpressionFactory.matchAllDbExp((Map)oid.getIdSnapshot(), (int)6);
                    Expression exp2 = ExpressionFactory.matchExp((String)"companyId", (Object)1);
                    Expression exp3 = ExpressionFactory.noMatchExp((String)"disabled", (Object)"T");
                    query.setQualifier(exp1);
                    query.andQualifier(exp2);
                    query.andQualifier(exp3);
                    this.userList = ALEipUtils.getUsersFromSelectQuery((SelectQuery)query);
                } else {
                    StringTokenizer st = new StringTokenizer(this.positions.getValue(), ",");
                    this.userNames = new String[st.countTokens()];
                    int count = 0;
                    while (st.hasMoreTokens()) {
                        this.userNames[count] = st.nextToken();
                        ++count;
                    }
                    SelectQuery query = Database.query(TurbineUser.class);
                    Expression exp1 = ExpressionFactory.inExp((String)"loginName", (Object[])this.userNames);
                    Expression exp2 = ExpressionFactory.noMatchExp((String)"disabled", (Object)"T");
                    query.setQualifier(exp1);
                    query.andQualifier(exp2);
                    List list = query.fetchList();
                    TurbineUser turbineUser = null;
                    int length = this.userNames.length;
                    for (int i = 0; i < length; ++i) {
                        turbineUser = this.getEipUserRecord(list, this.userNames[i]);
                        ALEipUser user = new ALEipUser();
                        user.initField();
                        user.setName(turbineUser.getLoginName());
                        user.setAliasName(turbineUser.getFirstName(), turbineUser.getLastName());
                        this.userList.add(user);
                    }
                }
            }
        }
        catch (RuntimeException ex) {
            logger.error((Object)"AccountChangeTurnFormData.setFormData", (Throwable)ex);
            return false;
        }
        catch (Exception ex) {
            logger.error((Object)"AccountChangeTurnFormData.setFormData", (Throwable)ex);
            return false;
        }
        return res;
    }

    protected void setValidator() {
    }

    protected boolean validate(List<String> msgList) {
        if (this.positions.getValue() != null && !this.positions.getValue().equals("")) {
            StringTokenizer st = new StringTokenizer(this.positions.getValue(), ",");
            ALStringField field = null;
            block0: while (st.hasMoreTokens()) {
                field = new ALStringField();
                field.setTrim(true);
                field.setValue(st.nextToken());
                field.limitMaxLength(30);
                field.setCharacterType(19);
                field.validate(msgList);
                String unameValue = field.getValue();
                int length = unameValue.length();
                for (int i1 = 0; i1 < length; ++i1) {
                    if (!this.isSymbol(unameValue.charAt(i1)) || unameValue.charAt(i1) == "_".charAt(0) || unameValue.charAt(i1) == "-".charAt(0) || unameValue.charAt(i1) == ".".charAt(0)) continue;
                    msgList.add(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_ALERT_LOGINNAME_CHAR0", (Object[])new Object[0]));
                    continue block0;
                }
            }
        }
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"AccountChangeTurnFormData.loadFormData", (Throwable)e);
            return false;
        }
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        boolean res = true;
        try {
            Expression exp1 = ExpressionFactory.inExp((String)"loginName", (Object[])this.userNames);
            SelectQuery query = Database.query(TurbineUser.class, (Expression)exp1);
            query.orderAscending("eipMUserPosition.position");
            List list = query.fetchList();
            LinkedHashMap<String, TurbineUser> loginnameUserMap = new LinkedHashMap<String, TurbineUser>();
            for (TurbineUser user : list) {
                loginnameUserMap.put(user.getLoginName(), user);
            }
            int newPosition = 1;
            for (String name : this.userNames) {
                TurbineUser user = (TurbineUser)loginnameUserMap.get(name);
                EipMUserPosition userPosition = user.getEipMUserPosition();
                userPosition.setPosition(Integer.valueOf(newPosition));
                ++newPosition;
            }
            Database.commit();
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"AccountChangeTurnFormData.updateFormData", (Throwable)e);
            res = false;
        }
        return res;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    protected boolean isSymbol(char ch) {
        byte[] chars;
        try {
            chars = Character.valueOf(ch).toString().getBytes("shift_jis");
        }
        catch (UnsupportedEncodingException ex) {
            return false;
        }
        return chars != null && chars.length != 2 && !Character.isDigit(ch) && !Character.isLetter(ch);
    }

    private TurbineUser getEipUserRecord(List<TurbineUser> userList, String userName) {
        int size = userList.size();
        for (int i = 0; i < size; ++i) {
            TurbineUser record = userList.get(i);
            if (!record.getLoginName().equals(userName)) continue;
            return record;
        }
        return null;
    }

    public List<ALEipUser> getUserList() {
        return this.userList;
    }
}

