/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.account;

import com.aimluck.eip.account.AccountUserMultiDelete;
import com.aimluck.eip.account.util.AccountUtils;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.config.ALConfigHandler;
import com.aimluck.eip.services.config.ALConfigService;
import com.aimluck.eip.services.datasync.ALDataSyncFactoryService;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AccountUserMultiDisable
extends ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AccountUserMultiDelete.class.getName());

    protected boolean action(RunData rundata, Context context, List<String> values, List<String> msgList) {
        try {
            if (!ALDataSyncFactoryService.getInstance().getDataSyncHandler().checkConnect()) {
                msgList.add(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_ALERT_CONNECT_DB_FAILED", (Object[])new Object[0]));
                return false;
            }
            Expression exp = ExpressionFactory.inExp((String)"loginName", values);
            SelectQuery query = Database.query(TurbineUser.class, (Expression)exp);
            List ulist = query.fetchList();
            if (ulist == null || ulist.size() == 0) {
                return false;
            }
            int size = ulist.size();
            int admin_count = 0;
            String[] user_name_list = new String[size];
            for (TurbineUser user : ulist) {
                if (user.getLoginName().equals(rundata.getUser().getUserName())) {
                    msgList.add(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_ALERT_DISABLE_LOGINUSER", (Object[])new Object[0]));
                    return false;
                }
                if (!ALEipUtils.isAdmin((int)user.getUserId())) continue;
                ++admin_count;
            }
            if (!AccountUtils.isAdminDeletable(admin_count)) {
                msgList.add(ALLocalizationUtils.getl10nFormat((String)"ACCOUNT_ALERT_NUMOFADMINS_LIMIT", (Object[])new Object[]{Integer.valueOf(ALConfigService.get((ALConfigHandler.Property)ALConfigHandler.Property.MINIMUM_ADMINISTRATOR_USER_COUNT))}));
                return false;
            }
            for (int i = 0; i < size; ++i) {
                String user_name;
                TurbineUser record = (TurbineUser)ulist.get(i);
                user_name_list[i] = user_name = record.getLoginName();
                if (user_name == null) {
                    return false;
                }
                TurbineUser user = (TurbineUser)Database.get(TurbineUser.class, (String)"LOGIN_NAME", (Object)user_name);
                if (ALEipUtils.isAdmin((int)user.getUserId()) && !AccountUtils.isAdminDeletable()) {
                    return false;
                }
                user.setPositionId(Integer.valueOf(0));
                user.setDisabled("N");
                AccountUtils.acceptWorkflow(user.getUserId());
                String name = "";
                name = user.getLastName() != null && !" ".equals(user.getLastName()) && user.getFirstName() != null && !" ".equals(user.getFirstName()) ? new StringBuffer().append(user.getLastName()).append(" ").append(user.getFirstName()).toString() : user.getEmail();
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(user.getUserId().intValue(), 3, "\u30e6\u30fc\u30b6\u30fc\u300c" + name + "\u300d\u3092\u7121\u52b9\u5316");
            }
            Database.commit();
            if (!ALDataSyncFactoryService.getInstance().getDataSyncHandler().multiDisableUser(user_name_list, size)) {
                return false;
            }
            return msgList.size() == 0;
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"AccountUserMultiDisable.action", (Throwable)e);
            return false;
        }
    }
}

