/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.actions.webmail;

import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.modules.actions.webmail.WebMailAction;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.webmail.CellWebMailAccountSelectData;
import com.aimluck.eip.webmail.WebMailFormData;
import com.aimluck.eip.webmail.WebMailSelectData;
import com.aimluck.eip.webmail.util.WebMailUtils;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CellWebMailAction
extends WebMailAction {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CellWebMailAction.class.getName());

    @Override
    protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata) {
    }

    @Override
    protected void buildMaximizedContext(VelocityPortlet portlet, Context context, RunData rundata) {
        String mode = rundata.getParameters().getString("mode");
        try {
            if (!"form".equals(mode) && !"detail".equals(mode) && "list".equals(mode)) {
                this.doWebmail_account_list(rundata, context);
            }
            if (this.getMode() == null) {
                this.doWebmail_menu(rundata, context);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"[ScheduleAction] Exception.", (Throwable)ex);
            ALEipUtils.redirectDBError((RunData)rundata);
        }
    }

    public void doWebmail_create_mail(RunData rundata, Context context) throws Exception {
        ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"entityid");
        String accountId = rundata.getParameters().getString("accountid");
        if (accountId != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"accountid", (String)accountId);
        }
        this.showMailForm(rundata, context);
    }

    private void showMailForm(RunData rundata, Context context) {
        WebMailFormData formData = new WebMailFormData();
        formData.initField();
        formData.doViewForm((ALAction)this, rundata, context);
        this.setTemplate(rundata, "webmail-form");
    }

    public void doWebmail_show_mail(RunData rundata, Context context) throws Exception {
        WebMailSelectData detailData = new WebMailSelectData();
        detailData.initField();
        detailData.loadMailAccountList(rundata, context);
        boolean result = detailData.doViewDetail((ALAction)this, rundata, context);
        String mailIndex = rundata.getParameters().getString("entityid");
        context.put("accountid", (Object)ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"accountid"));
        context.put("currentTab", (Object)ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"tab"));
        context.put("entityid", (Object)mailIndex);
        context.put("hasError", (Object)(!result ? 1 : 0));
        this.setTemplate(rundata, "webmail-detail");
    }

    public void doWebmail_show_received_mails(RunData rundata, Context context) throws Exception {
        this.setAccountIdToSession(rundata, context);
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)"receive");
        this.doWebmail_list(rundata, context);
    }

    public void doWebmail_show_sent_mails(RunData rundata, Context context) throws Exception {
        this.setAccountIdToSession(rundata, context);
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)"sent");
        this.doWebmail_list(rundata, context);
    }

    @Override
    public void doWebmail_receive_mails(RunData rundata, Context context) throws Exception {
        this.setAccountIdToSession(rundata, context);
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"start_recieve", (String)"1");
        WebMailUtils.receiveMailsThread(rundata, context);
        this.doWebmail_show_received_mails(rundata, context);
    }

    private void setAccountIdToSession(RunData rundata, Context context) {
        String accountId = rundata.getParameters().getString("accountid");
        if (accountId != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"accountid", (String)accountId);
        }
    }

    public void doWebmail_menu(RunData rundata, Context context) {
        ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"accountid");
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"WebMail_Normal", (String)"true");
        int rowsNum = Integer.parseInt(ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p1b-rows"));
        CellWebMailAccountSelectData listData = new CellWebMailAccountSelectData();
        listData.initField();
        listData.setRowsNum(rowsNum);
        listData.doViewList((ALAction)this, rundata, context);
        this.setTemplate(rundata, "webmail-menu");
    }

    public void doWebmail_pageview(RunData rundata, Context context) throws Exception {
        WebMailSelectData listData = new WebMailSelectData();
        listData.initField();
        listData.loadMailAccountList(rundata, context);
        VelocityPortlet portlet = ALEipUtils.getPortlet((RunData)rundata, (Context)context);
        listData.setRowsNum(Integer.parseInt(portlet.getPortletConfig().getInitParameter("p1b-rows")));
        listData.setStrLength(0);
        listData.doViewList((ALAction)this, rundata, context);
        this.setTemplate(rundata, "webmail-list");
    }

    public void doWebmail_send_mail(RunData rundata, Context context) throws Exception {
        WebMailFormData formData = new WebMailFormData();
        formData.initField();
        if (formData.doInsert((ALAction)this, rundata, context)) {
            this.doWebmail_list(rundata, context);
        } else {
            this.setTemplate(rundata, "webmail-form");
        }
    }
}

