/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.webmail;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipMMailAccount;
import com.aimluck.eip.cayenne.om.portlet.EipTMailFilter;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import com.aimluck.eip.webmail.WebMailFilterResultData;
import java.util.ArrayList;
import java.util.List;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class WebMailFilterOrderFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WebMailFilterOrderFormData.class.getName());
    private ALStringField positions;
    private EipMMailAccount mailAccount;
    private List<WebMailFilterResultData> filterList = null;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        int mailAccountId = 0;
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context)) {
            try {
                mailAccountId = rundata.getParameters().containsKey((Object)"accountid") ? Integer.parseInt(rundata.getParameters().get("accountid")) : Integer.parseInt(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"accountid"));
            }
            catch (Exception e) {
                return;
            }
        }
        ALEipUser login_user = ALEipUtils.getALEipUser((RunData)rundata);
        this.mailAccount = ALMailUtils.getMailAccount((int)((int)login_user.getUserId().getValue()), (int)mailAccountId);
        if (this.mailAccount == null) {
            return;
        }
        this.filterList = new ArrayList<WebMailFilterResultData>();
    }

    public void initField() {
        this.positions = new ALStringField();
        this.positions.setFieldName(ALLocalizationUtils.getl10n((String)"WEBMAIL_FILTER_LIST"));
        this.positions.setTrim(true);
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = true;
        if (this.mailAccount == null) {
            return res;
        }
        try {
            res = super.setFormData(rundata, context, msgList);
            if (res) {
                List filters = ALMailUtils.getEipTMailFilters((EipMMailAccount)this.mailAccount);
                for (EipTMailFilter filter : filters) {
                    WebMailFilterResultData rd = new WebMailFilterResultData();
                    rd.initField();
                    rd.setFilterId(filter.getFilterId().longValue());
                    rd.setFilterName(filter.getFilterName());
                    this.filterList.add(rd);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"webmail", (Throwable)ex);
            return false;
        }
        return res;
    }

    protected void setValidator() {
    }

    protected boolean validate(List<String> msgList) {
        return this.positions.getValue() != null && !this.positions.getValue().equals("");
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"webmail", (Throwable)e);
            return false;
        }
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        boolean res = true;
        try {
            if (this.positions.getValue() != null && !this.positions.getValue().equals("")) {
                String[] orders = this.positions.getValue().split(",");
                ArrayList<String> order = new ArrayList<String>();
                for (String rs : orders) {
                    order.add(rs);
                }
                List filters = ALMailUtils.getEipTMailFilters((EipMMailAccount)this.mailAccount);
                for (EipTMailFilter filter : filters) {
                    String filter_id = filter.getFilterId().toString();
                    int order_num = order.indexOf(filter_id);
                    if (order_num != -1) {
                        filter.setSortOrder(Integer.valueOf(order_num + 1));
                        continue;
                    }
                    throw new Exception();
                }
                Database.commit();
            }
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"webmail", (Throwable)e);
            res = false;
        }
        return res;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    public List<WebMailFilterResultData> getFilterList() {
        return this.filterList;
    }
}

