/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.webmail;

import com.aimluck.commons.utils.ALDateUtil;
import com.aimluck.eip.cayenne.om.portlet.EipMMailAccount;
import com.aimluck.eip.cayenne.om.portlet.EipTMailFolder;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.webmail.WebMailFolderResultData;
import com.aimluck.eip.webmail.beans.WebmailAccountLiteBean;
import com.aimluck.eip.webmail.util.WebMailUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class WebMailFolderSelectData
extends ALAbstractSelectData<EipTMailFolder, EipTMailFolder> {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WebMailFolderSelectData.class.getName());
    String folder_id = null;
    private EipMMailAccount mail_account;
    private List<WebmailAccountLiteBean> mailAccountList;
    private List<WebMailFolderResultData> mailFolderList;
    private Map<Integer, Integer> unreadMailSumMap;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        int mailAccountId = 0;
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context)) {
            if (rundata.getParameters().containsKey((Object)"folderid")) {
                this.folder_id = rundata.getParameters().get("folderid");
            }
            mailAccountId = rundata.getParameters().containsKey((Object)"accountid") ? rundata.getParameters().getInt("accountid") : Integer.parseInt(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"accountid"));
        }
        ALEipUser login_user = ALEipUtils.getALEipUser((RunData)rundata);
        this.mail_account = ALMailUtils.getMailAccount((int)((int)login_user.getUserId().getValue()), (int)mailAccountId);
        if (this.mail_account == null) {
            return;
        }
        this.mailFolderList = WebMailUtils.getMailFolderAll(this.mail_account);
        this.unreadMailSumMap = WebMailUtils.getUnreadMailNumberMap(rundata, ALEipUtils.getUserId((RunData)rundata), mailAccountId);
        super.init(action, rundata, context);
    }

    protected ResultList<EipTMailFolder> selectList(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        SelectQuery<EipTMailFolder> query = this.getSelectQuery(rundata, context);
        this.buildSelectQueryForListView(query);
        this.buildSelectQueryForListViewSort(query, rundata, context);
        return query.getResultList();
    }

    private SelectQuery<EipTMailFolder> getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = Database.query(EipTMailFolder.class);
        Expression exp = ExpressionFactory.matchDbExp((String)"eipMMailAccount", (Object)this.mail_account);
        query.setQualifier(exp);
        return query;
    }

    protected EipTMailFolder selectDetail(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        return WebMailUtils.getEipTMailFolder(this.mail_account, ALEipUtils.getParameter((RunData)rundata, (Context)context, (String)"folderid"));
    }

    protected WebMailFolderResultData getResultData(EipTMailFolder obj) throws ALPageNotFoundException, ALDBErrorException {
        return new WebMailFolderResultData(obj);
    }

    protected Object getResultDataDetail(EipTMailFolder record) throws ALPageNotFoundException, ALDBErrorException {
        try {
            this.folder_id = record.getFolderId().toString();
            WebMailFolderResultData rd = new WebMailFolderResultData();
            rd.initField();
            rd.setFolderId(record.getFolderId());
            rd.setFolderName(record.getFolderName());
            rd.setCreateDate(ALDateUtil.format((Date)record.getCreateDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
            if (this.mail_account.getDefaultFolderId().equals(record.getFolderId())) {
                rd.setCanUpdate(false);
            } else {
                rd.setCanUpdate(true);
            }
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"webmail", (Throwable)ex);
            return null;
        }
    }

    public void loadMailAccountList(RunData rundata, Context context) {
        this.mailAccountList = WebMailUtils.getMailAccountList(rundata, context);
    }

    public List<WebmailAccountLiteBean> getMailAccountList() {
        return this.mailAccountList;
    }

    public List<WebMailFolderResultData> getFolderList() {
        return this.mailFolderList;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("folder_name", "folderName");
        return map;
    }

    public String getFolderId() {
        return this.folder_id;
    }

    public int getUnReadMailSumByFolderId(int folder_id) {
        return this.unreadMailSumMap.get(folder_id);
    }

    public int getAccountId() {
        return this.mail_account.getAccountId();
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }
}

