/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.webmail;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.cayenne.om.portlet.EipMMailAccount;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileupload.beans.FileuploadLiteBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.mail.ALFolder;
import com.aimluck.eip.mail.ALLocalMailMessage;
import com.aimluck.eip.mail.ALMailContext;
import com.aimluck.eip.mail.ALMailFactoryService;
import com.aimluck.eip.mail.ALMailHandler;
import com.aimluck.eip.mail.ALMailSenderContext;
import com.aimluck.eip.mail.ALSmtpMailContext;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.services.portal.ALPortalApplicationService;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import com.aimluck.eip.webmail.beans.WebmailAccountLiteBean;
import com.aimluck.eip.webmail.util.WebMailUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class WebMailFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WebMailFormData.class.getName());
    private final int FIELD_SUBJECT_MAX_LEN = 256;
    private final int FIELD_RECIPIENT_MAX_LEN = 512;
    private final int FIELD_BODY_MAX_LEN = 50000;
    public static final int TYPE_DEF_MAIL = -1;
    public static final int TYPE_NEW_MAIL = 0;
    public static final int TYPE_REPLY_MAIL = 1;
    public static final int TYPE_FORWARD_MAIL = 2;
    public static final int TYPE_REPLY_ALL_MAIL = 3;
    private ALNumberField mailType = null;
    private ALStringField to = null;
    private ALStringField cc = null;
    private ALStringField bcc = null;
    private ALStringField subject = null;
    private ALStringField body = null;
    private List<FileuploadLiteBean> fileuploadList = null;
    private String folderName = null;
    private int userId = -1;
    private int accountId = -1;
    private List<WebmailAccountLiteBean> mailAccountList = null;
    private String orgId;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.userId = ALEipUtils.getUserId((RunData)rundata);
        try {
            this.accountId = Integer.parseInt(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"accountid"));
        }
        catch (Exception e) {
            this.accountId = 0;
        }
        this.folderName = rundata.getParameters().getString("folderName");
        this.orgId = Database.getDomainName();
        this.mailAccountList = WebMailUtils.getMailAccountList(rundata, context);
    }

    public void initField() {
        this.mailType = new ALNumberField();
        this.mailType.setFieldName(ALLocalizationUtils.getl10n((String)"WEBMAIL_SETFIELDNAME_TYPE"));
        this.to = new ALStringField();
        this.to.setFieldName(ALLocalizationUtils.getl10n((String)"WEBMAIL_SETFIELDNAME_TO"));
        this.to.setTrim(true);
        this.cc = new ALStringField();
        this.cc.setFieldName(ALLocalizationUtils.getl10n((String)"WEBMAIL_SETFIELDNAME_CC"));
        this.cc.setTrim(true);
        this.bcc = new ALStringField();
        this.bcc.setFieldName(ALLocalizationUtils.getl10n((String)"WEBMAIL_SETFIELDNAME_BCC"));
        this.bcc.setTrim(true);
        this.subject = new ALStringField();
        this.subject.setFieldName(ALLocalizationUtils.getl10n((String)"WEBMAIL_SETFIELDNAME_SUBJECT"));
        this.subject.setTrim(true);
        this.body = new ALStringField();
        this.body.setFieldName(ALLocalizationUtils.getl10n((String)"WEBMAIL_SETFIELDNAME_BODY"));
        this.body.setTrim(false);
        this.fileuploadList = new ArrayList<FileuploadLiteBean>();
    }

    protected void setValidator() {
        this.to.setNotNull(true);
        this.to.limitMaxLength(512);
        this.cc.limitMaxLength(512);
        this.bcc.limitMaxLength(512);
        this.subject.limitMaxLength(256);
        this.body.limitMaxLength(50000);
    }

    public boolean validate(List<String> msgList) {
        String delim = ",;";
        if (this.to.validate(msgList) && !WebMailUtils.checkAddress(this.to.getValue(), delim)) {
            msgList.add("\u300e <span class='em'>\u5b9b\u5148</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        if (this.cc.validate(msgList) && this.cc.getValue().trim().length() > 0 && !WebMailUtils.checkAddress(this.cc.getValue(), delim)) {
            msgList.add("\u300e <span class='em'>CC</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        if (this.bcc.validate(msgList) && this.bcc.getValue().trim().length() > 0 && !WebMailUtils.checkAddress(this.bcc.getValue(), delim)) {
            msgList.add("\u300e <span class='em'>BCC</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        this.subject.validate(msgList);
        this.body.validate(msgList);
        return msgList.size() == 0;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            int index;
            try {
                index = Integer.parseInt(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid"));
            }
            catch (Exception e) {
                return false;
            }
            String currentTab = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"tab");
            int type_mail = "receive".equals(currentTab) ? 1 : 2;
            ALMailHandler handler = ALMailFactoryService.getInstance().getMailHandler();
            ALFolder folder = handler.getALFolder(type_mail, this.orgId, this.userId, Integer.valueOf(this.accountId).intValue());
            folder.deleteMail(index);
        }
        catch (Exception e) {
            logger.error((Object)"webmail", (Throwable)e);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        block19: {
            String[] attachmentFilepaths = null;
            try {
                ALSmtpMailContext mailcontext;
                ALMailSenderContext scontext;
                boolean hasAttachments;
                FileuploadLiteBean filebean = null;
                boolean bl = hasAttachments = this.fileuploadList != null && this.fileuploadList.size() > 0;
                if (hasAttachments) {
                    int size = this.fileuploadList.size();
                    attachmentFilepaths = new String[size];
                    for (int i = 0; i < size; ++i) {
                        filebean = this.fileuploadList.get(i);
                        attachmentFilepaths[i] = ALStorageService.getDocumentPath((String)FileuploadUtils.FOLDER_TMP_FOR_ATTACHMENT_FILES, (String)(this.userId + ALStorageService.separator() + this.folderName)) + ALStorageService.separator() + filebean.getFileId();
                    }
                }
                if (this.subject.getValue() == null || this.subject.getValue().equals("")) {
                    this.subject.setValue("\u7121\u984c");
                }
                LinkedHashMap<String, String> map = null;
                if (this.getMailType().getValue() == 1L || this.getMailType().getValue() == 3L) {
                    ALLocalMailMessage msg = null;
                    try {
                        msg = (ALLocalMailMessage)WebMailUtils.getSelectedLocalMailMessage(rundata, context, (int)this.getMailType().getValue());
                        if (msg == null) {
                            return false;
                        }
                    }
                    catch (Exception e) {
                        return false;
                    }
                    String in_reply_tos = msg.getMessageID();
                    StringBuffer reference = new StringBuffer();
                    String[] references = msg.getHeader("References");
                    map = new LinkedHashMap<String, String>();
                    if (references != null && references.length > 0) {
                        reference.append(ALMailUtils.getOneString((String[])references, (String)" "));
                    }
                    if (in_reply_tos != null && !in_reply_tos.equals("")) {
                        map.put("In-Reply-To", in_reply_tos);
                        reference.append(" ").append(in_reply_tos);
                    }
                    map.put("References", reference.toString());
                }
                if (map != null && map.size() == 0) {
                    map = null;
                }
                String delim = ",;";
                EipMMailAccount account = ALMailUtils.getMailAccount((int)this.userId, (int)this.accountId);
                ALMailHandler handler = ALMailFactoryService.getInstance().getMailHandler();
                int success_send = handler.send(scontext = ALMailUtils.getALSmtpMailSenderContext((String)this.orgId, (EipMMailAccount)account), (ALMailContext)(mailcontext = ALMailUtils.getALSmtpMailContext((String[])ALMailUtils.getTokens((String)ALStringUtil.unsanitizing((String)this.to.getValue()), (String)delim), (String[])ALMailUtils.getTokens((String)ALStringUtil.unsanitizing((String)this.cc.getValue()), (String)delim), (String[])ALMailUtils.getTokens((String)ALStringUtil.unsanitizing((String)this.bcc.getValue()), (String)delim), (String)account.getMailAddress(), (String)ALStringUtil.unsanitizing((String)account.getMailUserName()), (String)ALStringUtil.unsanitizing((String)this.subject.getValue()), (String)ALStringUtil.unsanitizing((String)this.body.getValue()), (String[])attachmentFilepaths, map)));
                if (success_send == 0) {
                    if (hasAttachments) {
                        ALStorageService.deleteTmpFolder((int)this.userId, (String)this.folderName);
                    }
                    break block19;
                }
                if (success_send == 1) {
                    msgList.add("\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002\u30a2\u30ab\u30a6\u30f3\u30c8\u8a2d\u5b9a\u304c\u9593\u9055\u3063\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002");
                } else if (success_send == 2) {
                    msgList.add(String.valueOf(FileuploadUtils.getMaxFileSize()).concat("MB \u3092\u8d85\u3048\u308b\u30b5\u30a4\u30ba\u306e\u30e1\u30fc\u30eb\u306f\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3002"));
                } else if (success_send == 5) {
                    msgList.add("\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002SMTP\u8a8d\u8a3c\u306e\u8a8d\u8a3c\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                }
                return false;
            }
            catch (Exception e) {
                logger.error((Object)"webmail", (Throwable)e);
                msgList.add("\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002\u30a2\u30ab\u30a6\u30f3\u30c8\u8a2d\u5b9a\u304c\u9593\u9055\u3063\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002");
                return false;
            }
        }
        return true;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        this.mailType.setValue((long)rundata.getParameters().getInt("mailtype", 0));
        try {
            ALLocalMailMessage msg = (ALLocalMailMessage)WebMailUtils.getSelectedLocalMailMessage(rundata, context, (int)this.getMailType().getValue());
            if (msg == null) {
                return false;
            }
            String tmpSubject = null;
            if (this.getMailType().getValue() == 0L) {
                Address[] tos = msg.getRecipients(Message.RecipientType.TO);
                this.setTo(ALMailUtils.getAddressString((Address[])tos));
                Address[] ccs = msg.getRecipients(Message.RecipientType.CC);
                this.setCc(ALMailUtils.getAddressString((Address[])ccs));
                Address[] bccs = msg.getRecipients(Message.RecipientType.BCC);
                this.setBcc(ALMailUtils.getAddressString((Address[])bccs));
                tmpSubject = msg.getSubject();
            } else if (this.getMailType().getValue() == 1L) {
                this.setTo(ALMailUtils.getFromDelegateExtract((MimeMessage)msg));
                tmpSubject = "Re: " + msg.getSubject();
            } else if (this.getMailType().getValue() == 2L) {
                tmpSubject = "Fwd: " + msg.getSubject();
            } else if (this.getMailType().getValue() == 3L) {
                Address[] from = ALMailUtils.getFromDelegateExtractForAddress((MimeMessage)msg);
                Address[] to = msg.getRecipients(Message.RecipientType.TO, false);
                String[] myaccount = ALMailUtils.getMailAccount((int)this.userId, (int)this.accountId);
                String myaddress = myaccount.getMailAddress();
                ArrayList<Address> allList = new ArrayList<Address>();
                allList.addAll(Arrays.asList(from));
                allList.addAll(Arrays.asList(to));
                ArrayList<Address> replayList = new ArrayList<Address>();
                for (Address address : allList) {
                    InternetAddress internetAddress;
                    String email;
                    if (!(address instanceof InternetAddress) || (email = (internetAddress = (InternetAddress)address).getAddress()) == null || email.equalsIgnoreCase(myaddress) || email.contains("<" + myaddress + ">")) continue;
                    replayList.add(address);
                }
                this.setTo(ALMailUtils.getAddressString((Address[])replayList.toArray(new Address[replayList.size()])));
                Address[] ccs = msg.getRecipients(Message.RecipientType.CC, false);
                this.setCc(ALMailUtils.getAddressString((Address[])ccs));
                Address[] bccs = msg.getRecipients(Message.RecipientType.BCC);
                this.setBcc(ALMailUtils.getAddressString((Address[])bccs));
                tmpSubject = "Re: " + msg.getSubject();
            }
            this.setSubject(tmpSubject);
            String[] tmp2 = msg.getBodyTextArray();
            StringBuffer replies = new StringBuffer();
            replies.append("\r\n\r\n\r\n------Original Message-------\r\n");
            if (tmp2 != null) {
                for (String factor : tmp2) {
                    replies.append("> " + factor + "\r\n");
                }
            }
            try {
                EipMMailAccount account = ALMailUtils.getMailAccount((int)this.userId, (int)this.accountId);
                if (account.getSignature() != null && !"".equals(account.getSignature())) {
                    this.body.setValue(replies + "\r\n\r\n\r\n" + account.getSignature());
                } else {
                    this.body.setValue(replies.toString());
                }
            }
            catch (Exception ex) {
                logger.error((Object)"webmail", (Throwable)ex);
            }
            if (this.getMailType().getValue() == 2L) {
                msg = (ALLocalMailMessage)WebMailUtils.getSelectedLocalMailMessage(rundata, context, 0);
                if (msg == null) {
                    return false;
                }
                String[] filenames = msg.getAttachmentFileNameArray();
                if (filenames != null && filenames.length > 0) {
                    if (this.folderName == null || this.folderName.equals("")) {
                        this.folderName = "undefined";
                    }
                    for (int i = 0; i < filenames.length; ++i) {
                        int fileId = Long.valueOf(System.nanoTime()).intValue();
                        String newAttachmentFileName = String.valueOf(fileId);
                        String realfilename = filenames[i];
                        if (realfilename == null) continue;
                        ALStorageService.createNewTmpFile((InputStream)msg.getInputStream(i), (int)this.userId, (String)this.folderName, (String)newAttachmentFileName, (String)realfilename);
                        FileuploadLiteBean filebean = new FileuploadLiteBean();
                        filebean.initField();
                        filebean.setFileId(fileId);
                        filebean.setFileName(realfilename);
                        filebean.setFolderName(this.folderName);
                        this.fileuploadList.add(filebean);
                    }
                }
            }
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"webmail", (Throwable)e);
            return false;
        }
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        return false;
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        if (this.accountId <= 0 || this.userId <= 0) {
            return res;
        }
        try {
            this.fileuploadList = FileuploadUtils.getFileuploadList((RunData)rundata);
            EipMMailAccount account = ALMailUtils.getMailAccount((int)this.userId, (int)this.accountId);
            if (!"insert".equals(rundata.getParameters().get("mode")) && account.getSignature() != null && !"".equals(account.getSignature())) {
                StringBuffer bodybuf = new StringBuffer();
                if (this.body.getValue() != null) {
                    bodybuf.append(this.body.getValue());
                }
                bodybuf.append("\r\n\r\n\r\n");
                bodybuf.append(account.getSignature());
                this.body.setValue(bodybuf.toString());
            }
        }
        catch (Exception ex) {
            logger.error((Object)"webmail", (Throwable)ex);
        }
        return res;
    }

    public ALStringField getBcc() {
        return this.bcc;
    }

    public ALStringField getBody() {
        return this.body;
    }

    public ALStringField getCc() {
        return this.cc;
    }

    public ALStringField getSubject() {
        return this.subject;
    }

    public ALStringField getTo() {
        return this.to;
    }

    public ALNumberField getMailType() {
        return this.mailType;
    }

    public int getMaxFileSize() {
        return FileuploadUtils.getMaxFileSize();
    }

    public void setMailType(int field) {
        this.mailType.setValue((long)field);
    }

    public void setBcc(String string) {
        this.bcc.setValue(string);
    }

    public void setBody(String string) {
        this.body.setValue(string);
    }

    public void setCc(String string) {
        this.cc.setValue(string);
    }

    public void setSubject(String string) {
        this.subject.setValue(string);
    }

    public void setTo(String string) {
        this.to.setValue(string);
    }

    public String getAccountName() {
        return ALMailUtils.getAccountName((int)this.userId, (int)this.accountId);
    }

    public Map<Integer, ALEipPost> getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public List<FileuploadLiteBean> getAttachmentFileNameList() {
        return this.fileuploadList;
    }

    public boolean hasAuthorityAddressBook() {
        return ALPortalApplicationService.isActive((String)"AddressBook");
    }

    public String getFolderName() {
        return this.folderName;
    }

    public int getAccountId() {
        return this.accountId;
    }

    public String getAddrForCell(ALStringField addrs_filed) {
        if (addrs_filed == null) {
            return "";
        }
        String addrs = addrs_filed.getValue();
        if (addrs == null || addrs.length() == 0) {
            return "";
        }
        StringBuffer addrbuf = new StringBuffer();
        int count = 0;
        String token = null;
        StringTokenizer st = new StringTokenizer(addrs, ",");
        int size = st.countTokens();
        for (int i = 0; i < size; ++i) {
            token = st.nextToken();
            if (token.indexOf("<") == -1) {
                addrbuf.append(token);
            } else {
                StringTokenizer tmp_st = new StringTokenizer(token, "<>");
                if (tmp_st.countTokens() == 2) {
                    tmp_st.nextToken();
                    addrbuf.append(tmp_st.nextToken());
                }
            }
            if (++count >= size) continue;
            addrbuf.append(",");
        }
        return addrbuf.toString();
    }

    public boolean isExistsAccount() {
        return this.mailAccountList != null && this.mailAccountList.size() > 0;
    }
}

