/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.workflow;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRequest;
import com.aimluck.eip.cayenne.om.portlet.EipTWorkflowRequestMap;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import com.aimluck.eip.workflow.util.WorkflowUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class WorkflowConfirmFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WorkflowConfirmFormData.class.getName());
    private ALStringField comment;
    private boolean accept_flg;
    private ALNumberField passback_order;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
    }

    public void initField() {
        this.comment = new ALStringField();
        this.comment.setFieldName(ALLocalizationUtils.getl10n((String)"WORKFLOW_COMMENT"));
        this.comment.setTrim(true);
        this.accept_flg = false;
        this.passback_order = new ALNumberField();
    }

    protected void setValidator() {
        this.comment.limitMaxLength(1000);
        if (!this.accept_flg) {
            this.passback_order.setNotNull(true);
            this.passback_order.limitMinValue(0L);
        }
    }

    protected boolean validate(List<String> msgList) {
        this.comment.validate(msgList);
        if (!this.accept_flg) {
            this.passback_order.validate(msgList);
        }
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            int login_user_id = ALEipUtils.getUserId((RunData)rundata);
            EipTWorkflowRequest request = WorkflowUtils.getEipTWorkflowRequest(rundata, context, true);
            if (request == null) {
                return false;
            }
            List<EipTWorkflowRequestMap> maps = WorkflowUtils.getEipTWorkflowRequestMap(request);
            WorkflowRequestMapHandler mapHandler = new WorkflowRequestMapHandler(maps);
            EipTWorkflowRequestMap currentMap = mapHandler.getCurrentMap();
            Date now = Calendar.getInstance().getTime();
            if (currentMap.getUserId() != login_user_id) {
                return false;
            }
            if (this.accept_flg) {
                currentMap.setStatus("A");
                currentMap.setNote(this.comment.getValue());
                currentMap.setUpdateDate(now);
                mapHandler.changeStatusForNextUser();
                if (mapHandler.isApprovalForAll()) {
                    request.setProgress("A");
                    mapHandler.setFlowStatus(WorkflowUtils.Type.ACCEPT);
                    ArrayList<Integer> excludeUserList = new ArrayList<Integer>();
                    excludeUserList.add(login_user_id);
                    mapHandler.setSendMailMapsForAll(excludeUserList);
                    mapHandler.setRecipientsForAll(excludeUserList);
                } else {
                    mapHandler.setFlowStatus(WorkflowUtils.Type.REQUEST);
                    EipTWorkflowRequestMap nextRequestMap = maps.get(mapHandler.getLatestOrderIndex());
                    mapHandler.addSendMailMaps(nextRequestMap);
                    mapHandler.addRecipients(nextRequestMap);
                }
            } else {
                currentMap.setStatus("D");
                currentMap.setNote(this.comment.getValue());
                currentMap.setUpdateDate(now);
                int passback_user_order = (int)this.passback_order.getValue();
                if (mapHandler.isApplicantUser(passback_user_order) && !WorkflowUtils.isDisabledOrDeleted(mapHandler.getApplicantUserMap().getUserId())) {
                    request.setProgress("D");
                    mapHandler.setFlowStatus(WorkflowUtils.Type.DENAIL);
                    mapHandler.addSendMailMapsForApplicantAndApprover(login_user_id);
                    mapHandler.addRecipientsApplicantOnly();
                } else {
                    boolean result = mapHandler.passbackToApprover(passback_user_order, login_user_id);
                    if (!result) {
                        request.setProgress("A");
                        mapHandler.setFlowStatus(WorkflowUtils.Type.ACCEPT);
                        ArrayList<Integer> noList = new ArrayList<Integer>();
                        mapHandler.setSendMailMapsForAll(noList);
                        mapHandler.setRecipientsForAll(noList);
                    }
                }
            }
            request.setUpdateDate(now);
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(request.getRequestId().intValue(), 120, request.getEipTWorkflowCategory().getCategoryName() + " " + request.getRequestName());
            if (mapHandler.isRecipientsNotEmpty()) {
                ALEipUser user = ALEipUtils.getALEipUser((int)login_user_id);
                WorkflowUtils.createWorkflowRequestActivity(request, user.getName().getValue(), mapHandler.getRecipients(), mapHandler.getFlowStatus());
            }
            WorkflowUtils.sendMailForUpdate(rundata, mapHandler.getSendMailMaps(), request, this.comment.getValue(), mapHandler.getFlowStatus());
        }
        catch (ALPageNotFoundException ex) {
            Database.rollback();
            msgList.add(ALLocalizationUtils.getl10n((String)"WORKFLOW_WORKFLOW_ALREADY_DELETED"));
            logger.error((Object)"[WorkflowConfirmFormData]", (Throwable)ex);
            return false;
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"workflow", (Throwable)ex);
            return false;
        }
        return true;
    }

    public void setAcceptFlg(boolean bool) {
        this.accept_flg = bool;
    }

    public String getAclPortletFeature() {
        return "workflow_request_self";
    }

    private static class WorkflowRequestMapHandler {
        EipTWorkflowRequestMap currentMap;
        int orderIndex;
        int latestOrderIndex;
        List<EipTWorkflowRequestMap> requestMaps;
        List<EipTWorkflowRequestMap> sendMailMaps;
        int requestMapSize;
        WorkflowUtils.Type flowStatus;
        List<String> recipients;

        public WorkflowRequestMapHandler(List<EipTWorkflowRequestMap> requestMaps) {
            this.requestMaps = requestMaps;
            this.currentMap = null;
            this.orderIndex = 0;
            this.sendMailMaps = new ArrayList<EipTWorkflowRequestMap>();
            this.requestMapSize = requestMaps.size();
            this.flowStatus = null;
            this.recipients = new ArrayList<String>();
            this.init();
        }

        public void init() {
            for (int i = 0; i < this.requestMapSize; ++i) {
                this.currentMap = this.requestMaps.get(i);
                if (!"C".equals(this.currentMap.getStatus())) continue;
                this.orderIndex = i;
                break;
            }
            this.latestOrderIndex = this.orderIndex;
        }

        public EipTWorkflowRequestMap getCurrentMap() {
            return this.currentMap;
        }

        public int getOrderInex() {
            return this.orderIndex;
        }

        public List<EipTWorkflowRequestMap> getSendMailMaps() {
            return this.sendMailMaps;
        }

        public int getRequestMapSize() {
            return this.requestMapSize;
        }

        public int getLatestOrderIndex() {
            return this.latestOrderIndex;
        }

        public WorkflowUtils.Type getFlowStatus() {
            return this.flowStatus;
        }

        public void setFlowStatus(WorkflowUtils.Type str) {
            this.flowStatus = str;
        }

        public List<String> getRecipients() {
            return this.recipients;
        }

        public void changeStatusForNextUser() {
            ++this.latestOrderIndex;
            while (this.latestOrderIndex < this.requestMapSize) {
                EipTWorkflowRequestMap nextRequestMap = this.requestMaps.get(this.latestOrderIndex);
                if (WorkflowUtils.isDisabledOrDeleted(nextRequestMap.getUserId())) {
                    nextRequestMap.setStatus("T");
                    ++this.latestOrderIndex;
                    continue;
                }
                nextRequestMap.setStatus("C");
                break;
            }
        }

        public boolean isApprovalForAll() {
            return this.getLatestOrderIndex() == this.requestMapSize;
        }

        public void setSendMailMapsForAll(List<Integer> excludeUserList) {
            for (EipTWorkflowRequestMap requestMap : this.requestMaps) {
                int userId = requestMap.getUserId();
                boolean isExclude = false;
                for (Integer excluedUserId : excludeUserList) {
                    if (userId != excluedUserId) continue;
                    isExclude = true;
                    break;
                }
                if (isExclude) continue;
                this.sendMailMaps.add(requestMap);
            }
        }

        public void addSendMailMaps(EipTWorkflowRequestMap requestMap) {
            this.sendMailMaps.add(requestMap);
        }

        public boolean isApplicantUser(int request_order) {
            return request_order == 0;
        }

        public EipTWorkflowRequestMap getApplicantUserMap() {
            return this.requestMaps.get(0);
        }

        public void addSendMailMapsForApplicantAndApprover(int loginUserId) {
            for (EipTWorkflowRequestMap requestMap : this.requestMaps) {
                if (requestMap.getUserId() == loginUserId) break;
                this.addSendMailMaps(requestMap);
            }
        }

        public void addSendMailMapsForApprover(int passbackUserId, int loginUserId) {
            boolean isStart = false;
            for (EipTWorkflowRequestMap requestMap : this.requestMaps) {
                int userId = requestMap.getUserId();
                if (userId == passbackUserId) {
                    isStart = true;
                }
                if (userId == loginUserId) break;
                if (!isStart) continue;
                this.addSendMailMaps(requestMap);
            }
        }

        public boolean passbackToApprover(int passbackUserOrderIndex, int loginUserId) {
            EipTWorkflowRequestMap passbackMap = this.getRequestMapByOrderIndex(passbackUserOrderIndex);
            if (null == passbackMap) {
                return false;
            }
            int passbackUserId = passbackMap.getUserId();
            if (passbackUserId == loginUserId) {
                this.currentMap.setStatus("C");
                this.setFlowStatus(WorkflowUtils.Type.DENAIL);
                this.addSendMailMaps(passbackMap);
                this.addRecipients(passbackMap);
                return true;
            }
            if (WorkflowUtils.isDisabledOrDeleted(passbackUserId)) {
                passbackMap.setStatus("T");
                return this.passbackToApprover(passbackUserOrderIndex + 1, loginUserId);
            }
            passbackMap.setStatus("C");
            this.setFlowStatus(WorkflowUtils.Type.DENAIL);
            this.addSendMailMapsForApprover(passbackUserId, loginUserId);
            this.addRecipients(passbackMap);
            return true;
        }

        public EipTWorkflowRequestMap getRequestMapByOrderIndex(int orderIndex) {
            for (EipTWorkflowRequestMap requestMap : this.requestMaps) {
                if (requestMap.getOrderIndex() != orderIndex) continue;
                return requestMap;
            }
            return null;
        }

        public boolean isSendMailMapsNotEmpty() {
            return null != this.sendMailMaps && this.sendMailMaps.size() > 0;
        }

        public void setRecipientsForAll(List<Integer> excludeUserList) {
            for (EipTWorkflowRequestMap requestMap : this.requestMaps) {
                int userId = requestMap.getUserId();
                boolean isExclude = false;
                for (Integer excluedUserId : excludeUserList) {
                    if (userId != excluedUserId) continue;
                    isExclude = true;
                    break;
                }
                if (isExclude) continue;
                try {
                    ALEipUser user = ALEipUtils.getALEipUser((int)requestMap.getUserId());
                    this.recipients.add(user.getName().getValue());
                }
                catch (ALDBErrorException e) {
                    logger.error((Object)"[WorkflowConfirmFormData]", (Throwable)e);
                }
            }
        }

        public void addRecipients(EipTWorkflowRequestMap requestMap) {
            try {
                ALEipUser user = ALEipUtils.getALEipUser((int)requestMap.getUserId());
                this.recipients.add(user.getName().getValue());
            }
            catch (ALDBErrorException e) {
                logger.error((Object)"[WorkflowConfirmFormData]", (Throwable)e);
            }
        }

        public void addRecipientsApplicantOnly() {
            this.addRecipients(this.requestMaps.get(0));
        }

        public boolean isRecipientsNotEmpty() {
            return null != this.recipients && this.recipients.size() > 0;
        }
    }
}

